#ifndef MLIB_MYLIB_H
#define MLIB_MYLIB_H

#define RESULT
#define ALLOCATED
#define RELEASE

///////////////////////////////////////////////////////////////////////////////
// my file function
///////////////////////////////////////////////////////////////////////////////
#include <sys/stat.h>

ALLOCATED char* extname(char* name);       // extention name
ALLOCATED char* noextname(char* name);     // without extension name
ALLOCATED char* parentname(char* path);    // parent dir name
ALLOCATED char* mygetcwd();                // current working directory
char* mygetpwuid(struct stat* statbuf);    // user name
char* mygetgrgid(struct stat* statbuf);    // group name

///////////////////////////////////////////////////////////////////////////////
// my curses function
///////////////////////////////////////////////////////////////////////////////
#include <curses.h>

void wmyclear(WINDOW* wnd);
void wmybox(WINDOW* wnd, int x, int y, int width, int height);
void wmyclear_online(WINDOW* wnd, int y);

#define myclear() wmyclear(stdscr)
#define myclear_online(y) wmyclear_online(stdscr, y)
#define mybox(x, y, w, h) wmybox(stdscr, x, y, w, h)

#endif
