#ifndef MFILER3_FILER_H
#define MFILER3_FILER_H

#include <oniguruma.h>

///////////////////////////////////////////////////
// sFile -- ファイルオブジェクト
///////////////////////////////////////////////////
typedef struct {
    string_obj* mName;                // ディスク内部の名前
    string_obj* mNameView;            // 表示する時の名前(iconvで変換後)
    string_obj* mLinkTo;              // リンク先
    struct stat64 mStat;              // stat()のキャッシュ
    struct stat64 mLStat;             // lstat()のキャッシュ
    BOOL mMark;                       // マークされているかどうか
    string_obj* mUser;                // ユーザー名
    string_obj* mGroup;               // グループ名

    int mSortRandom;                  // ランダムソート時の数値
} sFile;

sFile* sFile_new(char* name, char* name_view, char* linkto, struct stat64* stat_, struct stat64* lstat_, BOOL mark, char* user, char* group, int uid, int gid);

void add_fcolor(char* regex, int red, int green, int blue);

///////////////////////////////////////////////////
// sDir -- ディレクトリオブジェクト
///////////////////////////////////////////////////
typedef struct  {
    string_obj* mPath;          // 現在のディレクトリ最後は/
    string_obj* mMask;          // マスク
    BOOL mDotDirMask;           // ドットディレクトリのマスク

    regex_t* mMaskReg;          // マスクの正規表現のキャッシュ

    int mScrollTop;             // スクロールトップ
    int mCursor;                // カーソル位置
    string_obj* mATitle;        // 圧縮ファイルの名前

    vector_obj* mFiles;
    BOOL mActive;

    BOOL mVD;                   // 仮想ディレクトリ開始
    BOOL mVD2;                  // 仮想ディレクトリ開始

    vector_obj* mHistory;
    int mHistoryCursor;

} sDir;

///////////////////////////////////////////////////
// ファイラー
///////////////////////////////////////////////////
extern enum eKanjiCode gKanjiCodeFileName;
extern BOOL gExecutiveFileBold;
extern vector_obj* gDirs;
extern BOOL gExtensionICase;        // マークファイルの拡張子別実行で大文字小文字を区別するかどうか

void filer_init();
void filer_final();

int filer_new_dir(char* path);
void filer_del_dir(int dir);

void filer_sort(int dir);

sDir* filer_dir(int dir);
sFile* filer_file(int dir, int num);
int filer_file2(int dir, char* name);
ALLOC vector_obj* filer_mark_files(int dir);
int filer_cd(int dir, char* path);
int filer_cd_back(int dir);
int filer_history_forward(int dir);
int filer_history_back(int dir);

char* filer_mask(int dir);

void filer_set_mask(int dir, char* mask);
void filer_set_dotdir_mask(int dir, BOOL flg);
BOOL filer_dotdir_mask(int dir);

void filer_vd_start(int dir);
void filer_vd2_start(int dir);
void filer_vd_add(int dir, char* fname);
void filer_vd_add2(int dir, char* line);
void filer_vd_end(int dir);
BOOL filer_add_keycommand(int meta, int key, char* ftype, char* command, char* fname);

void filer_archive_title(int dir, char* title);

int filer_reread(int dir);
int filer_mark_file_num(int dir);
BOOL filer_marking(int dir);
void filer_cursor_move(int dir, int num);
int filer_cursor(int dir);
void filer_activate(int dir);
void filer_reset_marks(int dir);
sFile* filer_cursor_file(int dir);

void filer_toggle_mark(int dir, int num);
BOOL filer_mark(int dir, int num);
void filer_set_mark(int dir, int num, int mark);

int filer_line(int dir);
int filer_line_max(int dir);
int filer_row(int dir);
int filer_row_max(int dir);

void filer_view(int dir);
void filer_input(int meta, int key);

int adir();
int sdir();

void extend_macro(char* p, string_obj* title);
int make_size_str(char* result, __off64_t size);

#endif
