/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.freehdl;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import net.wasamon.mics.freehdl.data.Module;
import net.wasamon.mics.freehdl.data.Signal;
import net.wasamon.mics.freehdl.data.StdLogic;
import net.wasamon.mics.freehdl.data.StdLogicVector;

public class FreeHDLProcess {
    private String name;
    private Process process;
    private String step = "20ns";
    private InputStream in;
    private PrintStream out;
    private ProcessWaitThread thread;
    private Module top;

    public FreeHDLProcess(String string) {
        this.name = string;
    }

    private boolean isPrompt(String string) {
        return string.length() > 3 && string.substring(string.length() - 3).equals("\n> ");
    }

    private String read() throws IOException {
        PrintStream printStream = new PrintStream(this.out, true);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        String string = "";
        while (!this.isPrompt(string)) {
            while ((n = this.in.available()) > 0) {
                byte[] byArray = new byte[n];
                this.in.read(byArray);
                string = new String(byArray, 0, n);
            }
        }
        return string.substring(0, string.length() - 2);
    }

    private void write(String string) {
        this.out.println(string);
    }

    private Module getModule(String[] stringArray) {
        if (this.top == null) {
            this.top = new Module(stringArray[0]);
        }
        Module module = this.top;
        for (int i = 1; i < stringArray.length - 1; ++i) {
            module = module.containsModule(stringArray[i]) ? module.getModule(stringArray[i]) : module.newModule(stringArray[i]);
        }
        return module;
    }

    private void init() throws IOException {
        this.write("s");
        String string = this.read();
        for (String string2 : string.split("\n")) {
            String[] stringArray = string2.split(" = ");
            String[] stringArray2 = stringArray[0].split(":");
            Module module = this.getModule(stringArray2);
            String string3 = stringArray2[stringArray2.length - 1];
            Signal signal = null;
            if (stringArray[1].charAt(0) == '(') {
                signal = new StdLogicVector(string3, stringArray[1]);
            } else if (stringArray[1].charAt(0) == '\'') {
                signal = new StdLogic(string3, stringArray[1]);
            } else {
                System.out.println("Unknown Type of Signal:" + string2);
            }
            if (signal == null) continue;
            module.add(signal);
        }
        this.top.dump(System.out);
    }

    public void run() throws IOException {
        this.run(true);
    }

    public void run(boolean bl) throws IOException {
        this.process = Runtime.getRuntime().exec(this.name);
        this.in = this.process.getInputStream();
        this.out = new PrintStream(this.process.getOutputStream(), true);
        this.thread = new ProcessWaitThread(this.process);
        this.thread.start();
        String string = this.read();
        if (!bl) {
            System.out.println(string);
        }
        this.init();
    }

    public void setStep() {
        this.step = this.step;
    }

    public void info() throws IOException {
        this.write("s");
        System.out.print(this.read());
    }

    public void step() throws IOException {
        this.write("run " + this.step);
        this.read();
    }

    public void stop() {
        this.write("quit");
        while (this.thread.isRunning()) {
        }
    }

    public static void main(String[] stringArray) throws Exception {
        FreeHDLProcess freeHDLProcess = new FreeHDLProcess(stringArray[0]);
        freeHDLProcess.run(false);
        for (int i = 0; i < 100; ++i) {
            freeHDLProcess.step();
        }
        freeHDLProcess.stop();
    }

    class ProcessWaitThread
    extends Thread {
        private Process process;
        private boolean flag;

        public ProcessWaitThread(Process process) {
            this.process = process;
            this.flag = true;
        }

        public void run() {
            this.flag = true;
            try {
                this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                this.flag = false;
            }
            this.flag = false;
        }

        public boolean isRunning() {
            return this.flag;
        }
    }
}

