/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.freehdl.data;

import java.io.PrintStream;
import java.util.Hashtable;
import net.wasamon.mics.freehdl.data.Signal;

public class Module {
    private String name;
    private Module parent;
    private Hashtable<String, Signal> ports;
    private Hashtable<String, Module> modules;

    public Module(Module module, String string) {
        this.name = string;
        this.parent = module;
        this.ports = new Hashtable();
        this.modules = new Hashtable();
    }

    public Module(String string) {
        this(null, string);
    }

    public String getName() {
        return this.name;
    }

    public void add(Signal signal) {
        this.ports.put(signal.getName(), signal);
        signal.setModule(this);
    }

    public Module newModule(String string) {
        Module module = new Module(this, string);
        this.modules.put(string, module);
        return module;
    }

    public boolean containsModule(String string) {
        return this.modules.containsKey(string);
    }

    public Module getModule(String string) {
        return this.modules.get(string);
    }

    public void dump(PrintStream printStream) {
        this.dump(printStream, "");
    }

    public void dump(PrintStream printStream, String string) {
        printStream.println(string + this.name);
        for (Signal object : this.ports.values()) {
            printStream.println(string + "-" + object.getName());
        }
        for (Module module : this.modules.values()) {
            module.dump(printStream, string + " ");
        }
    }
}

