/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.memory;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.memory.RandomAccessMemoryDataPacket;
import net.wasamon.mjlib.print.FormatException;
import net.wasamon.mjlib.print.PrintFormat;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Node;

public class RandomAccessMemory
extends MicsElement
implements DataBuffer {
    private byte[] data;

    public RandomAccessMemory() {
    }

    public RandomAccessMemory(int n) {
        this.data = new byte[n];
    }

    public String getImagePath() {
        return "pp_memorynote1_1.gif";
    }

    public void initialize(String string, Node node) throws MicsException {
        try {
            Node node2 = node;
            int n = DataUtil.parseInt((String)XMLParser.getAttribute((Node)node2, (String)"size").getNodeValue());
            this.data = new byte[n];
            Node[] nodeArray = XMLParser.getNamedNodeArray((Node)node, (String)"init");
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node3 = nodeArray[i];
                String string2 = XMLParser.getAttribute((Node)node3, (String)"file").getNodeValue();
                if (string2.charAt(0) != '/') {
                    string2 = string + "/" + string2;
                }
                int n2 = DataUtil.parseInt((String)XMLParser.getAttribute((Node)node3, (String)"offset").getNodeValue());
                try {
                    this.write(n2, new BufferedInputStream(new FileInputStream(string2)));
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("no such file: " + string2);
                    System.out.println("[W] no data is written as initialize.");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.memory.RandomAccessMemory16");
        }
        catch (XMLParserException xMLParserException) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.memory.RandomAccessMemory16");
        }
    }

    public int size() {
        return this.data.length;
    }

    public byte read(int n) {
        return this.data[n];
    }

    public byte[] read(int n, int n2) {
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray[i] = this.data[i + n];
        }
        return byArray;
    }

    public void write(MicsDataPacket micsDataPacket) {
        RandomAccessMemoryDataPacket randomAccessMemoryDataPacket = (RandomAccessMemoryDataPacket)micsDataPacket;
        for (int i = 0; i < randomAccessMemoryDataPacket.length * (randomAccessMemoryDataPacket.width / 8); ++i) {
            this.data[randomAccessMemoryDataPacket.addr + i] = randomAccessMemoryDataPacket.data[i];
        }
    }

    public MicsDataPacket read(MicsDataPacket micsDataPacket) {
        RandomAccessMemoryDataPacket randomAccessMemoryDataPacket = (RandomAccessMemoryDataPacket)micsDataPacket;
        RandomAccessMemoryDataPacket randomAccessMemoryDataPacket2 = new RandomAccessMemoryDataPacket(randomAccessMemoryDataPacket.addr, randomAccessMemoryDataPacket.length, randomAccessMemoryDataPacket.width, new byte[randomAccessMemoryDataPacket.length * (randomAccessMemoryDataPacket.width / 8)]);
        for (int i = 0; i < randomAccessMemoryDataPacket2.data.length; ++i) {
            randomAccessMemoryDataPacket2.data[i] = this.data[i + randomAccessMemoryDataPacket.addr];
        }
        return randomAccessMemoryDataPacket2;
    }

    public void write(int n, int n2, byte[] byArray) {
        for (int i = 0; i < n2; ++i) {
            this.data[i + n] = byArray[i];
        }
    }

    public void write(int n, byte by) {
        this.data[n] = by;
    }

    public String toString(int n, int n2) {
        String string = "";
        try {
            for (int i = 0; i < n2 && n + i * 16 < this.data.length; ++i) {
                string = string + PrintFormat.print((String)"%04x: ", (int)(n + i * 16));
                for (int j = 0; j < 16; ++j) {
                    if (n + i * 16 + j >= this.data.length) {
                        string = string + "\n";
                        return string;
                    }
                    string = string + PrintFormat.print((String)"%02x", (byte)this.data[n + i * 16 + j]);
                    string = j == 15 ? string + "\n" : string + " ";
                }
            }
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        return string;
    }

    public void write(int n, InputStream inputStream) throws DataBufferException {
        byte[] byArray = new byte[1024];
        int n2 = n;
        int n3 = 0;
        try {
            while ((n3 = inputStream.read(byArray, 0, 1024)) != -1) {
                this.write(n2, n3, byArray);
                n2 += n3;
            }
        }
        catch (IOException iOException) {
            throw new DataBufferException("file read error.");
        }
    }

    public void dump(int n, int n2, OutputStream outputStream) throws DataBufferException {
        try {
            outputStream.write(this.data, n, n2);
        }
        catch (IOException iOException) {
            throw new DataBufferException("file read error.");
        }
    }

    public String getInfo() {
        String string = "";
        string = string + "RandomAccessMemory16\n";
        string = string + "  CLASS: " + ((Object)((Object)this)).getClass().getName() + "\n";
        string = string + "  address length: " + this.data.length + "\n";
        string = string + "  data width: 16 bit";
        return string;
    }

    public String[] getConnectedElements() {
        return null;
    }

    public void reset() {
    }
}

