/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.peripheral;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JFrame;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.memory.RandomAccessMemory;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Node;

public class BitMapDumpDisplay
extends MicsElement
implements DataBuffer,
MicsViewable,
Runnable {
    private RandomAccessMemory ram;
    private BitMapDumpDisplayCanvas canvas;
    private JFrame frame;
    Thread t;
    private int refresh_rate = 500;

    public String[] getConnectedElements() {
        return null;
    }

    public String getImagePath() {
        return "pp_ekisyodisplay1_1.gif";
    }

    public void initialize(int n, int n2) {
        this.frame = new JFrame();
        this.frame.setVisible(false);
        this.frame.setTitle(this.id());
        this.ram = new RandomAccessMemory(n * n2 * 3);
        this.canvas = new BitMapDumpDisplayCanvas(n, n2);
        this.frame.getContentPane().add(this.canvas);
        this.frame.pack();
        this.t = new Thread(this);
        this.t.start();
    }

    public void initialize(String string, Node node) throws MicsException {
        try {
            Node node2 = node;
            int n = DataUtil.parseInt((String)XMLParser.getAttribute((Node)node2, (String)"width").getNodeValue());
            int n2 = DataUtil.parseInt((String)XMLParser.getAttribute((Node)node2, (String)"height").getNodeValue());
            this.initialize(n, n2);
            if (XMLParser.isAttribute((Node)node2, (String)"refresh")) {
                this.refresh_rate = DataUtil.parseInt((String)XMLParser.getAttribute((Node)node2, (String)"refresh").getNodeValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.peripheral.CharacterDisplay");
        }
        catch (XMLParserException xMLParserException) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.peripheral.CharacterDisplay");
        }
    }

    public MicsDataPacket read(MicsDataPacket micsDataPacket) {
        return this.ram.read(micsDataPacket);
    }

    public int size() {
        return this.ram.size();
    }

    public String toString(int n, int n2) {
        return this.ram.toString(n, n2);
    }

    public void write(MicsDataPacket micsDataPacket) {
        this.ram.write(micsDataPacket);
    }

    public void write(int n, InputStream inputStream) throws DataBufferException {
        this.ram.write(n, inputStream);
    }

    public void dump(int n, int n2, OutputStream outputStream) throws DataBufferException {
        this.ram.dump(n, n2, outputStream);
    }

    public void show() {
        this.canvas.repaint();
        this.frame.setVisible(true);
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.refresh_rate);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.canvas.repaint();
        }
    }

    public void reset() {
    }

    class BitMapDumpDisplayCanvas
    extends Canvas {
        Image buf;
        int width;
        int height;

        public BitMapDumpDisplayCanvas(int n, int n2) {
            this.width = n;
            this.height = n2;
            this.setSize(n, n2);
        }

        public void paint(Graphics graphics) {
            if (this.buf == null) {
                this.buf = this.createImage(this.width, this.height);
            }
            Graphics graphics2 = this.buf.getGraphics();
            for (int i = 0; i < this.height; ++i) {
                int n = (this.height - i - 1) * this.width;
                for (int j = 0; j < this.width; ++j) {
                    int n2 = (n + j) * 3;
                    int n3 = DataUtil.toInteger((byte)BitMapDumpDisplay.this.ram.read(n2));
                    int n4 = DataUtil.toInteger((byte)BitMapDumpDisplay.this.ram.read(n2 + 1));
                    int n5 = DataUtil.toInteger((byte)BitMapDumpDisplay.this.ram.read(n2 + 2));
                    graphics2.setColor(new Color(n5, n4, n3));
                    graphics2.fillRect(j, i, 1, 1);
                }
            }
            graphics.drawImage(this.buf, 0, 0, this);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }
}

