/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.peripheral;

import java.awt.Font;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.memory.RandomAccessMemory;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Node;

public class CharacterDisplay
extends MicsElement
implements DataBuffer,
ExecutableElement,
MicsViewable,
Runnable {
    private RandomAccessMemory memory;
    private JFrame frame = new JFrame();
    private JTextArea textarea = new JTextArea();
    private int cols;
    Thread t;
    private int refresh_rate = 300;

    public String getImagePath() {
        return "pp_ekisyodisplay1_1.gif";
    }

    public CharacterDisplay() {
        this.textarea.setFont(new Font("MonoSpaced", 0, 12));
        this.textarea.setEditable(false);
        this.frame.setSize(12 * this.cols, 48);
        this.frame.getContentPane().add(new JScrollPane(this.textarea, 20, 30));
        this.frame.setVisible(false);
    }

    private void initialize(int n, int n2) {
        this.cols = n2;
        this.memory = new RandomAccessMemory(n * n2);
        this.reset();
        this.textarea.setColumns(n2);
        this.textarea.setRows(n);
        this.frame.setTitle(this.id());
        this.frame.pack();
        this.t = new Thread(this);
        this.t.start();
    }

    public void initialize(String string, Node node) throws MicsException {
        try {
            Node node2 = node;
            int n = Integer.parseInt(XMLParser.getAttribute((Node)node2, (String)"rows").getNodeValue());
            int n2 = Integer.parseInt(XMLParser.getAttribute((Node)node2, (String)"cols").getNodeValue());
            this.initialize(n, n2);
            if (XMLParser.isAttribute((Node)node2, (String)"refresh")) {
                this.refresh_rate = DataUtil.parseInt((String)XMLParser.getAttribute((Node)node2, (String)"refresh").getNodeValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.peripheral.CharacterDisplay");
        }
        catch (XMLParserException xMLParserException) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.peripheral.CharacterDisplay");
        }
    }

    public MicsDataPacket read(MicsDataPacket micsDataPacket) {
        return this.memory.read(micsDataPacket);
    }

    public int size() {
        return this.memory.size();
    }

    public String toString(int n, int n2) {
        return this.memory.toString(n, n2);
    }

    public void write(MicsDataPacket micsDataPacket) {
        this.memory.write(micsDataPacket);
    }

    public void write(int n, InputStream inputStream) throws DataBufferException {
        this.memory.write(n, inputStream);
    }

    public void dump(int n, int n2, OutputStream outputStream) throws DataBufferException {
        this.memory.dump(n, n2, outputStream);
    }

    public ExecInfo exec_first() throws MicsException {
        return null;
    }

    private void print_memory_data() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.memory.read(0, this.memory.size());
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append((char)byArray[i]);
            if (i % 16 != 15) continue;
            stringBuffer.append("\n");
        }
        this.textarea.setText(stringBuffer.toString());
    }

    public ExecInfo exec_second() throws MicsException {
        return null;
    }

    public void reset() {
        byte[] byArray = new byte[this.memory.size()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 32;
        }
        this.memory.write(0, this.memory.size(), byArray);
    }

    public void show() {
        this.frame.setVisible(true);
        this.print_memory_data();
    }

    public String[] getConnectedElements() {
        return null;
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.refresh_rate);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.print_memory_data();
        }
    }
}

