/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.peripheral;

import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.memory.RandomAccessMemoryDataPacket;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Node;

public class DirectMemoryAccessController
extends MicsElement
implements Channel,
ChannelConnectable,
ExecutableElement {
    private String srcChannelID;
    private String destChannelID;
    private int width = 4;
    private int srcAddr;
    private int destAddr;
    private int length;
    private int count;
    Channel srcChannel;
    Channel destChannel;
    private boolean enableFlag;
    private boolean sourceIncrement;
    private boolean destinationIncrement;
    private int transferMode;
    private static final int READ = 0;
    private static final int WRITE = 1;

    public String getImagePath() {
        return "combo_bus3.png";
    }

    private void initialize(String string, String string2, int n) {
        this.srcChannelID = string;
        this.destChannelID = string2;
        this.width = n;
    }

    public void initialize(String string, Node node) throws MicsException {
        try {
            Node node2 = node;
            int n = DataUtil.parseInt((String)XMLParser.getAttribute((Node)node2, (String)"width").getNodeValue());
            String string2 = XMLParser.getAttribute((Node)node2, (String)"src").getNodeValue();
            String string3 = XMLParser.getAttribute((Node)node2, (String)"dest").getNodeValue();
            this.initialize(string2, string3, n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.peripheral.DirectMemoryAccessController");
        }
        catch (XMLParserException xMLParserException) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.peripheral.DirectMemoryAccessController");
        }
    }

    private Channel getSrcChannel() throws MicsException {
        if (this.srcChannel == null) {
            this.srcChannel = this.composite.getChannel(this.srcChannelID);
        }
        return this.srcChannel;
    }

    private Channel getDestChannel() throws MicsException {
        if (this.destChannel == null) {
            this.destChannel = this.composite.getChannel(this.destChannelID);
        }
        return this.destChannel;
    }

    private Channel getReadChannel() throws MicsException {
        if (this.transferMode == 0) {
            return this.getDestChannel();
        }
        if (this.transferMode == 1) {
            return this.getSrcChannel();
        }
        return null;
    }

    private Channel getWriteChannel() throws MicsException {
        if (this.transferMode == 0) {
            return this.getSrcChannel();
        }
        if (this.transferMode == 1) {
            return this.getDestChannel();
        }
        return null;
    }

    public ExecInfo exec_first() throws MicsException {
        ExecInfo execInfo = new ExecInfo();
        if (this.enableFlag) {
            MicsDataPacket micsDataPacket = RandomAccessMemoryDataPacket.readPacket(this.srcAddr, this.width, 8);
            this.getReadChannel().readRequest((ChannelConnectable)this, micsDataPacket);
            this.count += this.width;
            if (this.sourceIncrement) {
                this.srcAddr += this.width;
            }
            this.enableFlag = this.count < this.length;
        }
        execInfo.setTerminatableFlag(!this.enableFlag);
        return execInfo;
    }

    public ExecInfo exec_second() {
        return null;
    }

    public void reset() {
        this.enableFlag = false;
        this.transferMode = 1;
        this.count = 0;
    }

    public void writeRequest(ChannelConnectable channelConnectable, MicsDataPacket micsDataPacket) throws MicsException {
        this.write(micsDataPacket);
    }

    public void readRequest(ChannelConnectable channelConnectable, MicsDataPacket micsDataPacket) throws MicsException {
    }

    public void write(MicsDataPacket micsDataPacket) {
        RandomAccessMemoryDataPacket randomAccessMemoryDataPacket = (RandomAccessMemoryDataPacket)micsDataPacket;
        switch (randomAccessMemoryDataPacket.addr / 4) {
            case 0: {
                this.srcAddr = DataUtil.toInteger((byte[])randomAccessMemoryDataPacket.data, (int)0, (int)randomAccessMemoryDataPacket.data.length);
                break;
            }
            case 1: {
                this.destAddr = DataUtil.toInteger((byte[])randomAccessMemoryDataPacket.data, (int)0, (int)randomAccessMemoryDataPacket.data.length);
                break;
            }
            case 2: {
                this.length = DataUtil.toInteger((byte[])randomAccessMemoryDataPacket.data, (int)0, (int)randomAccessMemoryDataPacket.data.length);
                break;
            }
            case 3: {
                if ((DataUtil.toInteger((byte[])randomAccessMemoryDataPacket.data, (int)0, (int)randomAccessMemoryDataPacket.data.length) & 1) == 1) {
                    this.enableFlag = true;
                    this.count = 0;
                } else {
                    this.enableFlag = false;
                    this.count = 0;
                }
                this.transferMode = (DataUtil.toInteger((byte[])randomAccessMemoryDataPacket.data, (int)0, (int)randomAccessMemoryDataPacket.data.length) & 2) == 2 ? 0 : 1;
                this.destinationIncrement = (DataUtil.toInteger((byte[])randomAccessMemoryDataPacket.data, (int)0, (int)randomAccessMemoryDataPacket.data.length) & 4) != 4;
                this.sourceIncrement = (DataUtil.toInteger((byte[])randomAccessMemoryDataPacket.data, (int)0, (int)randomAccessMemoryDataPacket.data.length) & 8) != 8;
            }
        }
    }

    public int size() {
        return 0;
    }

    public String toString() {
        String string = "";
        string = string + this.id() + ":" + ((Object)((Object)this)).getClass().getName() + "\n";
        string = string + "srcAddr : " + this.srcAddr + "\n";
        string = string + "destAddr: " + this.destAddr + "\n";
        string = string + "length  : " + this.length + "\n";
        string = string + "enable  : " + this.enableFlag + "\n";
        string = string + "transfer: \n";
        string = this.transferMode == 0 ? string + "READ\n" : (this.transferMode == 1 ? string + "WRITE\n" : string + "UNKNOWN\n");
        return string;
    }

    public void writeback(MicsDataPacket micsDataPacket) throws MicsException {
        RandomAccessMemoryDataPacket randomAccessMemoryDataPacket = (RandomAccessMemoryDataPacket)micsDataPacket;
        MicsDataPacket micsDataPacket2 = RandomAccessMemoryDataPacket.writePacket(this.destAddr, this.width, 8, randomAccessMemoryDataPacket.data);
        this.getWriteChannel().writeRequest((ChannelConnectable)this, micsDataPacket2);
        if (this.destinationIncrement) {
            this.destAddr += this.width;
        }
    }

    public int getChannelOffset(Channel channel) {
        return 0;
    }

    public String[] getConnectedElements() {
        return new String[]{this.srcChannelID, this.destChannelID};
    }
}

