/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor;

import net.wasamon.mics.processor.Register;
import net.wasamon.mjlib.util.DataUtil;

public class FloatRegister
implements Register {
    float data = 0.0f;

    public float floatValue() {
        return this.data;
    }

    public int intValue() {
        return (int)this.data;
    }

    public void reset() {
        this.data = 0.0f;
    }

    public void set(Register register) {
        this.data = register.floatValue();
    }

    public void set(int n) {
        this.data = n;
    }

    public void set(float f) {
        this.data = f;
    }

    public void set(byte by) {
        this.data = by;
    }

    public void set(char c) {
        this.data = DataUtil.toSiginedInteger((char)c);
    }

    public void set(byte[] byArray) {
        this.data = byArray.length == 2 ? (float)DataUtil.toInteger((byte[])byArray) : Float.intBitsToFloat(DataUtil.toInteger((byte[])byArray));
    }

    public void set(byte[] byArray, int n, int n2) {
        this.data = Float.intBitsToFloat(DataUtil.toInteger((byte[])byArray, (int)n, (int)n2));
    }

    public void add(int n) {
        this.data += (float)n;
    }

    public Register add(Register register, Register register2) {
        this.data = register.floatValue() + register2.floatValue();
        return this;
    }

    public Register mult(Register register, Register register2) {
        this.data = register.floatValue() * register2.floatValue();
        return this;
    }

    public Register div(Register register, Register register2) {
        this.data = register.floatValue() / register2.floatValue();
        return this;
    }

    public Register sub(Register register, Register register2) {
        this.data = register.floatValue() - register2.floatValue();
        return this;
    }

    public void neg(Register register) {
        this.data = -register.floatValue();
    }

    public Register mod(Register register, Register register2) {
        this.data = register.floatValue() % register2.floatValue();
        return this;
    }

    public Register shiftL(Register register, Register register2) {
        return null;
    }

    public Register shiftR(Register register, Register register2) {
        return null;
    }

    public Register and(Register register, Register register2) {
        return null;
    }

    public Register or(Register register, Register register2) {
        return null;
    }

    public boolean eqeq(Register register) {
        return this.floatValue() == register.floatValue();
    }

    public boolean gt(Register register) {
        return this.floatValue() > register.floatValue();
    }

    public byte[] byteArray() {
        return DataUtil.toByteArray((int)Float.floatToIntBits(this.data));
    }

    public byte[] byteArray(int n, int n2) {
        return DataUtil.subArray((byte[])this.byteArray(), (int)n, (int)n2);
    }

    public String toString() {
        return DataUtil.toBigEndianValueString((byte[])this.byteArray()).substring(2);
    }
}

