/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor;

import net.wasamon.mics.processor.Register;
import net.wasamon.mjlib.util.DataUtil;

public class IntRegister
implements Register {
    int data = 0;

    public int intValue() {
        return this.data;
    }

    public byte[] byteArray() {
        return DataUtil.toByteArray((int)this.data);
    }

    public byte[] byteArray(int n, int n2) {
        return DataUtil.subArray((byte[])DataUtil.toByteArray((int)this.data), (int)n, (int)n2);
    }

    public void reset() {
        this.data = 0;
    }

    public void set(Register register) {
        this.data = register.intValue();
    }

    public void set(int n) {
        this.data = n;
    }

    public void set(byte by) {
        this.data = by;
    }

    public void set(char c) {
        this.data = DataUtil.toSiginedInteger((char)c);
    }

    public void setL(char c) {
        this.data &= 0xFFFF0000;
        this.data += c & 0xFFFF;
    }

    public void setH(char c) {
        this.data &= 0xFFFF;
        this.data += c << 16 & 0xFFFF0000;
    }

    public void set(byte[] byArray) {
        this.data = DataUtil.toInteger((byte[])byArray);
    }

    public void set(byte[] byArray, int n, int n2) {
        this.data = DataUtil.toInteger((byte[])byArray, (int)n, (int)n2);
    }

    public void add(int n) {
        this.data += n;
    }

    public Register add(Register register, Register register2) {
        this.data = register.intValue() + register2.intValue();
        return this;
    }

    public Register mult(Register register, Register register2) {
        this.data = register.intValue() * register2.intValue();
        return this;
    }

    public Register div(Register register, Register register2) {
        this.data = register.intValue() / register2.intValue();
        return this;
    }

    public Register mod(Register register, Register register2) {
        this.data = register.intValue() % register2.intValue();
        return this;
    }

    public Register sub(Register register, Register register2) {
        this.data = register.intValue() - register2.intValue();
        return this;
    }

    public void neg(Register register) {
        this.data = -register.intValue();
    }

    public Register shiftL(Register register, Register register2) {
        this.data = register.intValue() << register2.intValue();
        return this;
    }

    public Register shiftR(Register register, Register register2) {
        this.data = register.intValue() >> register2.intValue();
        return this;
    }

    public Register and(Register register, Register register2) {
        this.data = register.intValue() & register2.intValue();
        return this;
    }

    public Register or(Register register, Register register2) {
        this.data = register.intValue() | register2.intValue();
        return this;
    }

    public boolean eqeq(Register register) {
        return this.intValue() == register.intValue();
    }

    public boolean gt(Register register) {
        return this.intValue() > register.intValue();
    }

    public String toString() {
        return DataUtil.toBigEndianValueString((byte[])this.byteArray()).substring(2);
    }

    public float floatValue() {
        return this.data;
    }
}

