/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor;

import java.io.InputStream;
import java.io.OutputStream;
import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.ExecutableElementException;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.memory.RandomAccessMemory;
import net.wasamon.mics.memory.RandomAccessMemoryDataPacket;
import net.wasamon.mics.util.ChannelManager;
import net.wasamon.mjlib.print.FormatException;
import net.wasamon.mjlib.print.PrintFormat;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import net.wasamon.wallet.binutils.UnknownInstructionException;
import org.w3c.dom.Node;

public class SimpleProcessor
extends MicsElement
implements ExecutableElement,
ChannelConnectable,
DataBuffer {
    private static final int INST_HALT = 0;
    private static final int INST_NOP = 1;
    private static final int INST_ADD = 16;
    private static final int INST_SUB = 17;
    private static final int INST_MULT = 18;
    private static final int INST_DIV = 19;
    private static final int INST_ADDI = 20;
    private static final int INST_SUBI = 21;
    private static final int INST_MOD = 22;
    private static final int INST_LSHS = 23;
    private static final int INST_RSHS = 24;
    private static final int INST_OR = 32;
    private static final int INST_AND = 33;
    private static final int INST_JMP = 48;
    private static final int INST_JMPI = 49;
    private static final int INST_JCC = 50;
    private static final int INST_JCCI = 51;
    private static final int INST_EQ = 64;
    private static final int INST_NEQ = 65;
    private static final int INST_LT = 66;
    private static final int INST_GT = 67;
    private static final int INST_LEQ = 68;
    private static final int INST_GEQ = 69;
    private static final int INST_MOV = 80;
    private static final int INST_MOVI = 81;
    private static final int INST_POP = 96;
    private static final int INST_PUSH = 97;
    private static final int INST_CALL = 100;
    private static final int INST_CALLI = 101;
    private static final int INST_RET = 102;
    private static final int INST_LDA = 103;
    private static final int INST_STA = 104;
    private static final byte INST_LDR = -128;
    private static final byte INST_STR = -127;
    private static final byte INST_LDR8 = -126;
    private static final byte INST_STR8 = -125;
    private static final int REGISTER_SIZE = 32;
    private static final int PROGRAM_COUNTER = 31;
    private static final int FRAME_POINTER = 30;
    private static final int STACK_POINTER = 29;
    private char[] register = new char[32];
    private boolean condition = false;
    private RandomAccessMemory memory;
    private int programOffset;
    private int CODE_LENGTH = 4;
    private int readRequestRegID;
    private boolean waitFlag;
    private final int MULT_DIV_CYCLE = 2;
    private ChannelManager channelManager;

    public void initialize(String string, Node node) throws MicsException {
        this.channelManager = new ChannelManager(this.composite);
        try {
            Node node2 = node;
            int n = DataUtil.parseInt((String)XMLParser.getAttribute((Node)node2, (String)"memory").getNodeValue());
            this.memory = new RandomAccessMemory(n);
            Node[] nodeArray = XMLParser.getNamedNodeArray((Node)node, (String)"channel");
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node3 = nodeArray[i];
                String string2 = XMLParser.getAttribute((Node)node3, (String)"id").getNodeValue();
                int n2 = DataUtil.parseInt((String)XMLParser.getAttribute((Node)node3, (String)"offset").getNodeValue());
                this.channelManager.add(string2, n2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.processor.SimpleProcessor");
        }
        catch (XMLParserException xMLParserException) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.processor.SimpleProcessor");
        }
    }

    public MicsDataPacket read(MicsDataPacket micsDataPacket) {
        return this.memory.read(micsDataPacket);
    }

    public void write(MicsDataPacket micsDataPacket) {
        this.memory.write(micsDataPacket);
    }

    public void write(int n, InputStream inputStream) throws DataBufferException {
        this.memory.write(n, inputStream);
    }

    public void dump(int n, int n2, OutputStream outputStream) throws DataBufferException {
        this.memory.dump(n, n2, outputStream);
    }

    public int size() {
        return this.memory.size();
    }

    public String toString(int n, int n2) {
        return this.memory.toString(n, n2);
    }

    public void execWait() {
        this.waitFlag = true;
    }

    public void execRestart() {
        this.waitFlag = false;
    }

    public void reset() {
        this.waitFlag = false;
        for (int i = 0; i < 32; ++i) {
            this.register[i] = '\u0000';
        }
    }

    public ExecInfo exec_second() {
        return null;
    }

    public ExecInfo exec_first() throws ExecutableElementException {
        OperationCode operationCode = null;
        ExecInfo execInfo = new ExecInfo();
        execInfo.setCycle(1);
        execInfo.setTerminatableFlag(false);
        try {
            operationCode = this.readProgram(this.register[31]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ExecutableElementException("program address error");
        }
        if (this.waitFlag) {
            return execInfo;
        }
        int n = 0;
        switch (operationCode.inst) {
            case 0: {
                execInfo.setTerminatableFlag(true);
                break;
            }
            case 1: {
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 16: {
                n = this.register[operationCode.args[1]] + this.register[operationCode.args[2]];
                this.register[((OperationCode)operationCode).args[0]] = DataUtil.toCharL((int)n);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 20: {
                char c = (char)(((operationCode.args[1] & 0xFF) << 8) + (operationCode.args[2] & 0xFF));
                byte by = operationCode.args[0];
                this.register[by] = (char)(this.register[by] + c);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 17: {
                n = this.register[operationCode.args[1]] - this.register[operationCode.args[2]];
                this.register[((OperationCode)operationCode).args[0]] = DataUtil.toCharL((int)n);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 21: {
                char c = (char)(((operationCode.args[1] & 0xFF) << 8) + (operationCode.args[2] & 0xFF));
                byte by = operationCode.args[0];
                this.register[by] = (char)(this.register[by] - c);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 18: {
                n = this.register[operationCode.args[1]] * this.register[operationCode.args[2]];
                this.register[((OperationCode)operationCode).args[0]] = DataUtil.toCharL((int)n);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                execInfo.setCycle(2);
                break;
            }
            case 19: {
                this.register[((OperationCode)operationCode).args[0]] = DataUtil.toCharL((int)(this.register[operationCode.args[1]] / this.register[operationCode.args[2]]));
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                execInfo.setCycle(2);
                break;
            }
            case 22: {
                this.register[((OperationCode)operationCode).args[0]] = DataUtil.toCharL((int)(this.register[operationCode.args[1]] % this.register[operationCode.args[2]]));
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                execInfo.setCycle(2);
                break;
            }
            case 23: {
                this.register[((OperationCode)operationCode).args[0]] = DataUtil.toCharL((int)(this.register[operationCode.args[1]] << this.register[operationCode.args[2]]));
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 24: {
                this.register[((OperationCode)operationCode).args[0]] = DataUtil.toCharL((int)(this.register[operationCode.args[1]] >> this.register[operationCode.args[2]]));
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 32: {
                n = this.register[operationCode.args[1]] | this.register[operationCode.args[2]];
                this.register[((OperationCode)operationCode).args[0]] = DataUtil.toCharL((int)n);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 33: {
                n = this.register[operationCode.args[1]] & this.register[operationCode.args[2]];
                this.register[((OperationCode)operationCode).args[0]] = DataUtil.toCharL((int)n);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 48: {
                this.register[31] = (char)(this.register[operationCode.args[0]] * this.CODE_LENGTH);
                break;
            }
            case 49: {
                this.register[31] = (char)(DataUtil.toChar((byte)operationCode.args[0], (byte)operationCode.args[1]) * this.CODE_LENGTH);
                break;
            }
            case 50: {
                if (this.condition) {
                    this.register[31] = (char)(this.register[operationCode.args[0]] * this.CODE_LENGTH);
                    break;
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 51: {
                if (this.condition) {
                    this.register[31] = (char)(DataUtil.toChar((byte)operationCode.args[0], (byte)operationCode.args[1]) * this.CODE_LENGTH);
                    break;
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 64: {
                if (this.register[operationCode.args[1]] == this.register[operationCode.args[2]]) {
                    this.register[((OperationCode)operationCode).args[0]] = '\u0000';
                    this.condition = true;
                } else {
                    this.register[((OperationCode)operationCode).args[0]] = '\u0001';
                    this.condition = false;
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 65: {
                if (this.register[operationCode.args[1]] != this.register[operationCode.args[2]]) {
                    this.register[((OperationCode)operationCode).args[0]] = '\u0000';
                    this.condition = true;
                } else {
                    this.register[((OperationCode)operationCode).args[0]] = '\u0001';
                    this.condition = false;
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 66: {
                if (DataUtil.toSiginedInteger((char)this.register[operationCode.args[1]]) < DataUtil.toSiginedInteger((char)this.register[operationCode.args[2]])) {
                    this.register[((OperationCode)operationCode).args[0]] = '\u0000';
                    this.condition = true;
                } else {
                    this.register[((OperationCode)operationCode).args[0]] = '\u0001';
                    this.condition = false;
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 67: {
                if (DataUtil.toSiginedInteger((char)this.register[operationCode.args[1]]) > DataUtil.toSiginedInteger((char)this.register[operationCode.args[2]])) {
                    this.register[((OperationCode)operationCode).args[0]] = '\u0000';
                    this.condition = true;
                } else {
                    this.register[((OperationCode)operationCode).args[0]] = '\u0001';
                    this.condition = false;
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 68: {
                if (DataUtil.toSiginedInteger((char)this.register[operationCode.args[1]]) <= DataUtil.toSiginedInteger((char)this.register[operationCode.args[2]])) {
                    this.register[((OperationCode)operationCode).args[0]] = '\u0000';
                    this.condition = true;
                } else {
                    this.register[((OperationCode)operationCode).args[0]] = '\u0001';
                    this.condition = false;
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 69: {
                if (DataUtil.toSiginedInteger((char)this.register[operationCode.args[1]]) >= DataUtil.toSiginedInteger((char)this.register[operationCode.args[2]])) {
                    this.register[((OperationCode)operationCode).args[0]] = '\u0000';
                    this.condition = true;
                } else {
                    this.register[((OperationCode)operationCode).args[0]] = '\u0001';
                    this.condition = false;
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case -128: {
                if (this.register[operationCode.args[0]] < this.memory.size()) {
                    this.register[((OperationCode)operationCode).args[1]] = DataUtil.toChar((byte[])this.memory.read(this.register[operationCode.args[0]], 2), (int)0, (int)2);
                } else {
                    this.readRequestRegID = operationCode.args[1];
                    ChannelManager.Element element = this.channelManager.search((int)this.register[operationCode.args[0]]);
                    try {
                        element.getChannel().readRequest((ChannelConnectable)this, RandomAccessMemoryDataPacket.readPacket(this.register[operationCode.args[0]] - element.offset, 1, 16));
                    }
                    catch (MicsException micsException) {
                        throw new ExecutableElementException((Throwable)micsException);
                    }
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case -126: {
                if (this.register[operationCode.args[0]] < this.memory.size()) {
                    this.register[((OperationCode)operationCode).args[1]] = DataUtil.toChar((byte[])this.memory.read(this.register[operationCode.args[0]], 1), (int)0, (int)1);
                } else {
                    this.readRequestRegID = operationCode.args[1];
                    ChannelManager.Element element = this.channelManager.search((int)this.register[operationCode.args[0]]);
                    try {
                        element.getChannel().readRequest((ChannelConnectable)this, RandomAccessMemoryDataPacket.readPacket(this.register[operationCode.args[0]] - element.offset, 1, 8));
                    }
                    catch (MicsException micsException) {
                        throw new ExecutableElementException((Throwable)micsException);
                    }
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case -127: {
                if (this.register[operationCode.args[0]] < this.memory.size()) {
                    this.memory.write(this.register[operationCode.args[0]], 2, DataUtil.toByteArray((char)this.register[operationCode.args[1]]));
                } else {
                    ChannelManager.Element element = this.channelManager.search((int)this.register[operationCode.args[0]]);
                    try {
                        element.getChannel().writeRequest((ChannelConnectable)this, RandomAccessMemoryDataPacket.writePacket(this.register[operationCode.args[0]] - element.offset, 2, 8, DataUtil.toByteArray((char)this.register[operationCode.args[1]])));
                    }
                    catch (MicsException micsException) {
                        throw new ExecutableElementException((Throwable)micsException);
                    }
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case -125: {
                if (this.register[operationCode.args[0]] < this.memory.size()) {
                    this.memory.write((int)this.register[operationCode.args[0]], DataUtil.toByteL((char)this.register[operationCode.args[1]]));
                } else {
                    ChannelManager.Element element = this.channelManager.search((int)this.register[operationCode.args[0]]);
                    try {
                        element.getChannel().writeRequest((ChannelConnectable)this, RandomAccessMemoryDataPacket.writePacket(this.register[operationCode.args[0]] - element.offset, 1, 8, new byte[]{DataUtil.toByteL((char)this.register[operationCode.args[1]])}));
                    }
                    catch (MicsException micsException) {
                        throw new ExecutableElementException((Throwable)micsException);
                    }
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 81: {
                this.register[((OperationCode)operationCode).args[0]] = DataUtil.toChar((byte)operationCode.args[1], (byte)operationCode.args[2]);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 80: {
                this.register[((OperationCode)operationCode).args[0]] = this.register[operationCode.args[1]];
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 96: {
                this.register[((OperationCode)operationCode).args[0]] = this.pop();
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 97: {
                this.push(this.register[operationCode.args[0]]);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 100: {
                this.push((char)(this.register[31] + this.CODE_LENGTH));
                this.register[31] = (char)(this.register[operationCode.args[0]] * this.CODE_LENGTH);
                break;
            }
            case 101: {
                this.push((char)(this.register[31] + this.CODE_LENGTH));
                this.register[31] = (char)(DataUtil.toChar((byte)operationCode.args[0], (byte)operationCode.args[1]) * this.CODE_LENGTH);
                break;
            }
            case 102: {
                this.register[31] = this.pop();
                break;
            }
            case 103: {
                char c = this.register[30];
                int n2 = DataUtil.toChar((byte[])new byte[]{operationCode.args[1], operationCode.args[2]}, (int)0, (int)2);
                int n3 = 0;
                n3 = (n2 & 0x8000) == 32768 ? n2 - 65536 : n2;
                this.register[((OperationCode)operationCode).args[0]] = DataUtil.toChar((byte[])this.memory.read(c + n3, 2), (int)0, (int)2);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 104: {
                char c = this.register[30];
                int n4 = DataUtil.toChar((byte[])new byte[]{operationCode.args[1], operationCode.args[2]}, (int)0, (int)2);
                int n5 = 0;
                n5 = (n4 & 0x8000) == 32768 ? n4 - 65536 : n4;
                this.memory.write(c + n5, 2, DataUtil.toByteArray((char)this.register[operationCode.args[0]]));
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            default: {
                throw new ExecutableElementException("unknow op code " + String.valueOf(operationCode.inst));
            }
        }
        return execInfo;
    }

    private char pop() throws ExecutableElementException {
        if (this.register[29] < this.memory.size() - 1) {
            char c = DataUtil.toChar((byte[])this.memory.read(this.register[29], 2), (int)0, (int)2);
            this.register[29] = (char)(this.register[29] + 2);
            return c;
        }
        throw new ExecutableElementException("stack under flow");
    }

    private void push(char c) throws ExecutableElementException {
        if (this.register[29] <= '\u0002') {
            throw new ExecutableElementException("stack over flow");
        }
        this.register[29] = (char)(this.register[29] - 2);
        this.memory.write(this.register[29], 2, DataUtil.toByteArray((char)c));
    }

    private OperationCode readProgram(int n) {
        byte[] byArray = this.memory.read(n + this.programOffset, 4);
        return new OperationCode(byArray[0], byArray[1], byArray[2], byArray[3]);
    }

    public void writeback(MicsDataPacket micsDataPacket) {
        RandomAccessMemoryDataPacket randomAccessMemoryDataPacket = (RandomAccessMemoryDataPacket)micsDataPacket;
        System.out.println(randomAccessMemoryDataPacket);
        this.register[this.readRequestRegID] = randomAccessMemoryDataPacket.length * randomAccessMemoryDataPacket.width / 8 == 2 ? DataUtil.toChar((byte[])randomAccessMemoryDataPacket.data, (int)0, (int)2) : DataUtil.toChar((byte[])randomAccessMemoryDataPacket.data, (int)0, (int)1);
    }

    public int getChannelOffset(Channel channel) {
        return this.channelManager.search(channel);
    }

    public String getInfo() {
        String string = "";
        string = string + "SimpleProcessor\n";
        string = string + "  CLASS: " + ((Object)((Object)this)).getClass().getName() + "\n";
        string = string + "  ID: " + this.id() + "\n";
        string = string + "  Local Memory ID: " + this.memory.id() + ",";
        string = string + " offset = " + this.programOffset + "\n";
        ChannelManager.Element[] elementArray = this.channelManager.array();
        for (int i = 0; i < elementArray.length; ++i) {
            ChannelManager.Element element = elementArray[i];
            string = string + "  Channel ID: " + element.id + ",";
            string = string + " offset = " + element.offset + "\n";
        }
        return string;
    }

    public String toString() {
        try {
            String string = "";
            try {
                string = string + PrintFormat.print((String)"%04d", (int)this.register[31]) + ":";
            }
            catch (FormatException formatException) {
                formatException.printStackTrace();
            }
            string = string + this.readProgram(this.register[31]).toString();
            string = string + "\n";
            for (int i = 0; i < 32; ++i) {
                try {
                    string = string + PrintFormat.print((String)"%04x", (int)this.register[i]);
                    if (i % 8 == 7) {
                        string = string + "\n";
                        continue;
                    }
                    string = string + " ";
                    continue;
                }
                catch (FormatException formatException) {
                    // empty catch block
                }
            }
            return string;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return new String(this.register[31] + ": illegal program counter");
        }
    }

    public static int getInstructionCode(String string) throws UnknownInstructionException {
        if (string.equals("HALT")) {
            return 0;
        }
        if (string.equals("NOP")) {
            return 1;
        }
        if (string.equals("ADD")) {
            return 16;
        }
        if (string.equals("ADDI")) {
            return 20;
        }
        if (string.equals("SUB")) {
            return 17;
        }
        if (string.equals("SUBI")) {
            return 21;
        }
        if (string.equals("MULT")) {
            return 18;
        }
        if (string.equals("DIV")) {
            return 19;
        }
        if (string.equals("MOD")) {
            return 22;
        }
        if (string.equals("LSHS")) {
            return 23;
        }
        if (string.equals("RSHS")) {
            return 24;
        }
        if (string.equals("OR")) {
            return 32;
        }
        if (string.equals("AND")) {
            return 33;
        }
        if (string.equals("JMP")) {
            return 48;
        }
        if (string.equals("JMPI")) {
            return 49;
        }
        if (string.equals("JCC")) {
            return 50;
        }
        if (string.equals("JCCI")) {
            return 51;
        }
        if (string.equals("EQ")) {
            return 64;
        }
        if (string.equals("NEQ")) {
            return 65;
        }
        if (string.equals("LT")) {
            return 66;
        }
        if (string.equals("GT")) {
            return 67;
        }
        if (string.equals("LEQ")) {
            return 68;
        }
        if (string.equals("GEQ")) {
            return 69;
        }
        if (string.equals("MOVI")) {
            return 81;
        }
        if (string.equals("MOV")) {
            return 80;
        }
        if (string.equals("POP")) {
            return 96;
        }
        if (string.equals("PUSH")) {
            return 97;
        }
        if (string.equals("CALL")) {
            return 100;
        }
        if (string.equals("CALLI")) {
            return 101;
        }
        if (string.equals("RET")) {
            return 102;
        }
        if (string.equals("LDA")) {
            return 103;
        }
        if (string.equals("STA")) {
            return 104;
        }
        if (string.equals("LDR")) {
            return -128;
        }
        if (string.equals("STR")) {
            return -127;
        }
        if (string.equals("LDR8")) {
            return -126;
        }
        if (string.equals("STR8")) {
            return -125;
        }
        throw new UnknownInstructionException("unknown instruction " + string);
    }

    public String[] getConnectedElements() {
        return this.channelManager.getConnectedElements();
    }

    public String getImagePath() {
        return "combo_processor.png";
    }

    class OperationCode {
        private byte inst;
        private byte[] args = new byte[3];

        OperationCode(byte by, byte by2, byte by3, byte by4) {
            this.inst = by;
            this.args[0] = by2;
            this.args[1] = by3;
            this.args[2] = by4;
        }

        public String toString() {
            String string = "";
            switch (this.inst) {
                case 0: {
                    string = string + "HALT ";
                    break;
                }
                case 1: {
                    string = string + "NOP  ";
                    break;
                }
                case 16: {
                    string = string + "ADD  ";
                    break;
                }
                case 20: {
                    string = string + "ADDI ";
                    break;
                }
                case 17: {
                    string = string + "SUB  ";
                    break;
                }
                case 21: {
                    string = string + "SUBI ";
                    break;
                }
                case 18: {
                    string = string + "MULT ";
                    break;
                }
                case 19: {
                    string = string + "DIV  ";
                    break;
                }
                case 22: {
                    string = string + "MOD  ";
                    break;
                }
                case 23: {
                    string = string + "LSHS ";
                    break;
                }
                case 24: {
                    string = string + "RSHS ";
                    break;
                }
                case 32: {
                    string = string + "OR   ";
                    break;
                }
                case 33: {
                    string = string + "AND  ";
                    break;
                }
                case 48: {
                    string = string + "JMP  ";
                    break;
                }
                case 49: {
                    string = string + "JMPI ";
                    break;
                }
                case 50: {
                    string = string + "JCC  ";
                    break;
                }
                case 51: {
                    string = string + "JCCI ";
                    break;
                }
                case 64: {
                    string = string + "EQ   ";
                    break;
                }
                case 65: {
                    string = string + "NEQ  ";
                    break;
                }
                case 66: {
                    string = string + "LT   ";
                    break;
                }
                case 67: {
                    string = string + "GT   ";
                    break;
                }
                case 68: {
                    string = string + "LEQ  ";
                    break;
                }
                case 69: {
                    string = string + "GEQ  ";
                    break;
                }
                case -128: {
                    string = string + "LDR  ";
                    break;
                }
                case -127: {
                    string = string + "STR  ";
                    break;
                }
                case -126: {
                    string = string + "LDR8 ";
                    break;
                }
                case -125: {
                    string = string + "STR8 ";
                    break;
                }
                case 80: {
                    string = string + "MOV  ";
                    break;
                }
                case 81: {
                    string = string + "MOVI ";
                    break;
                }
                case 96: {
                    string = string + "POP  ";
                    break;
                }
                case 97: {
                    string = string + "PUSH ";
                    break;
                }
                case 100: {
                    string = string + "CALL ";
                    break;
                }
                case 101: {
                    string = string + "CALLI";
                    break;
                }
                case 102: {
                    string = string + "RET  ";
                    break;
                }
                case 103: {
                    string = string + "LDA  ";
                    break;
                }
                case 104: {
                    string = string + "STA  ";
                    break;
                }
                default: {
                    string = string + "ERROR";
                }
            }
            string = string + ",";
            try {
                string = string + PrintFormat.print((String)"%02x", (byte)this.args[0]);
                string = string + ",";
                string = string + PrintFormat.print((String)"%02x", (byte)this.args[1]);
                string = string + ",";
                string = string + PrintFormat.print((String)"%02x", (byte)this.args[2]);
            }
            catch (FormatException formatException) {
                formatException.printStackTrace();
            }
            return string;
        }
    }
}

