/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.table.TableModel;
import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.ExecutableElementException;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.memory.InterruptDataPacket;
import net.wasamon.mics.memory.RandomAccessMemory;
import net.wasamon.mics.memory.RandomAccessMemoryDataPacket;
import net.wasamon.mics.processor.FloatRegister;
import net.wasamon.mics.processor.IntRegister;
import net.wasamon.mics.processor.Register;
import net.wasamon.mics.util.ChannelManager;
import net.wasamon.mics.util.MicsTableModel;
import net.wasamon.mics.util.MicsTablePanel;
import net.wasamon.mjlib.print.FormatException;
import net.wasamon.mjlib.print.PrintFormat;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Node;

public class SimpleProcessor32
extends MicsElement
implements ExecutableElement,
ChannelConnectable,
DataBuffer,
MicsViewable {
    private IntRegister[] intRegister = new IntRegister[8];
    private static final int INST_HALT = 0;
    private static final int INST_NOP = 1;
    private static final int INST_ADD = 16;
    private static final int INST_SUB = 17;
    private static final int INST_MULT = 18;
    private static final int INST_DIV = 19;
    private static final int INST_ADDI = 20;
    private static final int INST_SUBI = 21;
    private static final int INST_MOD = 22;
    private static final int INST_LSHS = 23;
    private static final int INST_RSHS = 24;
    private static final int INST_NEG = 25;
    private static final int INST_OR = 32;
    private static final int INST_AND = 33;
    private static final int INST_JMP = 48;
    private static final int INST_JMPI = 49;
    private static final int INST_JCC = 50;
    private static final int INST_JCCI = 51;
    private static final int INST_EQ = 64;
    private static final int INST_NEQ = 65;
    private static final int INST_LT = 66;
    private static final int INST_GT = 67;
    private static final int INST_LEQ = 68;
    private static final int INST_GEQ = 69;
    private static final int INST_MOV = 80;
    private static final int INST_MOVI = 81;
    private static final int INST_MOVIL = 82;
    private static final int INST_MOVIH = 83;
    private static final int INST_POP = 96;
    private static final int INST_PUSH = 97;
    private static final int INST_CALL = 100;
    private static final int INST_CALLI = 101;
    private static final int INST_RET = 102;
    private static final int INST_LDA = 103;
    private static final int INST_STA = 104;
    private static final byte INST_LDR = -128;
    private static final byte INST_STR = -127;
    private static final byte INST_LDR8 = -126;
    private static final byte INST_STR8 = -125;
    private static final byte INST_LDR32 = -124;
    private static final byte INST_STR32 = -123;
    private static final byte INST_LDRF = -122;
    private static final byte INST_SIN = -112;
    private static final byte INST_COS = -111;
    private static final byte INST_SINF = -110;
    private static final byte INST_COSF = -109;
    private static final byte INST_SQRT = -108;
    private static final byte INST_SQRTF = -107;
    private static final int REGISTER_SIZE = 32;
    private static final int PROGRAM_COUNTER = 31;
    private static final int FRAME_POINTER = 30;
    private static final int STACK_POINTER = 29;
    private IntRegister[] register = new IntRegister[32];
    private FloatRegister[] fregister = new FloatRegister[32];
    private StateFlagGroup status = new StateFlagGroup();
    private RandomAccessMemory memory;
    private int programOffset;
    private int CODE_LENGTH = 4;
    private int readRequestRegID;
    private boolean waitFlag;
    private final int MULT_DIV_CYCLE = 2;
    private final int SIN_COS_CYCLE = 24;
    private final int SQRT_CYCLE = 24;
    private ChannelManager channelManager;
    MicsTablePanel table;

    public SimpleProcessor32() {
        for (int i = 0; i < 32; ++i) {
            this.register[i] = new IntRegister();
            this.fregister[i] = new FloatRegister();
        }
    }

    private boolean isFloatRegister(int n) {
        return n >= 32;
    }

    private Register getRegister(int n) {
        if (this.isFloatRegister(n)) {
            return this.fregister[n - 32];
        }
        return this.register[n];
    }

    public void initialize(String string, Node node) throws MicsException {
        this.channelManager = new ChannelManager(this.composite);
        try {
            int n;
            String string2;
            Node node2;
            int n2;
            Node node3 = node;
            int n3 = DataUtil.parseInt((String)XMLParser.getAttribute((Node)node3, (String)"memory").getNodeValue());
            this.memory = new RandomAccessMemory(n3);
            Node[] nodeArray = XMLParser.getNamedNodeArray((Node)node, (String)"channel");
            for (n2 = 0; n2 < nodeArray.length; ++n2) {
                node2 = nodeArray[n2];
                string2 = XMLParser.getAttribute((Node)node2, (String)"id").getNodeValue();
                n = DataUtil.parseInt((String)XMLParser.getAttribute((Node)node2, (String)"offset").getNodeValue());
                this.channelManager.add(string2, n);
            }
            nodeArray = XMLParser.getNamedNodeArray((Node)node, (String)"init");
            for (n2 = 0; n2 < nodeArray.length; ++n2) {
                node2 = nodeArray[n2];
                string2 = XMLParser.getAttribute((Node)node2, (String)"file").getNodeValue();
                if (string2.charAt(0) != '/') {
                    string2 = string + "/" + string2;
                }
                n = DataUtil.parseInt((String)XMLParser.getAttribute((Node)node2, (String)"offset").getNodeValue());
                try {
                    this.write(n, new BufferedInputStream(new FileInputStream(string2)));
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("no such file: " + string2);
                    System.out.println("[W] no data is written as initialize.");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.processor.SimpleProcessor");
        }
        catch (XMLParserException xMLParserException) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.processor.SimpleProcessor");
        }
    }

    public MicsDataPacket read(MicsDataPacket micsDataPacket) {
        return this.memory.read(micsDataPacket);
    }

    public void write(MicsDataPacket micsDataPacket) {
        this.memory.write(micsDataPacket);
    }

    public void write(int n, InputStream inputStream) throws DataBufferException {
        this.memory.write(n, inputStream);
    }

    public void dump(int n, int n2, OutputStream outputStream) throws DataBufferException {
        this.memory.dump(n, n2, outputStream);
    }

    public int size() {
        return this.memory.size();
    }

    public String toString(int n, int n2) {
        return this.memory.toString(n, n2);
    }

    public void execWait() {
        this.waitFlag = true;
    }

    public void execRestart() {
        this.waitFlag = false;
    }

    public void reset() {
        this.waitFlag = false;
        for (int i = 0; i < 32; ++i) {
            this.register[i].reset();
            this.fregister[i].reset();
        }
    }

    public ExecInfo exec_second() {
        return null;
    }

    public ExecInfo exec_first() throws ExecutableElementException {
        OperationCode operationCode = null;
        ExecInfo execInfo = new ExecInfo();
        execInfo.setCycle(1);
        execInfo.setTerminatableFlag(false);
        try {
            operationCode = this.readProgram(this.register[31].intValue());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ExecutableElementException("program address error");
        }
        if (this.waitFlag) {
            return execInfo;
        }
        switch (operationCode.inst) {
            case 0: {
                execInfo.setTerminatableFlag(true);
                break;
            }
            case 1: {
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 16: {
                Register register = this.getRegister(operationCode.args[1]);
                Register register2 = this.getRegister(operationCode.args[2]);
                this.getRegister(operationCode.args[0]).add(register, register2);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 20: {
                this.getRegister(operationCode.args[0]).add(DataUtil.toSiginedInteger((char)DataUtil.toChar((byte)operationCode.args[1], (byte)operationCode.args[2])));
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 17: {
                Register register = this.getRegister(operationCode.args[1]);
                Register register3 = this.getRegister(operationCode.args[2]);
                this.getRegister(operationCode.args[0]).sub(register, register3);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 25: {
                Register register = this.getRegister(operationCode.args[0]);
                Register register4 = this.getRegister(operationCode.args[1]);
                register.neg(register4);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 21: {
                this.getRegister(operationCode.args[0]).add(-DataUtil.toSiginedInteger((char)DataUtil.toChar((byte)operationCode.args[1], (byte)operationCode.args[2])));
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 18: {
                Register register = this.getRegister(operationCode.args[1]);
                Register register5 = this.getRegister(operationCode.args[2]);
                this.getRegister(operationCode.args[0]).mult(register, register5);
                this.register[31].add(this.CODE_LENGTH);
                execInfo.setCycle(2);
                break;
            }
            case 19: {
                try {
                    Register register = this.getRegister(operationCode.args[1]);
                    Register register6 = this.getRegister(operationCode.args[2]);
                    this.getRegister(operationCode.args[0]).div(register, register6);
                }
                catch (ArithmeticException arithmeticException) {
                    this.status.fNaN = true;
                }
                this.register[31].add(this.CODE_LENGTH);
                execInfo.setCycle(2);
                break;
            }
            case 22: {
                Register register = this.getRegister(operationCode.args[1]);
                Register register7 = this.getRegister(operationCode.args[2]);
                this.getRegister(operationCode.args[0]).mod(register, register7);
                this.register[31].add(this.CODE_LENGTH);
                execInfo.setCycle(2);
                break;
            }
            case 23: {
                Register register = this.getRegister(operationCode.args[1]);
                Register register8 = this.getRegister(operationCode.args[2]);
                this.getRegister(operationCode.args[0]).shiftL(register, register8);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 24: {
                Register register = this.getRegister(operationCode.args[1]);
                Register register9 = this.getRegister(operationCode.args[2]);
                this.getRegister(operationCode.args[0]).shiftR(register, register9);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 32: {
                Register register = this.getRegister(operationCode.args[1]);
                Register register10 = this.getRegister(operationCode.args[2]);
                this.getRegister(operationCode.args[0]).or(register, register10);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 33: {
                Register register = this.getRegister(operationCode.args[1]);
                Register register11 = this.getRegister(operationCode.args[2]);
                this.getRegister(operationCode.args[0]).and(register, register11);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 48: {
                this.register[31].set(this.register[operationCode.args[0]].intValue());
                break;
            }
            case 49: {
                this.register[31].set(DataUtil.toChar((byte)operationCode.args[0], (byte)operationCode.args[1]));
                break;
            }
            case 50: {
                if (this.status.fCondition) {
                    this.register[31].set(this.register[operationCode.args[0]].intValue());
                    break;
                }
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 51: {
                if (this.status.fCondition) {
                    this.register[31].set(DataUtil.toChar((byte)operationCode.args[0], (byte)operationCode.args[1]));
                    break;
                }
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 64: {
                Register register = this.getRegister(operationCode.args[1]);
                Register register12 = this.getRegister(operationCode.args[2]);
                if (register.eqeq(register12)) {
                    this.getRegister(operationCode.args[0]).set(0);
                    this.status.fCondition = true;
                } else {
                    this.getRegister(operationCode.args[0]).set(1);
                    this.status.fCondition = false;
                }
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 65: {
                Register register = this.getRegister(operationCode.args[1]);
                Register register13 = this.getRegister(operationCode.args[2]);
                if (!register.eqeq(register13)) {
                    this.getRegister(operationCode.args[0]).set(0);
                    this.status.fCondition = true;
                } else {
                    this.getRegister(operationCode.args[0]).set(1);
                    this.status.fCondition = false;
                }
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 66: {
                Register register = this.getRegister(operationCode.args[1]);
                Register register14 = this.getRegister(operationCode.args[2]);
                if (!register.gt(register14) && !register.eqeq(register14)) {
                    this.getRegister(operationCode.args[0]).set(0);
                    this.status.fCondition = true;
                } else {
                    this.getRegister(operationCode.args[0]).set(1);
                    this.status.fCondition = false;
                }
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 67: {
                Register register = this.getRegister(operationCode.args[1]);
                Register register15 = this.getRegister(operationCode.args[2]);
                if (register.gt(register15)) {
                    this.getRegister(operationCode.args[0]).set(0);
                    this.status.fCondition = true;
                } else {
                    this.getRegister(operationCode.args[0]).set(1);
                    this.status.fCondition = false;
                }
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 68: {
                Register register = this.getRegister(operationCode.args[1]);
                Register register16 = this.getRegister(operationCode.args[2]);
                if (!register.gt(register16)) {
                    this.getRegister(operationCode.args[0]).set(0);
                    this.status.fCondition = true;
                } else {
                    this.getRegister(operationCode.args[0]).set(1);
                    this.status.fCondition = false;
                }
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 69: {
                Register register = this.getRegister(operationCode.args[1]);
                Register register17 = this.getRegister(operationCode.args[2]);
                if (register.gt(register17) || register.eqeq(register17)) {
                    this.getRegister(operationCode.args[0]).set(0);
                    this.status.fCondition = true;
                } else {
                    this.getRegister(operationCode.args[0]).set(1);
                    this.status.fCondition = false;
                }
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case -128: {
                this.loadData(operationCode.args[1], this.getRegister(operationCode.args[0]).intValue(), 2);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case -126: {
                this.loadData(operationCode.args[1], this.getRegister(operationCode.args[0]).intValue(), 1);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case -124: {
                this.loadData(operationCode.args[1], this.getRegister(operationCode.args[0]).intValue(), 4);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case -122: {
                this.loadData(operationCode.args[1], this.getRegister(operationCode.args[0]).intValue(), 4);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case -127: {
                this.storeData(this.getRegister(operationCode.args[1]).byteArray(2, 2), this.getRegister(operationCode.args[0]).intValue(), 2);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case -125: {
                this.storeData(this.getRegister(operationCode.args[1]).byteArray(3, 1), this.getRegister(operationCode.args[0]).intValue(), 1);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case -123: {
                this.storeData(this.getRegister(operationCode.args[1]).byteArray(), this.getRegister(operationCode.args[0]).intValue(), 4);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 81: {
                Register register = this.getRegister(operationCode.args[0]);
                register.set(DataUtil.subArray((byte[])operationCode.args, (int)1, (int)2));
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 80: {
                this.getRegister(operationCode.args[0]).set(this.getRegister(operationCode.args[1]));
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 96: {
                this.getRegister(operationCode.args[0]).set(this.pop());
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 97: {
                this.push(this.getRegister(operationCode.args[0]));
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 100: {
                this.push(this.register[31]);
                this.register[31].set(this.getRegister(operationCode.args[0]).intValue());
                break;
            }
            case 101: {
                this.push(this.register[31]);
                this.register[31].set(DataUtil.toChar((byte)operationCode.args[0], (byte)operationCode.args[1]));
                break;
            }
            case 102: {
                this.register[31].set(this.pop().intValue() + this.CODE_LENGTH);
                break;
            }
            case 103: {
                int n = this.register[30].intValue();
                int n2 = DataUtil.toSiginedInteger((char)DataUtil.toChar((byte[])DataUtil.subArray((byte[])operationCode.args, (int)1, (int)2), (int)0, (int)2));
                this.getRegister(operationCode.args[0]).set(this.memory.read(n + n2, 4));
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 104: {
                int n = this.register[30].intValue();
                int n3 = DataUtil.toSiginedInteger((char)DataUtil.toChar((byte[])DataUtil.subArray((byte[])operationCode.args, (int)1, (int)2), (int)0, (int)2));
                this.memory.write(n + n3, 4, this.getRegister(operationCode.args[0]).byteArray());
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case -112: {
                Register register = this.getRegister(operationCode.args[0]);
                Register register18 = this.getRegister(operationCode.args[1]);
                this.getRegister(operationCode.args[0]).set((int)Math.sin(register18.intValue()));
                this.register[31].add(this.CODE_LENGTH);
                execInfo.setCycle(24);
                break;
            }
            case -111: {
                Register register = this.getRegister(operationCode.args[0]);
                Register register19 = this.getRegister(operationCode.args[1]);
                this.getRegister(operationCode.args[0]).set((int)Math.cos(register19.intValue()));
                this.register[31].add(this.CODE_LENGTH);
                execInfo.setCycle(24);
                break;
            }
            case -110: {
                Register register = this.getRegister(operationCode.args[0]);
                Register register20 = this.getRegister(operationCode.args[1]);
                ((FloatRegister)this.getRegister(operationCode.args[0])).set((float)Math.sin(register20.floatValue()));
                this.register[31].add(this.CODE_LENGTH);
                execInfo.setCycle(24);
                break;
            }
            case -109: {
                Register register = this.getRegister(operationCode.args[0]);
                Register register21 = this.getRegister(operationCode.args[1]);
                ((FloatRegister)this.getRegister(operationCode.args[0])).set((float)Math.sin(register21.floatValue()));
                this.register[31].add(this.CODE_LENGTH);
                execInfo.setCycle(24);
                break;
            }
            case -108: {
                Register register = this.getRegister(operationCode.args[0]);
                Register register22 = this.getRegister(operationCode.args[1]);
                this.getRegister(operationCode.args[0]).set((int)Math.sqrt(register22.intValue()));
                this.register[31].add(this.CODE_LENGTH);
                execInfo.setCycle(24);
                break;
            }
            case -107: {
                Register register = this.getRegister(operationCode.args[0]);
                Register register23 = this.getRegister(operationCode.args[1]);
                ((FloatRegister)this.getRegister(operationCode.args[0])).set((float)Math.sqrt(register23.floatValue()));
                this.register[31].add(this.CODE_LENGTH);
                execInfo.setCycle(24);
                break;
            }
            default: {
                throw new ExecutableElementException("unknow op code " + String.valueOf(operationCode.inst));
            }
        }
        return execInfo;
    }

    private void storeData(byte[] byArray, int n, int n2) throws ExecutableElementException {
        if (n < this.memory.size()) {
            this.memory.write(n, n2, byArray);
        } else {
            ChannelManager.Element element = this.channelManager.search(n);
            try {
                element.getChannel().writeRequest((ChannelConnectable)this, RandomAccessMemoryDataPacket.writePacket(n - element.offset, n2, 8, byArray));
            }
            catch (MicsException micsException) {
                throw new ExecutableElementException((Throwable)micsException);
            }
        }
    }

    private void loadData(int n, int n2, int n3) throws ExecutableElementException {
        if (n2 < this.memory.size()) {
            this.getRegister(n).set(this.memory.read(n2, n3));
        } else {
            this.readRequestRegID = n;
            ChannelManager.Element element = this.channelManager.search(n2);
            try {
                element.getChannel().readRequest((ChannelConnectable)this, RandomAccessMemoryDataPacket.readPacket(n2 - element.offset, n3, 8));
            }
            catch (MicsException micsException) {
                throw new ExecutableElementException((Throwable)micsException);
            }
        }
    }

    private Register pop() throws ExecutableElementException {
        if (this.register[29].intValue() < this.memory.size() - 1) {
            IntRegister intRegister = new IntRegister();
            intRegister.set(this.memory.read(this.register[29].intValue(), 4));
            this.register[29].add(4);
            return intRegister;
        }
        throw new ExecutableElementException("stack under flow");
    }

    private void push(Register register) throws ExecutableElementException {
        if (this.register[29].intValue() <= 4) {
            System.out.println("stack pointer " + this.register[29]);
            throw new ExecutableElementException("stack over flow");
        }
        this.register[29].add(-4);
        this.memory.write(this.register[29].intValue(), 4, register.byteArray());
    }

    private OperationCode readProgram(int n) {
        byte[] byArray = this.memory.read(n + this.programOffset, 4);
        return new OperationCode(byArray[0], byArray[1], byArray[2], byArray[3]);
    }

    public void writeback(MicsDataPacket micsDataPacket) {
        if (micsDataPacket instanceof RandomAccessMemoryDataPacket) {
            RandomAccessMemoryDataPacket randomAccessMemoryDataPacket = (RandomAccessMemoryDataPacket)micsDataPacket;
            switch (randomAccessMemoryDataPacket.length * randomAccessMemoryDataPacket.width / 8) {
                case 1: {
                    this.register[this.readRequestRegID].set(randomAccessMemoryDataPacket.data);
                    break;
                }
                case 2: {
                    this.register[this.readRequestRegID].set(randomAccessMemoryDataPacket.data);
                    break;
                }
                case 4: {
                    this.register[this.readRequestRegID].set(randomAccessMemoryDataPacket.data);
                }
            }
        } else if (micsDataPacket instanceof InterruptDataPacket) {
            InterruptDataPacket interruptDataPacket = (InterruptDataPacket)micsDataPacket;
            try {
                this.storeData(interruptDataPacket.data, 0xA000002, interruptDataPacket.data.length);
            }
            catch (ExecutableElementException executableElementException) {
                // empty catch block
            }
        }
    }

    public int getChannelOffset(Channel channel) {
        return this.channelManager.search(channel);
    }

    public String getInfo() {
        String string = "";
        string = string + "SimpleProcessor32\n";
        string = string + "  CLASS: " + ((Object)((Object)this)).getClass().getName() + "\n";
        string = string + "  ID: " + this.id() + "\n";
        string = string + "  Local Memory ID: " + this.memory.id() + ",";
        string = string + " offset = " + DataUtil.toBigEndianValueString((byte[])DataUtil.toByteArray((int)this.programOffset)) + "\n";
        ChannelManager.Element[] elementArray = this.channelManager.array();
        for (int i = 0; i < elementArray.length; ++i) {
            ChannelManager.Element element = elementArray[i];
            string = string + "  Channel ID: " + element.id + ",";
            string = string + " offset = " + element.offset + "\n";
        }
        return string;
    }

    public String toString() {
        try {
            String string = "";
            try {
                string = string + this.register[31] + ":";
            }
            catch (FormatException formatException) {
                formatException.printStackTrace();
            }
            string = string + this.readProgram(this.register[31].intValue()).toString();
            string = string + "\n";
            for (int i = 0; i < 32; ++i) {
                try {
                    string = string + this.register[i];
                    if (i % 8 == 7) {
                        string = string + "\n";
                        continue;
                    }
                    string = string + " ";
                    continue;
                }
                catch (FormatException formatException) {
                    // empty catch block
                }
            }
            return string;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return new String(this.register[31].intValue() + ": illegal program counter");
        }
    }

    public String[] getConnectedElements() {
        return this.channelManager.getConnectedElements();
    }

    public void show() {
        if (this.table == null) {
            int n;
            String[] stringArray = new String[32];
            String[] stringArray2 = new String[32];
            for (n = 0; n < 32; ++n) {
                stringArray[n] = String.valueOf(n);
            }
            for (n = 0; n < 32; ++n) {
                stringArray2[n] = String.valueOf(n + 32);
            }
            this.table = new MicsTablePanel("SimpleProcessor32 Register", (TableModel)new MicsTableModel(new String[]{"name", "value", "name", "value"}, (Object[][])new Object[][]{stringArray, this.register, stringArray2, this.fregister}));
        }
        this.table.setVisible(true);
    }

    public String getImagePath() {
        return "combo_processor.png";
    }

    class OperationCode {
        private byte inst;
        private byte[] args = new byte[3];

        OperationCode(byte by, byte by2, byte by3, byte by4) {
            this.inst = by;
            this.args[0] = by2;
            this.args[1] = by3;
            this.args[2] = by4;
        }

        public String toString() {
            String string = "";
            switch (this.inst) {
                case 0: {
                    string = string + "HALT ";
                    break;
                }
                case 1: {
                    string = string + "NOP  ";
                    break;
                }
                case 16: {
                    string = string + "ADD  ";
                    break;
                }
                case 20: {
                    string = string + "ADDI ";
                    break;
                }
                case 17: {
                    string = string + "SUB  ";
                    break;
                }
                case 25: {
                    string = string + "NEG  ";
                    break;
                }
                case 21: {
                    string = string + "SUBI ";
                    break;
                }
                case 18: {
                    string = string + "MULT ";
                    break;
                }
                case 19: {
                    string = string + "DIV  ";
                    break;
                }
                case 22: {
                    string = string + "MOD  ";
                    break;
                }
                case 23: {
                    string = string + "LSHS ";
                    break;
                }
                case 24: {
                    string = string + "RSHS ";
                    break;
                }
                case 32: {
                    string = string + "OR   ";
                    break;
                }
                case 33: {
                    string = string + "AND  ";
                    break;
                }
                case 48: {
                    string = string + "JMP  ";
                    break;
                }
                case 49: {
                    string = string + "JMPI ";
                    break;
                }
                case 50: {
                    string = string + "JCC  ";
                    break;
                }
                case 51: {
                    string = string + "JCCI ";
                    break;
                }
                case 64: {
                    string = string + "EQ   ";
                    break;
                }
                case 65: {
                    string = string + "NEQ  ";
                    break;
                }
                case 66: {
                    string = string + "LT   ";
                    break;
                }
                case 67: {
                    string = string + "GT   ";
                    break;
                }
                case 68: {
                    string = string + "LEQ  ";
                    break;
                }
                case 69: {
                    string = string + "GEQ  ";
                    break;
                }
                case -128: {
                    string = string + "LDR  ";
                    break;
                }
                case -127: {
                    string = string + "STR  ";
                    break;
                }
                case -126: {
                    string = string + "LDR8 ";
                    break;
                }
                case -125: {
                    string = string + "STR8 ";
                    break;
                }
                case -124: {
                    string = string + "LDR32";
                    break;
                }
                case -123: {
                    string = string + "STR32";
                    break;
                }
                case -122: {
                    string = string + "LDRF ";
                    break;
                }
                case 80: {
                    string = string + "MOV  ";
                    break;
                }
                case 81: {
                    string = string + "MOVI ";
                    break;
                }
                case 82: {
                    string = string + "MOVIL";
                    break;
                }
                case 83: {
                    string = string + "MOVIH";
                    break;
                }
                case 96: {
                    string = string + "POP  ";
                    break;
                }
                case 97: {
                    string = string + "PUSH ";
                    break;
                }
                case 100: {
                    string = string + "CALL ";
                    break;
                }
                case 101: {
                    string = string + "CALLI";
                    break;
                }
                case 102: {
                    string = string + "RET  ";
                    break;
                }
                case 103: {
                    string = string + "LDA  ";
                    break;
                }
                case 104: {
                    string = string + "STA  ";
                    break;
                }
                case -111: {
                    string = string + "COS  ";
                    break;
                }
                case -112: {
                    string = string + "SIN  ";
                    break;
                }
                case -109: {
                    string = string + "COSF  ";
                    break;
                }
                case -110: {
                    string = string + "SINF  ";
                    break;
                }
                case -108: {
                    string = string + "SQRT  ";
                    break;
                }
                case -107: {
                    string = string + "SQRTF ";
                    break;
                }
                default: {
                    string = string + "ERROR";
                }
            }
            string = string + ",";
            try {
                string = string + PrintFormat.print((String)"%02x", (byte)this.args[0]);
                string = string + ",";
                string = string + PrintFormat.print((String)"%02x", (byte)this.args[1]);
                string = string + ",";
                string = string + PrintFormat.print((String)"%02x", (byte)this.args[2]);
            }
            catch (FormatException formatException) {
                formatException.printStackTrace();
            }
            return string;
        }
    }

    class StateFlagGroup {
        public boolean fNaN = false;
        public boolean fAddressError = false;
        public boolean fCondition = false;
        public boolean fCarry = false;

        StateFlagGroup() {
        }

        public void reset() {
            this.fNaN = false;
            this.fAddressError = false;
            this.fCondition = false;
            this.fCarry = false;
        }
    }
}

