/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.gdb;

class InstInfo {
    public static final int no_op = -1;
    public static final int imm = 0;
    public static final int reg = 1;
    public static final int value = 2;
    public static final int label = 2;
    public static final int pr = 4;
    String name;
    int[] operand;
    int state;
    int stage;
    int state_dsp;
    int stage_dsp;
    boolean dsp_modifier = false;

    InstInfo(String string, int[] nArray, int n, int n2) {
        this.name = string;
        this.operand = nArray;
        this.state = n;
        this.stage = n2;
    }

    InstInfo(String string, int[] nArray, int n, int n2, int n3, int n4) {
        this(string, nArray, n, n3);
        this.dsp_modifier = true;
        this.state_dsp = n2;
        this.stage_dsp = n4;
    }

    public int getState() {
        return this.state;
    }

    public int getStage() {
        return this.stage;
    }

    public boolean equals(String string, int[] nArray) {
        if (!this.name.equals(string)) {
            return false;
        }
        if (nArray.length != this.operand.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == this.operand[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String string = "";
        string = string + this.name + ":";
        String string2 = "";
        for (int i = 0; i < this.operand.length; ++i) {
            string2 = string2 + "," + InstInfo.getOpTypeString(this.operand[i]);
        }
        if (string2.length() > 1) {
            string = string + string2.substring(1);
        }
        string = string + "  [";
        string = string + "states = " + this.state;
        if (this.state_dsp > 0) {
            string = string + "(" + this.state_dsp + ")";
        }
        string = string + ",stages = " + this.stage;
        if (this.state_dsp > 0) {
            string = string + "(" + this.stage_dsp + ")";
        }
        string = string + "]";
        return string;
    }

    public static String getOpTypeString(int n) {
        switch (n) {
            case -1: {
                return "none";
            }
            case 0: {
                return "imm";
            }
            case 1: {
                return "reg";
            }
            case 2: {
                return "value";
            }
            case 4: {
                return "pr";
            }
        }
        return "unknown";
    }

    public static int getOpType(String string) {
        if (string == null || string.equals("")) {
            return -1;
        }
        if (string.charAt(0) == '#') {
            return 0;
        }
        if (string.charAt(0) == 'r') {
            return 1;
        }
        if (string.charAt(0) == '@') {
            return 2;
        }
        if (string.charAt(0) == '0') {
            return 2;
        }
        if (string.toLowerCase().equals("pr")) {
            return 4;
        }
        return -1;
    }
}

