/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.gdb;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.wasamon.jgdb.GDBClient;
import net.wasamon.jgdb.GDBMIInterface;
import net.wasamon.jgdb.GDBXMLClient;
import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.ExecutableElementException;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.memory.RandomAccessMemoryDataPacket;
import net.wasamon.mics.processor.gdb.InstInfo;
import net.wasamon.mics.processor.gdb.SHInstList;
import net.wasamon.mics.util.ChannelManager;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Node;

public class SH3
extends MicsElement
implements ExecutableElement,
ChannelConnectable {
    private GDBClient gdb;
    private ChannelManager channelManager;
    String destRegister;
    int destWidth;
    private boolean terminatedFlag;
    private String targetFilePath;
    private String targetGdbPath;
    private String targetGdbHostName;
    private int targetGdbPort;
    private OperationCode lastCode;

    private void memoryHook(OperationCode operationCode) throws ExecutableElementException {
        if (operationCode.operand[0].type == 1 && operationCode.operand[1].type == 2) {
            int n = DataUtil.parseInt((String)this.gdb.readRegister(operationCode.operand[0].value));
            int n2 = operationCode.getAccessAddress(1);
            ChannelManager.Element element = this.channelManager.search(n2);
            try {
                MicsDataPacket micsDataPacket = null;
                byte[] byArray = DataUtil.toByteArray((int)n);
                switch (operationCode.width) {
                    case 1: {
                        micsDataPacket = RandomAccessMemoryDataPacket.writePacket(n2 - element.offset, 1, 8, new byte[]{byArray[3]});
                        break;
                    }
                    case 2: {
                        micsDataPacket = RandomAccessMemoryDataPacket.writePacket(n2 - element.offset, 1, 16, new byte[]{byArray[2], byArray[3]});
                        break;
                    }
                    case 4: {
                        micsDataPacket = RandomAccessMemoryDataPacket.writePacket(n2 - element.offset, 2, 16, byArray);
                    }
                }
                element.getChannel().writeRequest((ChannelConnectable)this, micsDataPacket);
            }
            catch (MicsException micsException) {
                System.out.println("SH3 memory hook exception: " + micsException.getMessage());
                throw new ExecutableElementException((Throwable)micsException);
            }
        } else if (operationCode.operand[0].type == 2 && operationCode.operand[1].type == 1) {
            this.destRegister = operationCode.operand[1].value;
            this.destWidth = operationCode.width;
            int n = operationCode.preOperandValue[0];
            ChannelManager.Element element = this.channelManager.search(n);
            try {
                MicsDataPacket micsDataPacket = null;
                micsDataPacket = RandomAccessMemoryDataPacket.readPacket(n - element.offset, operationCode.width, 8);
                element.getChannel().readRequest((ChannelConnectable)this, micsDataPacket);
            }
            catch (MicsException micsException) {
                throw new ExecutableElementException((Throwable)micsException);
            }
        } else {
            System.out.println("unsupported data transfer instruction:" + operationCode);
        }
    }

    public void writeback(MicsDataPacket micsDataPacket) {
        RandomAccessMemoryDataPacket randomAccessMemoryDataPacket = (RandomAccessMemoryDataPacket)micsDataPacket;
        this.gdb.setValueToRegister("$" + this.destRegister, DataUtil.toBigEndianValueString((byte[])randomAccessMemoryDataPacket.data));
    }

    public int getChannelOffset(Channel channel) {
        return this.channelManager.search(channel);
    }

    public ExecInfo exec_first() throws ExecutableElementException {
        ExecInfo execInfo = new ExecInfo();
        if (this.terminatedFlag) {
            execInfo.setTerminatableFlag(true);
        } else {
            try {
                String string = this.gdb.readPCCode();
                String[] stringArray = string.split(":\\s+");
                OperationCode operationCode = new OperationCode(stringArray[1]);
                this.gdb.stepInstruction();
                this.lastCode = operationCode;
                execInfo.setCycle(this.lastCode.info.getState());
                if (this.gdb.isStopped()) {
                    if (this.gdb.getSignal() != null) {
                        String string2 = this.gdb.getSignal();
                        if (string2.startsWith("SIGBUS") || string2.startsWith("SIGEMT")) {
                            this.memoryHook(operationCode);
                        } else {
                            System.out.println("signal:" + string2);
                        }
                        this.gdb.setValueToRegister("$pc", "$pc+2");
                    } else {
                        this.terminatedFlag = true;
                        execInfo.setTerminatableFlag(true);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new ExecutableElementException((Throwable)exception);
            }
        }
        return execInfo;
    }

    public ExecInfo exec_second() throws ExecutableElementException {
        ExecInfo execInfo = new ExecInfo();
        return execInfo;
    }

    public void reset() {
        if (this.gdb != null) {
            this.gdb.doInit(new File(this.targetFilePath), "main");
        }
        this.terminatedFlag = false;
    }

    public void init(String string, String string2, String string3) throws MicsException {
        block4: {
            this.targetGdbPath = string3;
            this.targetFilePath = string2;
            try {
                if (string.equals("local")) {
                    this.gdb = new GDBMIInterface(string3);
                    break block4;
                }
                if (string.equals("xmlrpc")) {
                    this.gdb = new GDBXMLClient(string3);
                    break block4;
                }
                throw new MicsException("illetal type value: " + string);
            }
            catch (IOException iOException) {
                throw new MicsException("cannot initialize net.wasamon.mics.processor.gdb.SH3");
            }
        }
        this.gdb.doInit(new File(string2), "main");
    }

    public void initialize(String string, Node node) throws MicsException {
        this.channelManager = new ChannelManager(this.composite);
        try {
            Node node2 = node;
            String string2 = XMLParser.getAttribute((Node)node2, (String)"target").getNodeValue();
            String string3 = XMLParser.getAttribute((Node)node2, (String)"gdb").getNodeValue();
            String string4 = XMLParser.getAttribute((Node)node2, (String)"type").getNodeValue();
            this.init(string4, string2, string3);
            Node[] nodeArray = XMLParser.getNamedNodeArray((Node)node, (String)"channel");
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node3 = nodeArray[i];
                String string5 = XMLParser.getAttribute((Node)node3, (String)"id").getNodeValue();
                int n = DataUtil.parseInt((String)XMLParser.getAttribute((Node)node3, (String)"offset").getNodeValue());
                this.channelManager.add(string5, n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.processor.gdb");
        }
        catch (XMLParserException xMLParserException) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.processor.gdb");
        }
    }

    public void execStepCode() throws Exception {
        String string = this.gdb.readPCCode();
        String[] stringArray = string.split(":\\s+");
        OperationCode operationCode = new OperationCode(stringArray[1]);
        this.memoryHook(operationCode);
        this.gdb.stepInstruction();
        this.memoryHook(operationCode);
        this.lastCode = operationCode;
    }

    public void execAll() {
        Calendar calendar = Calendar.getInstance();
        System.out.println("start execution at " + calendar.getTime());
        long l = calendar.getTimeInMillis();
        int n = 0;
        try {
            do {
                this.execStepCode();
                ++n;
            } while (!this.gdb.isStopped());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        calendar = Calendar.getInstance();
        System.out.println("stop execution at " + calendar.getTime());
        long l2 = calendar.getTimeInMillis() - l;
        System.out.print("exec cycles: " + n);
        if (l2 > 0L) {
            System.out.println(" C/S: " + (double)n / (double)l2 + "kHz");
        } else {
            System.out.println("");
        }
    }

    public void shutdown() {
        this.gdb.doQuit();
    }

    public static void main(String[] stringArray) throws Exception {
        SH3 sH3 = new SH3();
        sH3.init("local", "l:\\a.out", "sh-hitachi-elf-gdb");
        sH3.execAll();
        sH3.shutdown();
    }

    public String[] getConnectedElements() {
        return this.channelManager.getConnectedElements();
    }

    public String getInfo() {
        String string = "";
        string = string + "id: " + super.id() + "\n";
        string = string + "class: " + ((Object)((Object)this)).getClass().getName() + "\n";
        string = string + "gdb: " + this.targetGdbPath + "\n";
        string = string + "host: " + this.targetGdbHostName + "\n";
        string = string + "port: " + this.targetGdbPort + "\n";
        string = string + "target: " + this.targetFilePath + "\n";
        ChannelManager.Element[] elementArray = this.channelManager.array();
        for (int i = 0; i < elementArray.length; ++i) {
            ChannelManager.Element element = elementArray[i];
            string = string + "  Channel ID: " + element.id + ",";
            string = string + " offset = " + element.offset + "\n";
        }
        return string;
    }

    public String toString() {
        return this.getInfo() + this.lastCode.toString();
    }

    public String getImagePath() {
        return "superh.png";
    }

    class OperationCode {
        String op_name;
        InstInfo info;
        Operand[] operand;
        int[] preOperandValue;
        int width;
        private Pattern codePattern = Pattern.compile("(\\S+)\\s*(.*)\\s*");
        private Pattern dispRegPattern = Pattern.compile("@\\((\\d+),(.+)\\)");

        public int getOperandWidth(String string) {
            int n = this.op_name.indexOf(".W") > 0 ? 2 : (this.op_name.indexOf(".L") > 0 ? 4 : (this.op_name.indexOf(".B") > 0 ? 1 : 2));
            return n;
        }

        public OperationCode(String string) throws Exception {
            Matcher matcher = this.codePattern.matcher(string);
            if (!matcher.matches()) {
                throw new Exception("syntax error");
            }
            this.op_name = matcher.group(1).toUpperCase();
            this.width = this.getOperandWidth(this.op_name);
            this.operand = this.parseOperand(matcher.group(2));
            this.info = SHInstList.getInstance().getInstInfo(this.op_name, this.getType());
            this.preOperandValue = new int[this.operand.length];
            for (int i = 0; i < this.operand.length; ++i) {
                if (this.operand[i].type != 2) continue;
                this.preOperandValue[i] = this.getAccessAddress(i);
            }
        }

        private int[] getType() {
            int[] nArray = new int[this.operand.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.operand[i].type;
            }
            return nArray;
        }

        private Operand[] parseOperand(String string) {
            Operand[] operandArray = null;
            if (string.equals("")) {
                operandArray = new Operand[]{};
            } else {
                String[] stringArray = string.split(",");
                String[] stringArray2 = new String[stringArray.length];
                int n = 0;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (stringArray[n2].indexOf(40) > 0) {
                        stringArray2[n] = stringArray[n2] + "," + stringArray[n2 + 1];
                        ++n2;
                    } else {
                        stringArray2[n] = stringArray[n2];
                    }
                    ++n2;
                    ++n;
                }
                operandArray = new Operand[n];
                for (n2 = 0; n2 < operandArray.length; ++n2) {
                    operandArray[n2] = new Operand(InstInfo.getOpType(stringArray2[n2]), stringArray2[n2]);
                }
            }
            return operandArray;
        }

        public String toString() {
            String string = "";
            string = string + "[OperationCode] " + this.op_name;
            for (int i = 0; i < this.operand.length; ++i) {
                string = string + " " + this.operand[i];
            }
            return string;
        }

        public int getOperandSize() {
            return this.operand.length;
        }

        public int getAccessAddress(int n) {
            String string = this.operand[n].value;
            String string2 = null;
            if (string.startsWith("@r")) {
                if (string.endsWith("+")) {
                    string2 = SH3.this.gdb.readRegister(string.substring(1, string.length() - 1));
                    return DataUtil.parseInt((String)string2);
                }
                string2 = SH3.this.gdb.readRegister(string.substring(1));
                return DataUtil.parseInt((String)string2);
            }
            if (string.startsWith("@-r")) {
                string2 = SH3.this.gdb.readRegister(string.substring(2));
                return DataUtil.parseInt((String)string2);
            }
            if (string.startsWith("@(r0,")) {
                String string3 = string.substring(2, string.length() - 1);
                String[] stringArray = string3.split(",");
                String string4 = SH3.this.gdb.readRegister(stringArray[0]);
                String string5 = SH3.this.gdb.readRegister(stringArray[1]);
                return DataUtil.parseInt((String)string4) + DataUtil.parseInt((String)string5);
            }
            if (string.startsWith("@")) {
                Matcher matcher = this.dispRegPattern.matcher(string);
                if (matcher.matches()) {
                    int n2 = DataUtil.parseInt((String)matcher.group(1));
                    string2 = SH3.this.gdb.readRegister(matcher.group(2));
                    return DataUtil.parseInt((String)string2) + n2;
                }
                System.out.println("unsupported access: " + string);
                return 0;
            }
            if (string.charAt(0) == '0') {
                String[] stringArray = string.split("\\s+");
                return DataUtil.parseInt((String)stringArray[0]);
            }
            System.out.println("unsupported access: " + string);
            return 0;
        }

        class Operand {
            int type;
            String value;

            public Operand(int n, String string) {
                this.type = n;
                this.value = string;
            }

            public String toString() {
                return this.value + "%" + InstInfo.getOpTypeString(this.type);
            }
        }
    }
}

