/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.mips;

import net.wasamon.mics.memory.RandomAccessMemory;

public class ELFHeader {
    private static final int ELFMAG0 = 127;
    private static final int ELFMAG1 = 69;
    private static final int ELFMAG2 = 76;
    private static final int ELFMAG3 = 70;
    private static final int ELFMAG = 2135247942;
    private static final int ELFCLASS32 = 1;
    private static final int ELFDATA2MSB = 2;
    private static final int ET_EXEC = 2;
    private static final int EV_CURRENT = 1;
    private static final int EM_NONE = 0;
    private static final int EM_M32 = 1;
    private static final int EM_SPARC = 2;
    private static final int EM_386 = 3;
    private static final int EM_68K = 4;
    private static final int EM_88K = 5;
    private static final int EM_486 = 6;
    private static final int EM_860 = 7;
    private static final int EM_MIPS = 8;
    private static final int EM_MIPS_RS4_BE = 10;
    private static final int EM_SPARC64 = 11;
    private static final int EM_PARISC = 15;
    private static final int EM_SPARC32PLUS = 18;
    private static final int EM_PPC = 20;
    private static final int EM_ARM = 40;
    private static final int EM_ALPHA = 41;
    private static final int EM_SPARCV9 = 43;
    private static final int EM_ALPHA_EXP = 36902;
    private static final int EM_AMD64 = 62;
    private static final int EM_VAX = 75;
    private static final String[] eht_string_class = new String[]{"invalid", "ELF32", "ELF64"};
    private static final String[] eht_string_data = new String[]{"invalid", "Little-Endian", "Big-Endian"};
    private static final String[] eht_string_version = new String[]{"none", "current"};
    private static final String[] eht_string_osabi = new String[]{"UNIX System V ABI", "HP-UX operating system", "NetBSD", "GNU/Linux", "GNU/Hurd", "86Open common IA32 ABI", "Solaris", "Monterey", "IRIX", "FreeBSD", "TRU64 UNIX", "Novell Modesto", "OpenBSD", "ARM", "Standalone (embedded) application"};
    private static final String[] eht_string_type = new String[]{"NONE", "REL", "EXEC", "DYN", "CORE", "NUM"};
    private static final String[] pht_string = new String[]{"NULL", "LOAD", "DYNAMIC", "INTERP", "NOTE", "SHLIB", "PHDR", "NUM", "REGINFO", "RTPROC", "OPTIONS"};
    private static final String[] sht_string = new String[]{"NULL", "PROGBITS", "SYMTAB", "STRTAB", "RELA", "HASH", "DYNAMIC", "NOTE", "NOBITS", "REL", "SHLIB", "DYNSYM", "NUM"};
    private static final String[] sht_string_mips = new String[]{"MIPS_LIBLIST", "MIPS_MSYM", "MIPS_CONFLICT", "MIPS_GPTAB", "MIPS_UCODE", "MIPS_DEBUG", "MIPS_REGINFO", "MIPS_PACKAGE", "MIPS_PACKSYM", "MIPS_RELD", "0x7000000a", "MIPS_IFACE", "MIPS_CONTENT", "MIPS_OPTIONS", "0x7000000e", "0x7000000f", "MIPS_SHDR", "MIPS_FDESC", "MIPS_EXTSYM", "MIPS_DENSE", "MIPS_PDESC", "MIPS_LOCSYM", "MIPS_AUXSYM", "MIPS_OPTSYM", "MIPS_LOCSTR", "MIPS_LINE", "MIPS_RFDESC", "MIPS_DELTASYM", "MIPS_DELTAINST", "MIPS_DELTACLASS", "MIPS_DWARF", "MIPS_DELTADECL", "MIPS_SYMBOL_LIB", "MIPS_EVENTS", "MIPS_TRANSLATE", "MIPS_PIXIE", "MIPS_XLATE", "MIPS_XLATE_DEBUG", "MIPS_WHIRL", "MIPS_EH_REGION", "MIPS_XLATE_OLD", "MIPS_PDR_EXCEPTION"};
    private byte[] e_ident;
    private int e_type;
    private int e_machine;
    private int e_version;
    private int e_entry;
    private int e_phoff;
    private int e_shoff;
    private int e_flags;
    private int e_ehsize;
    private int e_phentsize;
    private int e_phnum;
    private int e_shentsize;
    private int e_shnum;
    private int e_shstrndx;
    private int[] p_type;
    private int[] p_offset;
    private int[] p_vaddr;
    private int[] p_paddr;
    private int[] p_filesz;
    private int[] p_memsz;
    private int[] p_flags;
    private int[] p_align;
    private int[] sh_name;
    private int[] sh_type;
    private int[] sh_flags;
    private int[] sh_addr;
    private int[] sh_offset;
    private int[] sh_size;
    private int[] sh_link;
    private int[] sh_info;
    private int[] sh_addralign;
    private int[] sh_entsize;
    private RandomAccessMemory memory;

    public ELFHeader(RandomAccessMemory randomAccessMemory) {
        this.memory = randomAccessMemory;
        this.analyzeHeaders();
    }

    public boolean isELFFormat() {
        return this.memory.read(0, 1)[0] == 127 && this.memory.read(1, 1)[0] == 69 && this.memory.read(2, 1)[0] == 76 && this.memory.read(3, 1)[0] == 70;
    }

    public boolean analyzeHeaders() {
        if (!this.isELFFormat()) {
            return false;
        }
        this.analyzeELFHeader();
        this.analyzeProgramHeaders();
        this.analyzeSectionHeaders();
        return true;
    }

    public void analyzeELFHeader() {
        this.e_ident = this.memory.read(0, 16);
        this.e_type = this.zeroExtend(this.memory.read(16, 2));
        this.e_machine = this.zeroExtend(this.memory.read(18, 2));
        this.e_version = this.zeroExtend(this.memory.read(20, 4));
        this.e_entry = this.zeroExtend(this.memory.read(24, 4));
        this.e_phoff = this.zeroExtend(this.memory.read(28, 4));
        this.e_shoff = this.zeroExtend(this.memory.read(32, 4));
        this.e_flags = this.zeroExtend(this.memory.read(36, 4));
        this.e_ehsize = this.zeroExtend(this.memory.read(40, 2));
        this.e_phentsize = this.zeroExtend(this.memory.read(42, 2));
        this.e_phnum = this.zeroExtend(this.memory.read(44, 2));
        this.e_shentsize = this.zeroExtend(this.memory.read(46, 2));
        this.e_shnum = this.zeroExtend(this.memory.read(48, 2));
        this.e_shstrndx = this.zeroExtend(this.memory.read(50, 2));
    }

    public void analyzeProgramHeaders() {
        this.p_type = new int[this.e_phnum];
        this.p_offset = new int[this.e_phnum];
        this.p_vaddr = new int[this.e_phnum];
        this.p_paddr = new int[this.e_phnum];
        this.p_filesz = new int[this.e_phnum];
        this.p_memsz = new int[this.e_phnum];
        this.p_flags = new int[this.e_phnum];
        this.p_align = new int[this.e_phnum];
        int n = this.e_phoff;
        for (int i = 0; i < this.e_phnum; ++i) {
            this.analyzeProgramHeader(i, n);
            n += this.e_phentsize;
        }
    }

    public void analyzeProgramHeader(int n, int n2) {
        this.p_type[n] = this.zeroExtend(this.memory.read(n2, 4));
        this.p_offset[n] = this.zeroExtend(this.memory.read(n2 + 4, 4));
        this.p_vaddr[n] = this.zeroExtend(this.memory.read(n2 + 8, 4));
        this.p_paddr[n] = this.zeroExtend(this.memory.read(n2 + 12, 4));
        this.p_filesz[n] = this.zeroExtend(this.memory.read(n2 + 16, 4));
        this.p_memsz[n] = this.zeroExtend(this.memory.read(n2 + 20, 4));
        this.p_flags[n] = this.zeroExtend(this.memory.read(n2 + 24, 4));
        this.p_align[n] = this.zeroExtend(this.memory.read(n2 + 28, 4));
    }

    public void analyzeSectionHeaders() {
        this.sh_name = new int[this.e_shnum];
        this.sh_type = new int[this.e_shnum];
        this.sh_flags = new int[this.e_shnum];
        this.sh_addr = new int[this.e_shnum];
        this.sh_offset = new int[this.e_shnum];
        this.sh_size = new int[this.e_shnum];
        this.sh_link = new int[this.e_shnum];
        this.sh_info = new int[this.e_shnum];
        this.sh_addralign = new int[this.e_shnum];
        this.sh_entsize = new int[this.e_shnum];
        int n = this.e_shoff;
        for (int i = 0; i < this.e_shnum; ++i) {
            this.analyzeSectionHeader(i, n);
            n += this.e_shentsize;
        }
    }

    public void analyzeSectionHeader(int n, int n2) {
        this.sh_name[n] = this.zeroExtend(this.memory.read(n2, 4));
        this.sh_type[n] = this.zeroExtend(this.memory.read(n2 + 4, 4));
        this.sh_flags[n] = this.zeroExtend(this.memory.read(n2 + 8, 4));
        this.sh_addr[n] = this.zeroExtend(this.memory.read(n2 + 12, 4));
        this.sh_offset[n] = this.zeroExtend(this.memory.read(n2 + 16, 4));
        this.sh_size[n] = this.zeroExtend(this.memory.read(n2 + 20, 4));
        this.sh_link[n] = this.zeroExtend(this.memory.read(n2 + 24, 4));
        this.sh_info[n] = this.zeroExtend(this.memory.read(n2 + 28, 4));
        this.sh_addralign[n] = this.zeroExtend(this.memory.read(n2 + 32, 4));
        this.sh_entsize[n] = this.zeroExtend(this.memory.read(n2 + 36, 4));
    }

    public String printELFHeader() {
        String string;
        String string2 = "ELF Header:\n  magic:                             ";
        String string3 = 0 <= this.e_ident[4] && this.e_ident[4] <= 2 ? eht_string_class[this.e_ident[4]] : String.valueOf(this.e_ident[4]);
        String string4 = 0 <= this.e_ident[5] && this.e_ident[5] <= 2 ? eht_string_data[this.e_ident[5]] : String.valueOf(this.e_ident[5]);
        String string5 = 0 <= this.e_ident[7] && this.e_ident[7] <= 12 ? eht_string_osabi[this.e_ident[7]] : (this.e_ident[7] == 97 ? eht_string_osabi[13] : (this.e_ident[7] == 255 ? eht_string_osabi[14] : String.valueOf(this.e_ident[7])));
        String string6 = String.valueOf(this.e_ident[6]);
        if (0 <= this.e_ident[6] && this.e_ident[6] <= 1) {
            string6 = string6 + " (" + eht_string_version[this.e_ident[6]] + ")";
        }
        String string7 = 0 <= this.e_type && this.e_type <= 5 ? eht_string_type[this.e_type] : String.valueOf(this.e_type);
        switch (this.e_machine) {
            case 0: {
                string = "No Machine";
                break;
            }
            case 1: {
                string = "AT&T WE 32100";
                break;
            }
            case 2: {
                string = "SPARC";
                break;
            }
            case 3: {
                string = "Intel 80386";
                break;
            }
            case 4: {
                string = "Motorola 68000";
                break;
            }
            case 5: {
                string = "Motorola 88000";
                break;
            }
            case 6: {
                string = "Intel 80486";
                break;
            }
            case 7: {
                string = "Intel 80860";
                break;
            }
            case 8: {
                string = "MIPS R3000 Big-Endian only";
                break;
            }
            case 10: {
                string = "MIPS R4000 Big-Endian";
                break;
            }
            case 11: {
                string = "SPARC v9 64-bit unoffical";
                break;
            }
            case 15: {
                string = "HPPA";
                break;
            }
            case 18: {
                string = "Enhanced instruction set SPARCEnhanced instruction set SPARC";
                break;
            }
            case 20: {
                string = "PowerPC";
                break;
            }
            case 40: {
                string = "Advanced RISC Machines ARM";
                break;
            }
            case 41: {
                string = "DEC ALPHA";
                break;
            }
            case 43: {
                string = "SPARC version 9";
                break;
            }
            case 36902: {
                string = "DEC ALPHADEC ALPHA";
                break;
            }
            case 62: {
                string = "AMD64 architecture";
                break;
            }
            case 75: {
                string = "DEC VAX";
                break;
            }
            default: {
                string = String.valueOf(this.e_machine);
            }
        }
        for (int i = 0; i < 4; ++i) {
            string2 = string2 + String.valueOf((char)this.e_ident[i]);
        }
        string2 = string2 + "\n";
        string2 = string2 + "  Class:                             " + string3 + "\n";
        string2 = string2 + "  Data:                              " + string4 + "\n";
        string2 = string2 + "  Version:                           " + string6 + "\n";
        string2 = string2 + "  OS/ABI:                            " + string5 + "\n";
        string2 = string2 + "  ABI Version:                       " + String.valueOf(this.e_ident[8]) + "\n";
        string2 = string2 + "  Type:                              " + string7 + "\n";
        string2 = string2 + "  Machine:                           " + string + "\n";
        string2 = string2 + "  Version:                           " + String.format("0x%x\n", this.e_version);
        string2 = string2 + "  Entry point address:               " + String.format("0x%08x\n", this.e_entry);
        string2 = string2 + "  Start of program headers:          " + String.format("0x%08x\n", this.e_phoff);
        string2 = string2 + "  Start of section headers:          " + String.format("0x%08x\n", this.e_shoff);
        string2 = string2 + "  Flags:                             " + String.format("0x%x\n", this.e_flags);
        string2 = string2 + "  Size of this header:               " + String.valueOf(this.e_ehsize) + " (bytes)\n";
        string2 = string2 + "  Size of program headers:           " + String.valueOf(this.e_phentsize) + " (bytes)\n";
        string2 = string2 + "  Number of program headers:         " + String.valueOf(this.e_phnum) + "\n";
        string2 = string2 + "  Size of section headers:           " + String.valueOf(this.e_shentsize) + " (bytes)\n";
        string2 = string2 + "  Number of sectioin headers:        " + String.valueOf(this.e_shnum) + "\n";
        string2 = string2 + "  Section header string table index: " + String.valueOf(this.e_shstrndx) + "\n";
        return string2 + "\n";
    }

    public String printProgramHeaders() {
        String string = "Program Headers:\n  Type           Offset   VirtAddr   PhysAddr   FileSiz MemSiz  Flg Align\n";
        for (int i = 0; i < this.e_phnum; ++i) {
            string = string + this.printProgramHeader(i);
        }
        return string + "\n";
    }

    public String printProgramHeader(int n) {
        String string = "  ";
        String string2 = "";
        string2 = string2 + ((this.p_flags[n] & 4) == 4 ? "R" : " ");
        string2 = string2 + ((this.p_flags[n] & 2) == 2 ? "W" : " ");
        string2 = string2 + ((this.p_flags[n] & 1) == 1 ? "E" : " ");
        String string3 = 0 <= this.p_type[n] && this.p_type[n] <= 7 ? pht_string[this.p_type[n]] : (0x70000000 <= this.p_type[n] && this.p_type[n] <= 0x70000002 ? pht_string[this.p_type[n] - 0x70000000 + 8] : String.format("0x%08x", this.p_type[n]));
        for (int i = 15 - string3.length(); i > 0; --i) {
            string3 = string3 + " ";
        }
        string = string + string3;
        string = string + String.format("0x%06x ", this.p_offset[n]);
        string = string + String.format("0x%08x ", this.p_vaddr[n]);
        string = string + String.format("0x%08x ", this.p_paddr[n]);
        string = string + String.format("0x%05x ", this.p_filesz[n]);
        string = string + String.format("0x%05x ", this.p_memsz[n]);
        string = string + string2 + " ";
        string = string + String.format("0x%x", this.p_align[n]);
        return string + "\n";
    }

    public String printSectionHeaders() {
        String string = "Section Headers:\n  [Nr] Name              Type            Addr     Off    Size   ES Flg Lk Inf Al\n";
        for (int i = 0; i < this.e_shnum; ++i) {
            string = string + this.printSectionHeader(i);
        }
        string = string + "Key to Flags:\n";
        string = string + "  W (write), A (alloc), X (execute), M (merge), S (strings)\n";
        string = string + "  I (info), L (link order), G (group), x (unknown)\n";
        string = string + "  O (extra OS processing required) o (OS specific), p (processor specific)\n";
        return string + "\n";
    }

    public String printSectionHeader(int n) {
        int n2;
        String string = "";
        string = string + ((this.sh_flags[n] & 1) == 1 ? "W" : "");
        string = string + ((this.sh_flags[n] & 2) == 2 ? "A" : "");
        string = string + ((this.sh_flags[n] & 4) == 4 ? "X" : "");
        string = string + ((this.sh_flags[n] & 8) == 8 ? "x" : "");
        string = string + ((this.sh_flags[n] & 0x10) == 16 ? "M" : "");
        string = string + ((this.sh_flags[n] & 0x20) == 32 ? "S" : "");
        string = string + ((this.sh_flags[n] & 0x40) == 64 ? "I" : "");
        string = string + ((this.sh_flags[n] & 0x80) == 128 ? "L" : "");
        string = string + ((this.sh_flags[n] & 0x100) == 256 ? "O" : "");
        string = string + ((this.sh_flags[n] & 0x200) == 512 ? "G" : "");
        string = string + ((this.sh_flags[n] & 0x400) == 1024 ? "T" : "");
        string = string + ((this.sh_flags[n] & 0x800) == 2048 ? "x" : "");
        string = string + ((this.sh_flags[n] & 0x1000) == 4096 ? "x" : "");
        string = string + ((this.sh_flags[n] & 0x2000) == 8192 ? "x" : "");
        string = string + ((this.sh_flags[n] & 0x4000) == 16384 ? "x" : "");
        string = string + ((this.sh_flags[n] & 0x8000) == 32768 ? "x" : "");
        string = string + ((this.sh_flags[n] & 0x10000) == 65536 ? "x" : "");
        string = string + ((this.sh_flags[n] & 0x20000) == 131072 ? "x" : "");
        string = string + ((this.sh_flags[n] & 0x40000) == 262144 ? "x" : "");
        string = string + ((this.sh_flags[n] & 0x80000) == 524288 ? "x" : "");
        if ((this.sh_flags[n] & 0x100000) == 0x100000 || (this.sh_flags[n] & 0x200000) == 0x200000 || (this.sh_flags[n] & 0x400000) == 0x400000 || (this.sh_flags[n] & 0x800000) == 0x800000 || (this.sh_flags[n] & 0x1000000) == 0x1000000 || (this.sh_flags[n] & 0x2000000) == 0x2000000 || (this.sh_flags[n] & 0x4000000) == 0x4000000 || (this.sh_flags[n] & 0x8000000) == 0x8000000) {
            string = string + "o";
        }
        if ((this.sh_flags[n] & 0x10000000) == 0x10000000 || (this.sh_flags[n] & 0x20000000) == 0x20000000 || (this.sh_flags[n] & 0x40000000) == 0x40000000 || (this.sh_flags[n] & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            string = string + "p";
        }
        for (int i = 3 - string.length(); i > 0; --i) {
            string = " " + string;
        }
        String string2 = "";
        int n3 = this.sh_offset[this.e_shstrndx] + this.sh_name[n];
        while ((n2 = (int)this.memory.read(n3, 1)[0]) != 0) {
            string2 = string2 + String.valueOf((char)n2);
            ++n3;
        }
        for (n3 = 17 - string2.length(); n3 > 0; --n3) {
            string2 = string2 + " ";
        }
        String string3 = 0 <= this.sh_type[n] && this.sh_type[n] <= sht_string.length ? sht_string[this.sh_type[n]] : (0x70000000 <= this.sh_type[n] && this.sh_type[n] <= 0x70000000 + sht_string_mips.length ? sht_string_mips[this.sh_type[n] - 0x70000000] : String.format("0x%08x", this.sh_type[n]));
        for (n2 = 15 - string3.length(); n2 > 0; --n2) {
            string3 = string3 + " ";
        }
        String string4 = "";
        string4 = string4 + String.format("  [%2d] ", n);
        string4 = string4 + string2 + " ";
        string4 = string4 + string3 + " ";
        string4 = string4 + String.format("%08x ", this.sh_addr[n]);
        string4 = string4 + String.format("%06x ", this.sh_offset[n]);
        string4 = string4 + String.format("%06x ", this.sh_size[n]);
        string4 = string4 + String.format("%02x ", this.sh_entsize[n]);
        string4 = string4 + string + " ";
        string4 = string4 + String.format("%2d ", this.sh_link[n]);
        string4 = string4 + String.format("%2d ", this.sh_info[n]);
        string4 = string4 + String.format("%2d ", this.sh_addralign[n]);
        return string4 + "\n";
    }

    public RandomAccessMemory getPhysicalMemory() {
        return this.memory;
    }

    public int[] getMapping() {
        int n = 0;
        for (int i = 0; i < this.sh_addr.length; ++i) {
            if (this.sh_addr[i] < 0x400000) continue;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n * 3];
        int n2 = 0;
        for (int i = 0; i < this.sh_addr.length; ++i) {
            if (this.sh_addr[i] < 0x400000) continue;
            nArray[n2 * 3] = this.sh_addr[i];
            nArray[n2 * 3 + 1] = this.sh_offset[i];
            nArray[n2 * 3 + 2] = this.sh_size[i];
            ++n2;
        }
        return nArray;
    }

    public int getEntryPoint() {
        return this.e_entry;
    }

    private int zeroExtend(byte[] byArray) {
        int n = 0;
        switch (byArray.length) {
            case 1: {
                n |= (byArray[0] & 0xFF) << 0;
                break;
            }
            case 2: {
                n |= (byArray[0] & 0xFF) << 8;
                n |= (byArray[1] & 0xFF) << 0;
                break;
            }
            case 4: {
                n |= (byArray[0] & 0xFF) << 24;
                n |= (byArray[1] & 0xFF) << 16;
                n |= (byArray[2] & 0xFF) << 8;
                n |= (byArray[3] & 0xFF) << 0;
            }
        }
        return n;
    }

    private int signExtend(byte[] byArray) {
        int n = (byArray[0] & 0x80) == 128 ? -1 : 0;
        switch (byArray.length) {
            case 1: {
                n &= 0xFFFFFF00;
                n |= (byArray[0] & 0xFF) << 0;
                break;
            }
            case 2: {
                n &= 0xFFFF0000;
                n |= (byArray[0] & 0xFF) << 8;
                n |= (byArray[1] & 0xFF) << 0;
                break;
            }
            case 4: {
                n &= 0;
                n |= (byArray[0] & 0xFF) << 24;
                n |= (byArray[1] & 0xFF) << 16;
                n |= (byArray[2] & 0xFF) << 8;
                n |= (byArray[3] & 0xFF) << 0;
            }
        }
        return n;
    }
}

