/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.mips;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.table.TableModel;
import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.ExecutableElementException;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.memory.InterruptDataPacket;
import net.wasamon.mics.memory.RandomAccessMemory;
import net.wasamon.mics.memory.RandomAccessMemoryDataPacket;
import net.wasamon.mics.processor.mips.ELFHeader;
import net.wasamon.mics.processor.mips.MipsCOP0;
import net.wasamon.mics.processor.mips.MipsFloatRegister;
import net.wasamon.mics.processor.mips.MipsIntRegister;
import net.wasamon.mics.processor.mips.MipsOperation;
import net.wasamon.mics.processor.mips.MipsProgramCounter;
import net.wasamon.mics.processor.mips.MipsRegister;
import net.wasamon.mics.processor.mips.MipsZeroWiredIntRegister;
import net.wasamon.mics.processor.mips.R3010;
import net.wasamon.mics.processor.mips.VirtualMemory;
import net.wasamon.mics.util.ChannelManager;
import net.wasamon.mics.util.MicsTableModel;
import net.wasamon.mics.util.MicsTablePanel;
import net.wasamon.mjlib.print.FormatException;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Node;

public class Mips
extends MicsElement
implements ExecutableElement,
ChannelConnectable,
DataBuffer,
MicsViewable {
    private static final int DELAYING_STATE = 0;
    private static final int DELAYSLOT_STATE = 1;
    private static final int NORMAL_STATE = 2;
    private static final int SIGNED = 0;
    private static final int UNSIGNED = 1;
    private static final int REGISTER_SIZE = 32;
    private static final int CODE_LENGTH = 4;
    private int delayState;
    private int delayPC;
    private MipsIntRegister[] register = new MipsIntRegister[32];
    private MipsIntRegister hiRegister;
    private MipsIntRegister loRegister;
    private MipsProgramCounter programCounter;
    private RandomAccessMemory memory;
    private int programOffset;
    private MipsRegister readRequestRegister;
    private int readRequestDataSign;
    private ArrayList<DelayLoadSet> delayLoadSetList;
    private boolean waitFlag;
    private MipsCOP0 cop0;
    private R3010 cop1;
    private ChannelManager channelManager;
    private VirtualMemory virtualMemory;
    private boolean started;
    MipsOperation op = null;
    MicsTablePanel table;

    public Mips() {
        this.register[0] = new MipsZeroWiredIntRegister();
        for (int i = 1; i < 32; ++i) {
            this.register[i] = new MipsIntRegister();
        }
        this.programCounter = new MipsProgramCounter();
        this.hiRegister = new MipsIntRegister();
        this.loRegister = new MipsIntRegister();
        this.delayLoadSetList = new ArrayList();
        this.cop0 = new MipsCOP0();
        this.cop1 = new R3010();
        this.delayState = 2;
        this.delayPC = 0;
        this.started = false;
    }

    private MipsIntRegister getRegister(int n) {
        return this.register[n];
    }

    private int zeroExtend(byte[] byArray) {
        int n = 0;
        switch (byArray.length) {
            case 1: {
                n |= (byArray[0] & 0xFF) << 0;
                break;
            }
            case 2: {
                n |= (byArray[0] & 0xFF) << 8;
                n |= (byArray[1] & 0xFF) << 0;
                break;
            }
            case 4: {
                n |= (byArray[0] & 0xFF) << 24;
                n |= (byArray[1] & 0xFF) << 16;
                n |= (byArray[2] & 0xFF) << 8;
                n |= (byArray[3] & 0xFF) << 0;
            }
        }
        return n;
    }

    private int signExtend(byte[] byArray) {
        int n = (byArray[0] & 0x80) == 128 ? -1 : 0;
        switch (byArray.length) {
            case 1: {
                n &= 0xFFFFFF00;
                n |= (byArray[0] & 0xFF) << 0;
                break;
            }
            case 2: {
                n &= 0xFFFF0000;
                n |= (byArray[0] & 0xFF) << 8;
                n |= (byArray[1] & 0xFF) << 0;
                break;
            }
            case 4: {
                n &= 0;
                n |= (byArray[0] & 0xFF) << 24;
                n |= (byArray[1] & 0xFF) << 16;
                n |= (byArray[2] & 0xFF) << 8;
                n |= (byArray[3] & 0xFF) << 0;
            }
        }
        return n;
    }

    public void initialize(String string, Node node) throws MicsException {
        this.channelManager = new ChannelManager(this.composite);
        try {
            int n;
            String string2;
            Node node2;
            int n2;
            Node node3 = node;
            int n3 = DataUtil.parseInt((String)XMLParser.getAttribute((Node)node3, (String)"memory").getNodeValue());
            this.memory = new RandomAccessMemory(n3);
            Node[] nodeArray = XMLParser.getNamedNodeArray((Node)node, (String)"channel");
            for (n2 = 0; n2 < nodeArray.length; ++n2) {
                node2 = nodeArray[n2];
                string2 = XMLParser.getAttribute((Node)node2, (String)"id").getNodeValue();
                n = DataUtil.parseInt((String)XMLParser.getAttribute((Node)node2, (String)"offset").getNodeValue());
                this.channelManager.add(string2, n);
            }
            nodeArray = XMLParser.getNamedNodeArray((Node)node, (String)"init");
            for (n2 = 0; n2 < nodeArray.length; ++n2) {
                node2 = nodeArray[n2];
                string2 = XMLParser.getAttribute((Node)node2, (String)"file").getNodeValue();
                if (string2.charAt(0) != '/') {
                    string2 = string + "/" + string2;
                }
                n = DataUtil.parseInt((String)XMLParser.getAttribute((Node)node2, (String)"offset").getNodeValue());
                try {
                    this.write(n, new BufferedInputStream(new FileInputStream(string2)));
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("no such file: " + string2);
                    System.out.println("[W] no data is written as initialize.");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.processor.Mips");
        }
        catch (XMLParserException xMLParserException) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.processor.Mips");
        }
    }

    public MicsDataPacket read(MicsDataPacket micsDataPacket) {
        return this.memory.read(micsDataPacket);
    }

    public void write(MicsDataPacket micsDataPacket) {
        this.memory.write(micsDataPacket);
    }

    public void write(int n, InputStream inputStream) throws DataBufferException {
        this.memory.write(n, inputStream);
        ELFHeader eLFHeader = new ELFHeader(this.memory);
        if (eLFHeader.isELFFormat()) {
            System.out.println("\n");
            System.out.println(eLFHeader.printELFHeader());
            System.out.println(eLFHeader.printProgramHeaders());
            System.out.println(eLFHeader.printSectionHeaders());
            this.virtualMemory = new VirtualMemory(eLFHeader);
            this.programCounter.setMemory(this.memory, this.virtualMemory);
            this.getRegister(29).setAsBits(0x400000 + this.memory.size() - 1);
            this.getRegister(31).setAsBits(this.virtualMemory.getEntryPoint());
        }
    }

    public void dump(int n, int n2, OutputStream outputStream) throws DataBufferException {
        this.memory.dump(n, n2, outputStream);
    }

    public int size() {
        return this.memory.size();
    }

    public String toString(int n, int n2) {
        return this.memory.toString(n, n2);
    }

    public void execWait() {
        this.waitFlag = true;
    }

    public void execRestart() {
        this.waitFlag = false;
    }

    public void reset() {
        this.waitFlag = false;
        for (int i = 0; i < 32; ++i) {
            this.register[i].reset();
        }
        this.programCounter.reset();
        this.hiRegister.reset();
        this.loRegister.reset();
        this.delayState = 2;
        this.delayPC = 0;
        this.started = false;
    }

    public ExecInfo exec_second() {
        return null;
    }

    public ExecInfo exec_first() throws ExecutableElementException {
        ExecInfo execInfo = new ExecInfo();
        execInfo.setCycle(1);
        execInfo.setTerminatableFlag(false);
        if (this.programCounter.getVirtualCounter() == this.virtualMemory.getEntryPoint()) {
            if (this.started) {
                execInfo.setTerminatableFlag(true);
                return execInfo;
            }
            this.started = true;
        }
        try {
            this.op = this.readProgram(this.programCounter);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ExecutableElementException("program address error");
        }
        catch (MicsException micsException) {
            execInfo.setTerminatableFlag(true);
            return execInfo;
        }
        if (this.waitFlag) {
            return execInfo;
        }
        switch (this.op.getInstruction()) {
            case 0: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister2 = this.getRegister(this.op.getZeroExtendedRT());
                MipsIntRegister mipsIntRegister3 = this.getRegister(this.op.getZeroExtendedRD());
                mipsIntRegister3.setAsBits(mipsIntRegister.getAsIntValue() + mipsIntRegister2.getAsIntValue());
                this.programCounter.add(4);
                break;
            }
            case 1: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister4 = this.getRegister(this.op.getZeroExtendedRT());
                mipsIntRegister4.setAsBits(mipsIntRegister.getAsIntValue() + this.op.getSignExtendedImmediate());
                this.programCounter.add(4);
                break;
            }
            case 2: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister5 = this.getRegister(this.op.getZeroExtendedRT());
                mipsIntRegister5.setAsBits(mipsIntRegister.getAsIntValue() + this.op.getSignExtendedImmediate());
                this.programCounter.add(4);
                break;
            }
            case 3: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister6 = this.getRegister(this.op.getZeroExtendedRT());
                MipsIntRegister mipsIntRegister7 = this.getRegister(this.op.getZeroExtendedRD());
                mipsIntRegister7.setAsBits(mipsIntRegister.getAsIntValue() + mipsIntRegister6.getAsIntValue());
                this.programCounter.add(4);
                break;
            }
            case 4: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister8 = this.getRegister(this.op.getZeroExtendedRT());
                MipsIntRegister mipsIntRegister9 = this.getRegister(this.op.getZeroExtendedRD());
                mipsIntRegister9.setAsBits(mipsIntRegister.getAsIntValue() & mipsIntRegister8.getAsIntValue());
                this.programCounter.add(4);
                break;
            }
            case 5: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister10 = this.getRegister(this.op.getZeroExtendedRT());
                mipsIntRegister10.setAsBits(mipsIntRegister.getAsIntValue() & this.op.getZeroExtendedImmediate());
                this.programCounter.add(4);
                break;
            }
            case 6: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                int n = this.op.getSignExtendedImmediate() << 2;
                int n2 = this.programCounter.getVirtualCounter() + 4;
                this.delayPC = n2 + n;
                this.delayState = 0;
                this.programCounter.add(4);
                break;
            }
            case 7: {
                int n = this.op.getSignExtendedImmediate() << 2;
                int n3 = this.programCounter.getVirtualCounter() + 4;
                if (this.cop1.getC() == 0) {
                    this.delayPC = n3 + n;
                    this.delayState = 0;
                }
                this.programCounter.add(4);
                break;
            }
            case 8: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                int n = this.op.getSignExtendedImmediate() << 2;
                int n4 = this.programCounter.getVirtualCounter() + 4;
                this.delayPC = n4 + n;
                this.delayState = 0;
                this.programCounter.add(4);
                break;
            }
            case 9: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                int n = this.op.getSignExtendedImmediate() << 2;
                int n5 = this.programCounter.getVirtualCounter() + 4;
                this.delayPC = n5 + n;
                this.delayState = 0;
                this.programCounter.add(4);
                break;
            }
            case 10: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                int n = this.op.getSignExtendedImmediate() << 2;
                int n6 = this.programCounter.getVirtualCounter() + 4;
                this.delayPC = n6 + n;
                this.delayState = 0;
                this.programCounter.add(4);
                break;
            }
            case 11: {
                int n = this.op.getSignExtendedImmediate() << 2;
                int n7 = this.programCounter.getVirtualCounter() + 4;
                if (this.cop1.getC() == 1) {
                    this.delayPC = n7 + n;
                    this.delayState = 0;
                }
                this.programCounter.add(4);
                break;
            }
            case 12: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                int n = this.op.getSignExtendedImmediate() << 2;
                int n8 = this.programCounter.getVirtualCounter() + 4;
                this.delayPC = n8 + n;
                this.delayState = 0;
                this.programCounter.add(4);
                break;
            }
            case 13: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                int n = this.op.getSignExtendedImmediate() << 2;
                int n9 = this.programCounter.getVirtualCounter() + 4;
                this.delayPC = n9 + n;
                this.delayState = 0;
                this.programCounter.add(4);
                break;
            }
            case 14: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister11 = this.getRegister(this.op.getZeroExtendedRT());
                if (mipsIntRegister.getAsIntValue() == mipsIntRegister11.getAsIntValue()) {
                    int n = this.op.getSignExtendedImmediate() << 2;
                    this.delayPC = this.programCounter.getVirtualCounter() + n + 4;
                    this.delayState = 0;
                }
                this.programCounter.add(4);
                break;
            }
            case 15: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                if ((mipsIntRegister.getAsIntValue() & Integer.MIN_VALUE) == 0) {
                    int n = this.op.getSignExtendedImmediate() << 2;
                    this.delayPC = this.programCounter.getVirtualCounter() + n + 4;
                    this.delayState = 0;
                }
                this.programCounter.add(4);
                break;
            }
            case 16: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister12 = this.getRegister(31);
                mipsIntRegister12.setAsBits(this.programCounter.getVirtualCounter() + 8);
                if ((mipsIntRegister.getAsIntValue() & Integer.MIN_VALUE) == 0) {
                    int n = this.op.getSignExtendedImmediate() << 2;
                    this.delayPC = this.programCounter.getVirtualCounter() + n + 4;
                    this.delayState = 0;
                }
                this.programCounter.add(4);
                break;
            }
            case 17: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                if ((mipsIntRegister.getAsIntValue() & Integer.MIN_VALUE) == 0 && mipsIntRegister.getAsIntValue() != 0) {
                    int n = this.op.getSignExtendedImmediate() << 2;
                    this.delayPC = this.programCounter.getVirtualCounter() + n + 4;
                    this.delayState = 0;
                }
                this.programCounter.add(4);
                break;
            }
            case 18: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                if ((mipsIntRegister.getAsIntValue() & Integer.MIN_VALUE) == Integer.MIN_VALUE || mipsIntRegister.getAsIntValue() == 0) {
                    int n = this.op.getSignExtendedImmediate() << 2;
                    this.delayPC = this.programCounter.getVirtualCounter() + n + 4;
                    this.delayState = 0;
                }
                this.programCounter.add(4);
                break;
            }
            case 19: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                if ((mipsIntRegister.getAsIntValue() & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                    int n = this.op.getSignExtendedImmediate() << 2;
                    this.delayPC = this.programCounter.getVirtualCounter() + n + 4;
                    this.delayState = 0;
                }
                this.programCounter.add(4);
                break;
            }
            case 20: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister13 = this.getRegister(31);
                mipsIntRegister13.setAsBits(this.programCounter.getVirtualCounter() + 8);
                if ((mipsIntRegister.getAsIntValue() & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                    int n = this.op.getSignExtendedImmediate() << 2;
                    this.delayPC = this.programCounter.getVirtualCounter() + n + 4;
                    this.delayState = 0;
                }
                this.programCounter.add(4);
                break;
            }
            case 21: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister14 = this.getRegister(this.op.getZeroExtendedRT());
                if (mipsIntRegister.getAsIntValue() != mipsIntRegister14.getAsIntValue()) {
                    int n = this.op.getSignExtendedImmediate() << 2;
                    this.delayPC = this.programCounter.getVirtualCounter() + n + 4;
                    this.delayState = 0;
                }
                this.programCounter.add(4);
                break;
            }
            case 22: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                this.programCounter.add(4);
                execInfo.setTerminatableFlag(true);
                return execInfo;
            }
            case 23: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                this.programCounter.add(4);
                break;
            }
            case 24: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRT());
                MipsIntRegister mipsIntRegister15 = this.cop1.getControlRegister(this.op.getZeroExtendedRD());
                if (mipsIntRegister15 == null) {
                    System.out.println("unkown COP1 control register");
                    execInfo.setTerminatableFlag(true);
                    return execInfo;
                }
                mipsIntRegister.setAsBits(mipsIntRegister15.getAsIntValue());
                this.programCounter.add(4);
                break;
            }
            case 25: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRT());
                this.programCounter.add(4);
                break;
            }
            case 26: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRT());
                this.programCounter.add(4);
                break;
            }
            case 27: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                this.programCounter.add(4);
                break;
            }
            case 28: {
                MipsIntRegister mipsIntRegister = this.cop1.getControlRegister(this.op.getZeroExtendedRD());
                if (mipsIntRegister == null) {
                    System.out.println("unkown COP1 control register");
                    execInfo.setTerminatableFlag(true);
                    return execInfo;
                }
                MipsIntRegister mipsIntRegister16 = this.getRegister(this.op.getZeroExtendedRT());
                mipsIntRegister.setAsBits(mipsIntRegister16.getAsIntValue());
                this.programCounter.add(4);
                break;
            }
            case 29: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRT());
                this.programCounter.add(4);
                break;
            }
            case 30: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRT());
                this.programCounter.add(4);
                break;
            }
            case 31: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister17 = this.getRegister(this.op.getZeroExtendedRT());
                this.hiRegister.setAsBits(mipsIntRegister.getAsIntValue() % mipsIntRegister17.getAsIntValue());
                this.loRegister.setAsBits(mipsIntRegister.getAsIntValue() / mipsIntRegister17.getAsIntValue());
                execInfo.setCycle(35);
                this.programCounter.add(4);
                break;
            }
            case 32: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister18 = this.getRegister(this.op.getZeroExtendedRT());
                long l = (long)mipsIntRegister.getAsIntValue() & 0xFFFFFFFFL;
                long l2 = (long)mipsIntRegister18.getAsIntValue() & 0xFFFFFFFFL;
                this.hiRegister.setAsBits((int)(l % l2));
                this.loRegister.setAsBits((int)(l / l2));
                execInfo.setCycle(35);
                this.programCounter.add(4);
                break;
            }
            case 33: {
                int n = this.op.getSignExtendedTarget() << 2;
                this.delayPC = this.programCounter.getVirtualCounter() + 4 & 0xF0000000 | n;
                this.delayState = 0;
                this.programCounter.add(4);
                break;
            }
            case 34: {
                MipsIntRegister mipsIntRegister = this.getRegister(31);
                mipsIntRegister.setAsBits(this.programCounter.getVirtualCounter() + 8);
                int n = this.op.getSignExtendedTarget() << 2;
                this.delayPC = this.programCounter.getVirtualCounter() + 4 & 0xF0000000 | n;
                this.delayState = 0;
                this.programCounter.add(4);
                break;
            }
            case 35: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister19 = this.getRegister(this.op.getZeroExtendedRD());
                mipsIntRegister19.setAsBits(this.programCounter.getVirtualCounter() + 8);
                this.delayPC = mipsIntRegister.getAsIntValue();
                this.delayState = 0;
                this.programCounter.add(4);
                break;
            }
            case 36: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                this.delayPC = mipsIntRegister.getAsIntValue();
                this.delayState = 0;
                this.programCounter.add(4);
                break;
            }
            case 37: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister20 = this.getRegister(this.op.getZeroExtendedRT());
                int n = mipsIntRegister.getAsIntValue() + this.op.getSignExtendedImmediate();
                this.loadData(mipsIntRegister20, n, 1, 0);
                this.programCounter.add(4);
                break;
            }
            case 38: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister21 = this.getRegister(this.op.getZeroExtendedRT());
                int n = mipsIntRegister.getAsIntValue() + this.op.getSignExtendedImmediate();
                this.loadData(mipsIntRegister21, n, 1, 1);
                this.programCounter.add(4);
                break;
            }
            case 39: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister22 = this.getRegister(this.op.getZeroExtendedRT());
                int n = mipsIntRegister.getAsIntValue() + this.op.getSignExtendedImmediate();
                this.loadData(mipsIntRegister22, n, 2, 0);
                this.programCounter.add(4);
                break;
            }
            case 40: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister23 = this.getRegister(this.op.getZeroExtendedRT());
                int n = mipsIntRegister.getAsIntValue() + this.op.getSignExtendedImmediate();
                this.loadData(mipsIntRegister23, n, 2, 1);
                this.programCounter.add(4);
                break;
            }
            case 41: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRT());
                mipsIntRegister.setAsBits(this.op.getZeroExtendedImmediate() << 16);
                this.programCounter.add(4);
                break;
            }
            case 42: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister24 = this.getRegister(this.op.getZeroExtendedRT());
                int n = mipsIntRegister.getAsIntValue() + this.op.getSignExtendedImmediate();
                this.loadData(mipsIntRegister24, n, 4, 0);
                this.programCounter.add(4);
                break;
            }
            case 43: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                this.programCounter.add(4);
                break;
            }
            case 44: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsFloatRegister mipsFloatRegister = this.cop1.getRegister(this.op.getZeroExtendedRT());
                int n = this.op.getSignExtendedImmediate() + mipsIntRegister.getAsIntValue();
                this.loadData(mipsFloatRegister, n, 4, 0);
                this.programCounter.add(4);
                break;
            }
            case 45: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                this.programCounter.add(4);
                break;
            }
            case 46: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                this.programCounter.add(4);
                break;
            }
            case 47: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister25 = this.getRegister(this.op.getZeroExtendedRT());
                int n = mipsIntRegister.getAsIntValue() + this.op.getSignExtendedImmediate();
                int n10 = this.virtualMemory.getPhysicalAddress(n);
                if (n10 == -1) {
                    System.out.println("address error exception or TLB exception");
                    execInfo.setTerminatableFlag(true);
                    return execInfo;
                }
                int n11 = mipsIntRegister25.getAsIntValue();
                switch (n10 & 3) {
                    case 0: {
                        mipsIntRegister25.setAsBits(n11 & 0 | this.zeroExtend(this.memory.read(n10, 4)) << 0);
                        break;
                    }
                    case 1: {
                        mipsIntRegister25.setAsBits(n11 & 0xFF | this.zeroExtend(this.memory.read(n10, 3)) << 8);
                        break;
                    }
                    case 2: {
                        mipsIntRegister25.setAsBits(n11 & 0xFFFF | this.zeroExtend(this.memory.read(n10, 2)) << 16);
                        break;
                    }
                    case 3: {
                        mipsIntRegister25.setAsBits(n11 & 0xFFFFFF | this.zeroExtend(this.memory.read(n10, 1)) << 24);
                    }
                }
                this.programCounter.add(4);
                break;
            }
            case 48: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister26 = this.getRegister(this.op.getZeroExtendedRT());
                int n = mipsIntRegister.getAsIntValue() + this.op.getSignExtendedImmediate();
                int n12 = this.virtualMemory.getPhysicalAddress(n);
                if (n12 == -1) {
                    System.out.println("address error exception or TLB exception");
                    execInfo.setTerminatableFlag(true);
                    return execInfo;
                }
                int n13 = mipsIntRegister26.getAsIntValue();
                switch (n12 & 3) {
                    case 0: {
                        mipsIntRegister26.setAsBits(n13 & 0xFFFFFF00 | this.zeroExtend(this.memory.read(n12, 1)));
                        break;
                    }
                    case 1: {
                        mipsIntRegister26.setAsBits(n13 & 0xFFFF0000 | this.zeroExtend(this.memory.read(n12 - 1, 2)));
                        break;
                    }
                    case 2: {
                        mipsIntRegister26.setAsBits(n13 & 0xFF000000 | this.zeroExtend(this.memory.read(n12 - 2, 3)));
                        break;
                    }
                    case 3: {
                        mipsIntRegister26.setAsBits(n13 & 0 | this.zeroExtend(this.memory.read(n12 - 3, 4)));
                    }
                }
                this.programCounter.add(4);
                break;
            }
            case 49: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRT());
                this.programCounter.add(4);
                break;
            }
            case 50: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRT());
                MipsFloatRegister mipsFloatRegister = this.cop1.getRegister(this.op.getZeroExtendedRD());
                mipsIntRegister.setAsBits(mipsFloatRegister.getAsIntValue());
                this.programCounter.add(4);
                break;
            }
            case 51: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRT());
                this.programCounter.add(4);
                break;
            }
            case 52: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRT());
                this.programCounter.add(4);
                break;
            }
            case 53: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRD());
                mipsIntRegister.setAsBits(this.hiRegister.getAsIntValue());
                this.programCounter.add(4);
                break;
            }
            case 54: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRD());
                mipsIntRegister.setAsBits(this.loRegister.getAsIntValue());
                this.programCounter.add(4);
                break;
            }
            case 55: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRT());
                this.programCounter.add(4);
                break;
            }
            case 56: {
                MipsFloatRegister mipsFloatRegister = this.cop1.getRegister(this.op.getZeroExtendedRD());
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRT());
                this.delayLoadSetList.add(new DelayLoadSet((MipsRegister)mipsFloatRegister, mipsIntRegister.getAsFloatValue()));
                this.programCounter.add(4);
                break;
            }
            case 57: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRT());
                this.programCounter.add(4);
                break;
            }
            case 58: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRT());
                this.programCounter.add(4);
                break;
            }
            case 59: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRD());
                this.hiRegister.setAsBits(mipsIntRegister.getAsIntValue());
                this.programCounter.add(4);
                break;
            }
            case 60: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRD());
                this.loRegister.setAsBits(mipsIntRegister.getAsIntValue());
                this.programCounter.add(4);
                break;
            }
            case 61: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister27 = this.getRegister(this.op.getZeroExtendedRT());
                long l = mipsIntRegister.getAsIntValue();
                long l3 = mipsIntRegister27.getAsIntValue();
                long l4 = l * l3;
                this.hiRegister.setAsBits((int)((l4 & 0xFFFFFFFF00000000L) >>> 32));
                this.loRegister.setAsBits((int)(l4 & 0xFFFFFFFFL));
                execInfo.setCycle(12);
                this.programCounter.add(4);
                break;
            }
            case 62: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister28 = this.getRegister(this.op.getZeroExtendedRT());
                long l = (long)mipsIntRegister.getAsIntValue() & 0xFFFFFFFFL;
                long l5 = (long)mipsIntRegister28.getAsIntValue() & 0xFFFFFFFFL;
                long l6 = l * l5;
                this.hiRegister.setAsBits((int)((l6 & 0xFFFFFFFF00000000L) >>> 32));
                this.loRegister.setAsBits((int)(l6 & 0xFFFFFFFFFFFFFFFFL));
                execInfo.setCycle(12);
                this.programCounter.add(4);
                break;
            }
            case 63: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister29 = this.getRegister(this.op.getZeroExtendedRT());
                MipsIntRegister mipsIntRegister30 = this.getRegister(this.op.getZeroExtendedRD());
                mipsIntRegister30.setAsBits(~(mipsIntRegister.getAsIntValue() | mipsIntRegister29.getAsIntValue()));
                this.programCounter.add(4);
                break;
            }
            case 64: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister31 = this.getRegister(this.op.getZeroExtendedRT());
                MipsIntRegister mipsIntRegister32 = this.getRegister(this.op.getZeroExtendedRD());
                mipsIntRegister32.setAsBits(mipsIntRegister.getAsIntValue() | mipsIntRegister31.getAsIntValue());
                this.programCounter.add(4);
                break;
            }
            case 65: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister33 = this.getRegister(this.op.getZeroExtendedRT());
                mipsIntRegister33.setAsBits(mipsIntRegister.getAsIntValue() | this.op.getZeroExtendedImmediate());
                this.programCounter.add(4);
                break;
            }
            case 66: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                this.programCounter.add(4);
                break;
            }
            case 67: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister34 = this.getRegister(this.op.getZeroExtendedRT());
                byte[] byArray = new byte[]{(byte)(mipsIntRegister34.getAsIntValue() & 0xFF)};
                int n = mipsIntRegister.getAsIntValue() + this.op.getSignExtendedImmediate();
                this.storeData(byArray, n, byArray.length);
                this.programCounter.add(4);
                break;
            }
            case 68: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister35 = this.getRegister(this.op.getZeroExtendedRT());
                byte[] byArray = new byte[]{(byte)((mipsIntRegister35.getAsIntValue() & 0xFF00) >>> 8), (byte)((mipsIntRegister35.getAsIntValue() & 0xFF) >>> 0)};
                int n = mipsIntRegister.getAsIntValue() + this.op.getSignExtendedImmediate();
                this.storeData(byArray, n, byArray.length);
                this.programCounter.add(4);
                break;
            }
            case 69: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRT());
                MipsIntRegister mipsIntRegister36 = this.getRegister(this.op.getZeroExtendedRD());
                mipsIntRegister36.setAsBits(mipsIntRegister.getAsIntValue() << this.op.getZeroExtendedShamt());
                this.programCounter.add(4);
                break;
            }
            case 70: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister37 = this.getRegister(this.op.getZeroExtendedRT());
                MipsIntRegister mipsIntRegister38 = this.getRegister(this.op.getZeroExtendedRD());
                mipsIntRegister38.setAsBits(mipsIntRegister37.getAsIntValue() << (mipsIntRegister.getAsIntValue() & 0x1F));
                this.programCounter.add(4);
                break;
            }
            case 71: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister39 = this.getRegister(this.op.getZeroExtendedRT());
                MipsIntRegister mipsIntRegister40 = this.getRegister(this.op.getZeroExtendedRD());
                mipsIntRegister40.setAsBits(mipsIntRegister.getAsIntValue() < mipsIntRegister39.getAsIntValue() ? 1 : 0);
                this.programCounter.add(4);
                break;
            }
            case 72: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister41 = this.getRegister(this.op.getZeroExtendedRT());
                mipsIntRegister41.setAsBits(mipsIntRegister.getAsIntValue() < this.op.getSignExtendedImmediate() ? 1 : 0);
                this.programCounter.add(4);
                break;
            }
            case 73: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister42 = this.getRegister(this.op.getZeroExtendedRT());
                long l = (long)mipsIntRegister.getAsIntValue() & 0xFFFFFFFFL;
                mipsIntRegister42.setAsBits(l < (long)this.op.getSignExtendedImmediate() ? 1 : 0);
                this.programCounter.add(4);
                break;
            }
            case 74: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister43 = this.getRegister(this.op.getZeroExtendedRT());
                MipsIntRegister mipsIntRegister44 = this.getRegister(this.op.getZeroExtendedRD());
                long l = (long)mipsIntRegister.getAsIntValue() & 0xFFFFFFFFL;
                long l7 = (long)mipsIntRegister43.getAsIntValue() & 0xFFFFFFFFL;
                mipsIntRegister44.setAsBits(l < l7 ? 1 : 0);
                this.programCounter.add(4);
                break;
            }
            case 75: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRT());
                MipsIntRegister mipsIntRegister45 = this.getRegister(this.op.getZeroExtendedRD());
                mipsIntRegister45.setAsBits(mipsIntRegister.getAsIntValue() >> this.op.getZeroExtendedShamt());
                this.programCounter.add(4);
                break;
            }
            case 76: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister46 = this.getRegister(this.op.getZeroExtendedRT());
                MipsIntRegister mipsIntRegister47 = this.getRegister(this.op.getZeroExtendedRD());
                mipsIntRegister47.setAsBits(mipsIntRegister46.getAsIntValue() >> (mipsIntRegister.getAsIntValue() & 0x1F));
                this.programCounter.add(4);
                break;
            }
            case 77: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRT());
                MipsIntRegister mipsIntRegister48 = this.getRegister(this.op.getZeroExtendedRD());
                mipsIntRegister48.setAsBits(mipsIntRegister.getAsIntValue() >>> this.op.getZeroExtendedShamt());
                this.programCounter.add(4);
                break;
            }
            case 78: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister49 = this.getRegister(this.op.getZeroExtendedRT());
                MipsIntRegister mipsIntRegister50 = this.getRegister(this.op.getZeroExtendedRD());
                mipsIntRegister50.setAsBits(mipsIntRegister49.getAsIntValue() >>> (mipsIntRegister.getAsIntValue() & 0x1F));
                this.programCounter.add(4);
                break;
            }
            case 79: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister51 = this.getRegister(this.op.getZeroExtendedRT());
                MipsIntRegister mipsIntRegister52 = this.getRegister(this.op.getZeroExtendedRD());
                mipsIntRegister52.setAsBits(mipsIntRegister.getAsIntValue() - mipsIntRegister51.getAsIntValue());
                this.programCounter.add(4);
                break;
            }
            case 80: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister53 = this.getRegister(this.op.getZeroExtendedRT());
                MipsIntRegister mipsIntRegister54 = this.getRegister(this.op.getZeroExtendedRD());
                mipsIntRegister54.setAsBits(mipsIntRegister.getAsIntValue() - mipsIntRegister53.getAsIntValue());
                this.programCounter.add(4);
                break;
            }
            case 81: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister55 = this.getRegister(this.op.getZeroExtendedRT());
                byte[] byArray = new byte[]{(byte)((mipsIntRegister55.getAsIntValue() & 0xFF000000) >>> 24), (byte)((mipsIntRegister55.getAsIntValue() & 0xFF0000) >>> 16), (byte)((mipsIntRegister55.getAsIntValue() & 0xFF00) >>> 8), (byte)((mipsIntRegister55.getAsIntValue() & 0xFF) >>> 0)};
                int n = mipsIntRegister.getAsIntValue() + this.op.getSignExtendedImmediate();
                this.storeData(byArray, n, byArray.length);
                this.programCounter.add(4);
                break;
            }
            case 82: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                this.programCounter.add(4);
                break;
            }
            case 83: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsFloatRegister mipsFloatRegister = this.cop1.getRegister(this.op.getZeroExtendedRT());
                byte[] byArray = new byte[4];
                int n = mipsFloatRegister.getAsIntValue();
                byArray[0] = (byte)((n & 0xFF000000) >>> 24);
                byArray[1] = (byte)((n & 0xFF0000) >>> 16);
                byArray[2] = (byte)((n & 0xFF00) >>> 8);
                byArray[3] = (byte)((n & 0xFF) >>> 0);
                int n14 = this.op.getSignExtendedImmediate() + mipsIntRegister.getAsIntValue();
                this.storeData(byArray, n14, byArray.length);
                this.programCounter.add(4);
                break;
            }
            case 84: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                this.programCounter.add(4);
                break;
            }
            case 85: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                this.programCounter.add(4);
                break;
            }
            case 86: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister56 = this.getRegister(this.op.getZeroExtendedRT());
                int n = mipsIntRegister.getAsIntValue() + this.op.getSignExtendedImmediate();
                int n15 = mipsIntRegister56.getAsIntValue();
                byte[] byArray = new byte[4 - (n & 3)];
                switch (n & 3) {
                    case 0: {
                        byArray[0] = (byte)((n15 & 0xFF000000) >>> 24);
                        byArray[1] = (byte)((n15 & 0xFF0000) >>> 16);
                        byArray[2] = (byte)((n15 & 0xFF00) >>> 8);
                        byArray[3] = (byte)((n15 & 0xFF) >>> 0);
                        this.storeData(byArray, n, byArray.length);
                        break;
                    }
                    case 1: {
                        byArray[0] = (byte)((n15 & 0xFF0000) >>> 16);
                        byArray[1] = (byte)((n15 & 0xFF00) >>> 8);
                        byArray[2] = (byte)((n15 & 0xFF) >>> 0);
                        this.storeData(byArray, n, byArray.length);
                        break;
                    }
                    case 2: {
                        byArray[0] = (byte)((n15 & 0xFF00) >>> 8);
                        byArray[1] = (byte)((n15 & 0xFF) >>> 0);
                        this.storeData(byArray, n, byArray.length);
                        break;
                    }
                    case 3: {
                        byArray[0] = (byte)((n15 & 0xFF) >>> 0);
                        this.storeData(byArray, n, byArray.length);
                    }
                }
                this.programCounter.add(4);
                break;
            }
            case 87: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister57 = this.getRegister(this.op.getZeroExtendedRT());
                int n = mipsIntRegister.getAsIntValue() + this.op.getSignExtendedImmediate();
                int n16 = mipsIntRegister57.getAsIntValue();
                byte[] byArray = new byte[1 + (n & 3)];
                switch (n & 3) {
                    case 0: {
                        byArray[0] = (byte)((n16 & 0xFF) >>> 0);
                        this.storeData(byArray, n, byArray.length);
                        break;
                    }
                    case 1: {
                        byArray[0] = (byte)((n16 & 0xFF00) >>> 8);
                        byArray[1] = (byte)((n16 & 0xFF) >>> 0);
                        this.storeData(byArray, n, byArray.length);
                        break;
                    }
                    case 2: {
                        byArray[0] = (byte)((n16 & 0xFF0000) >>> 16);
                        byArray[1] = (byte)((n16 & 0xFF00) >>> 8);
                        byArray[2] = (byte)((n16 & 0xFF) >>> 0);
                        this.storeData(byArray, n, byArray.length);
                        break;
                    }
                    case 3: {
                        byArray[0] = (byte)((n16 & 0xFF000000) >>> 24);
                        byArray[1] = (byte)((n16 & 0xFF0000) >>> 16);
                        byArray[2] = (byte)((n16 & 0xFF00) >>> 8);
                        byArray[3] = (byte)((n16 & 0xFF) >>> 0);
                        this.storeData(byArray, n, byArray.length);
                    }
                }
                this.programCounter.add(4);
                break;
            }
            case 88: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                this.programCounter.add(4);
                break;
            }
            case 89: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                this.programCounter.add(4);
                break;
            }
            case 90: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                this.programCounter.add(4);
                break;
            }
            case 91: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                this.programCounter.add(4);
                break;
            }
            case 92: {
                System.out.printf("incomplete instruction\n0x%08x:  %s\n", this.programCounter.getVirtualCounter());
                this.programCounter.add(4);
                break;
            }
            case 93: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister58 = this.getRegister(this.op.getZeroExtendedRT());
                MipsIntRegister mipsIntRegister59 = this.getRegister(this.op.getZeroExtendedRD());
                mipsIntRegister59.setAsBits(mipsIntRegister.getAsIntValue() ^ mipsIntRegister58.getAsIntValue());
                this.programCounter.add(4);
                break;
            }
            case 94: {
                MipsIntRegister mipsIntRegister = this.getRegister(this.op.getZeroExtendedRS());
                MipsIntRegister mipsIntRegister60 = this.getRegister(this.op.getZeroExtendedRT());
                mipsIntRegister60.setAsBits(mipsIntRegister.getAsIntValue() ^ this.op.getZeroExtendedImmediate());
                this.programCounter.add(4);
                break;
            }
            default: {
                this.cop1.exec(this.op);
                execInfo.setCycle(2);
                this.programCounter.add(4);
            }
        }
        switch (this.delayState) {
            case 2: {
                break;
            }
            case 0: {
                this.delayState = 1;
                break;
            }
            case 1: {
                this.delayState = 2;
                this.programCounter.setVirtualCounter(this.delayPC);
            }
        }
        this.delayLoad();
        return execInfo;
    }

    private boolean storeData(byte[] byArray, int n, int n2) throws ExecutableElementException {
        int n3 = this.virtualMemory.getPhysicalAddress(n);
        if (n3 == -1) {
            System.out.println("address error in storeData(data[], vaddr, length)");
            System.out.printf("0x%08x:  %s\n", this.programCounter.getVirtualCounter(), this.op);
            System.out.printf("vaddr = 0x%08x", n);
            return false;
        }
        if (n3 < this.memory.size()) {
            this.memory.write(n3, n2, byArray);
        } else {
            ChannelManager.Element element = this.channelManager.search(n3);
            try {
                element.getChannel().writeRequest((ChannelConnectable)this, RandomAccessMemoryDataPacket.writePacket(n3 - element.offset, n2, 8, byArray));
            }
            catch (MicsException micsException) {
                throw new ExecutableElementException((Throwable)micsException);
            }
        }
        return true;
    }

    private boolean loadData(MipsRegister mipsRegister, int n, int n2, int n3) throws ExecutableElementException {
        int n4 = this.virtualMemory.getPhysicalAddress(n);
        if (n4 == -1) {
            System.out.println("address error in loadData(dest, vaddr, length, sign)");
            System.out.printf("vaddr = 0x%08x", n);
            return false;
        }
        if (n4 < this.memory.size()) {
            this.delayLoadSetList.add(new DelayLoadSet(mipsRegister, n4, n2, n3));
        } else {
            this.readRequestRegister = mipsRegister;
            this.readRequestDataSign = n3;
            ChannelManager.Element element = this.channelManager.search(n4);
            try {
                element.getChannel().readRequest((ChannelConnectable)this, RandomAccessMemoryDataPacket.readPacket(n4 - element.offset, n2, 8));
            }
            catch (MicsException micsException) {
                throw new ExecutableElementException((Throwable)micsException);
            }
        }
        return true;
    }

    private void loadData(DelayLoadSet delayLoadSet) {
        switch (delayLoadSet.sign) {
            case 0: {
                delayLoadSet.dest.setAsBits(this.signExtend(this.memory.read(delayLoadSet.paddr, delayLoadSet.length)));
                break;
            }
            case 1: {
                delayLoadSet.dest.setAsBits(this.zeroExtend(this.memory.read(delayLoadSet.paddr, delayLoadSet.length)));
            }
        }
    }

    private MipsOperation readProgram(MipsProgramCounter mipsProgramCounter) throws MicsException {
        int n = mipsProgramCounter.getPhysicalCounter();
        if (n == -1) {
            String string = String.format("0x%08x", mipsProgramCounter.getVirtualCounter());
            String string2 = String.format("0x%08x", n);
            throw new MicsException("pc address error:vpc = " + string + " ppc = " + string2);
        }
        byte[] byArray = this.memory.read(n + this.programOffset, 4);
        int n2 = byArray[0] << 24 & 0xFF000000 | byArray[1] << 16 & 0xFF0000 | byArray[2] << 8 & 0xFF00 | byArray[3] & 0xFF;
        return new MipsOperation(n2);
    }

    public void writeback(MicsDataPacket micsDataPacket) {
        if (micsDataPacket instanceof RandomAccessMemoryDataPacket) {
            RandomAccessMemoryDataPacket randomAccessMemoryDataPacket = (RandomAccessMemoryDataPacket)micsDataPacket;
            switch (this.readRequestDataSign) {
                case 0: {
                    this.readRequestRegister.setAsBits(this.signExtend(randomAccessMemoryDataPacket.data));
                    break;
                }
                case 1: {
                    this.readRequestRegister.setAsBits(this.zeroExtend(randomAccessMemoryDataPacket.data));
                }
            }
        } else if (micsDataPacket instanceof InterruptDataPacket) {
            InterruptDataPacket interruptDataPacket = (InterruptDataPacket)micsDataPacket;
            try {
                this.storeData(interruptDataPacket.data, 0xA000002, interruptDataPacket.data.length);
            }
            catch (ExecutableElementException executableElementException) {
                // empty catch block
            }
        }
    }

    private void delayLoad() {
        if (this.delayLoadSetList.size() == 0) {
            return;
        }
        for (int i = this.delayLoadSetList.size() - 1; i >= 0; --i) {
            ++this.delayLoadSetList.get((int)i).counter;
        }
        DelayLoadSet delayLoadSet = this.delayLoadSetList.get(0);
        if (delayLoadSet.counter == 2) {
            if (delayLoadSet.type == 0) {
                this.loadData(delayLoadSet);
            } else if (delayLoadSet.type == 1) {
                delayLoadSet.dest.setAsBits(delayLoadSet.datai);
            } else {
                delayLoadSet.dest.setAsBits(delayLoadSet.dataf);
            }
            this.delayLoadSetList.remove(0);
        } else if (this.delayLoadSetList.get((int)0).counter > 2) {
            System.out.println("Delay Load Error !!!!!!!");
        }
    }

    public int getChannelOffset(Channel channel) {
        return this.channelManager.search(channel);
    }

    public String getInfo() {
        String string = "";
        string = string + "Mips\n";
        string = string + "  CLASS: " + ((Object)((Object)this)).getClass().getName() + "\n";
        string = string + "  ID: " + this.id() + "\n";
        string = string + "  Local Memory ID: " + this.memory.id() + ",";
        string = string + " offset = " + DataUtil.toBigEndianValueString((byte[])DataUtil.toByteArray((int)this.programOffset)) + "\n";
        ChannelManager.Element[] elementArray = this.channelManager.array();
        for (int i = 0; i < elementArray.length; ++i) {
            ChannelManager.Element element = elementArray[i];
            string = string + "  Channel ID: " + element.id + ",";
            string = string + " offset = " + element.offset + "\n";
        }
        return string;
    }

    public String toString() {
        try {
            int n;
            String string = "\n";
            try {
                string = string + this.programCounter + ":";
            }
            catch (FormatException formatException) {
                formatException.printStackTrace();
            }
            string = string + this.readProgram(this.programCounter).toString() + "\n";
            string = string + "=========================== R3000 Register ============================\n";
            for (n = 0; n < 32; ++n) {
                try {
                    string = string + this.register[n];
                    if (n % 8 == 7) {
                        string = string + "\n";
                        continue;
                    }
                    string = string + " ";
                    continue;
                }
                catch (FormatException formatException) {
                    // empty catch block
                }
            }
            string = string + this.hiRegister + " " + this.loRegister + "\n";
            string = string + "=========================== R3010 Register ============================\n";
            for (n = 0; n < 32; ++n) {
                try {
                    string = string + this.cop1.getRegister(n);
                    if (n % 8 == 7) {
                        string = string + "\n";
                        continue;
                    }
                    string = string + " ";
                    continue;
                }
                catch (FormatException formatException) {
                    // empty catch block
                }
            }
            string = string + this.cop1.getControlRegister(0) + " " + this.cop1.getControlRegister(31);
            return string;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return new String(this.programCounter.getVirtualCounter() + ": illegal program counter");
        }
        catch (MicsException micsException) {
            return new String(this.programCounter.getVirtualCounter() + ": illegal program counter");
        }
    }

    public String[] getConnectedElements() {
        return this.channelManager.getConnectedElements();
    }

    public void show() {
        if (this.table == null) {
            int n;
            MipsRegister[] mipsRegisterArray = new MipsRegister[35];
            MipsRegister[] mipsRegisterArray2 = new MipsRegister[35];
            String[] stringArray = new String[]{"$zero", "$at", "$v0", "$v1", "$a0", "$a1", "$a2", "$a3", "$t0", "$t1", "$t2", "$t3", "$t4", "$t5", "$t6", "$t7", "$s0", "$s1", "$s2", "$s3", "$s4", "$s5", "$s6", "$s7", "$t8", "$t9", "$k0", "$k1", "$gp", "$sp", "$fp", "$ra", "$hi", "$lo", "$pc"};
            String[] stringArray2 = new String[stringArray.length];
            for (n = 0; n < 32; ++n) {
                stringArray[n] = String.format("$%d(", n) + stringArray[n] + ")";
                mipsRegisterArray[n] = this.register[n];
            }
            for (n = 0; n < stringArray2.length - 3; ++n) {
                stringArray2[n] = String.format("$f%d", n);
                mipsRegisterArray2[n] = this.cop1.getRegister(n);
            }
            stringArray2[32] = "fcr0";
            stringArray2[33] = "fcr31";
            stringArray2[34] = "";
            mipsRegisterArray2[32] = this.cop1.getControlRegister(0);
            mipsRegisterArray2[33] = this.cop1.getControlRegister(31);
            mipsRegisterArray2[34] = null;
            mipsRegisterArray[32] = this.hiRegister;
            mipsRegisterArray[33] = this.loRegister;
            mipsRegisterArray[34] = this.programCounter;
            this.table = new MicsTablePanel("Mips Register", (TableModel)new MicsTableModel(new String[]{"R3000 Register", "value", "R3010 Register", "value"}, (Object[][])new Object[][]{stringArray, mipsRegisterArray, stringArray2, mipsRegisterArray2}));
        }
        this.table.setVisible(true);
    }

    public String getImagePath() {
        return "combo_processor.png";
    }

    class DelayLoadSet {
        MipsRegister dest;
        int paddr;
        int length;
        int sign;
        int counter;
        int type;
        int datai;
        float dataf;

        DelayLoadSet(MipsRegister mipsRegister, int n, int n2, int n3) {
            this.dest = mipsRegister;
            this.paddr = n;
            this.length = n2;
            this.sign = n3;
            this.counter = 0;
        }

        DelayLoadSet(MipsRegister mipsRegister, int n) {
            this.dest = mipsRegister;
            this.datai = n;
            this.type = 1;
        }

        DelayLoadSet(MipsRegister mipsRegister, float f) {
            this.dest = mipsRegister;
            this.dataf = f;
            this.type = 2;
        }
    }
}

