/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.mips;

import net.wasamon.mics.processor.mips.MipsIntRegister;

public class MipsCOP0 {
    public static final int KUSEG_MODE = 0;
    public static final int KSEG0_MODE = 1;
    public static final int KSEG1_MODE = 2;
    public static final int KSEG2_MODE = 3;
    private MipsIntRegister entryHiRegister = new MipsIntRegister();
    private MipsIntRegister entryLoRegister = new MipsIntRegister();
    private MipsIntRegister indexRegister = new MipsIntRegister();
    private MipsIntRegister randomRegister = new MipsIntRegister();
    private MipsIntRegister statusRegister = new MipsIntRegister();
    private MipsIntRegister contextRegister = new MipsIntRegister();
    private MipsIntRegister badVirtualAddressRegister = new MipsIntRegister();
    private MipsIntRegister pridRegister = new MipsIntRegister();
    private MipsIntRegister causeRegister = new MipsIntRegister();
    private MipsIntRegister epcRegister = new MipsIntRegister();

    public int convertToPhysicalAddress(int n) {
        if ((n & Integer.MIN_VALUE) == 0) {
            int n2 = this.getVPN(n);
            int n3 = this.entry_PID();
            if (this.entry_VPN() == n2 && this.entry_G() == 1 && this.entry_V() == 1 && this.entry_D() == 1 && this.entry_N() == 0) {
                return this.entry_PFN() << 12 | this.getOffset(n);
            }
            return -1;
        }
        return -1;
    }

    public int getVPN(int n) {
        return (n & 0xFFFFF000) >>> 12;
    }

    private int getOffset(int n) {
        return n & 0xFFF;
    }

    private int entry_VPN() {
        return (this.entryHiRegister.getAsIntValue() & 0xFFFFF000) >>> 12;
    }

    private int entry_PID() {
        return (this.entryHiRegister.getAsIntValue() & 0xFC0) >>> 6;
    }

    private int entry_PFN() {
        return (this.entryLoRegister.getAsIntValue() & 0xFFFFF000) >>> 12;
    }

    private int entry_N() {
        return (this.entryLoRegister.getAsIntValue() & 0x800) >>> 11;
    }

    private int entry_D() {
        return (this.entryLoRegister.getAsIntValue() & 0x400) >>> 10;
    }

    private int entry_V() {
        return (this.entryLoRegister.getAsIntValue() & 0x200) >>> 9;
    }

    private int entry_G() {
        return (this.entryLoRegister.getAsIntValue() & 0x100) >>> 8;
    }

    private int index_P() {
        return (this.indexRegister.getAsIntValue() & Integer.MIN_VALUE) >>> 31;
    }

    private int index_Index() {
        return (this.indexRegister.getAsIntValue() & 0x3F00) >>> 8;
    }

    private int random_Random() {
        return (this.randomRegister.getAsIntValue() & 0x3F00) >>> 8;
    }

    private int cause_BD() {
        return (this.causeRegister.getAsIntValue() & Integer.MIN_VALUE) >>> 31;
    }

    private int cause_CE() {
        return (this.causeRegister.getAsIntValue() & 0x30000000) >>> 28;
    }

    private int cause_IP() {
        return (this.causeRegister.getAsIntValue() & 0xFC00) >>> 10;
    }

    private int cause_Sw() {
        return (this.causeRegister.getAsIntValue() & 0x300) >>> 8;
    }

    private int cause_ExcCode() {
        return (this.causeRegister.getAsIntValue() & 0x3C) >>> 2;
    }

    private int epc_EPC() {
        return this.epcRegister.getAsIntValue();
    }

    private int status_CU() {
        return (this.statusRegister.getAsIntValue() & 0xF0000000) >>> 28;
    }

    private int status_BEV() {
        return (this.statusRegister.getAsIntValue() & 0x400000) >>> 22;
    }

    private int status_TS() {
        return (this.statusRegister.getAsIntValue() & 0x200000) >>> 21;
    }

    private int status_PE() {
        return (this.statusRegister.getAsIntValue() & 0x100000) >>> 20;
    }

    private int status_CM() {
        return (this.statusRegister.getAsIntValue() & 0x80000) >>> 19;
    }

    private int status_PZ() {
        return (this.statusRegister.getAsIntValue() & 0x40000) >>> 18;
    }

    private int status_SwC() {
        return (this.statusRegister.getAsIntValue() & 0x20000) >>> 17;
    }

    private int status_IsC() {
        return (this.statusRegister.getAsIntValue() & 0x10000) >>> 16;
    }

    private int status_IntMask() {
        return (this.statusRegister.getAsIntValue() & 0xFF00) >>> 8;
    }

    private int status_KUo() {
        return (this.statusRegister.getAsIntValue() & 0x20) >>> 5;
    }

    private int status_IEo() {
        return (this.statusRegister.getAsIntValue() & 0x10) >>> 4;
    }

    private int status_KUp() {
        return (this.statusRegister.getAsIntValue() & 8) >>> 3;
    }

    private int status_IEp() {
        return (this.statusRegister.getAsIntValue() & 4) >>> 2;
    }

    private int status_KUc() {
        return (this.statusRegister.getAsIntValue() & 2) >>> 1;
    }

    private int status_IEc() {
        return this.statusRegister.getAsIntValue() & 1;
    }

    private int badVirtualAddress_BadVAddr() {
        return this.badVirtualAddressRegister.getAsIntValue();
    }

    private int context_PTEBase() {
        return (this.contextRegister.getAsIntValue() & 0xFFE00000) >>> 21;
    }

    private int context_BadVPN() {
        return (this.contextRegister.getAsIntValue() & 0x1FFFFC) >>> 2;
    }

    private int prid_Imp() {
        return (this.pridRegister.getAsIntValue() & 0xFF00) >>> 8;
    }

    private int prid_Rev() {
        return this.pridRegister.getAsIntValue() & 0xFF;
    }
}

