/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.mips;

public class MipsOperation {
    public static final int OP_SPECIAL = 0;
    public static final int OP_BCOND = 1;
    public static final int OP_J = 2;
    public static final int OP_JAL = 3;
    public static final int OP_BEQ = 4;
    public static final int OP_BNE = 5;
    public static final int OP_BLEZ = 6;
    public static final int OP_BGTZ = 7;
    public static final int OP_ADDI = 8;
    public static final int OP_ADDIU = 9;
    public static final int OP_SLTI = 10;
    public static final int OP_SLTIU = 11;
    public static final int OP_ANDI = 12;
    public static final int OP_ORI = 13;
    public static final int OP_XORI = 14;
    public static final int OP_LUI = 15;
    public static final int OP_COP0 = 16;
    public static final int OP_COP1 = 17;
    public static final int OP_COP2 = 18;
    public static final int OP_COP3 = 19;
    public static final int OP_LB = 32;
    public static final int OP_LH = 33;
    public static final int OP_LWL = 34;
    public static final int OP_LW = 35;
    public static final int OP_LBU = 36;
    public static final int OP_LHU = 37;
    public static final int OP_LWR = 38;
    public static final int OP_SB = 40;
    public static final int OP_SH = 41;
    public static final int OP_SWL = 42;
    public static final int OP_SW = 43;
    public static final int OP_SWR = 46;
    public static final int OP_LWC0 = 48;
    public static final int OP_LWC1 = 49;
    public static final int OP_LWC2 = 50;
    public static final int OP_LWC3 = 51;
    public static final int OP_SWC0 = 56;
    public static final int OP_SWC1 = 57;
    public static final int OP_SWC2 = 58;
    public static final int OP_SWC3 = 59;
    public static final int FMT_S = 0;
    public static final int FMT_D = 1;
    public static final int FMT_W = 4;
    public static final int SPECIAL_FUNCT_SLL = 0;
    public static final int SPECIAL_FUNCT_SRL = 2;
    public static final int SPECIAL_FUNCT_SRA = 3;
    public static final int SPECIAL_FUNCT_SLLV = 4;
    public static final int SPECIAL_FUNCT_SRLV = 6;
    public static final int SPECIAL_FUNCT_SRAV = 7;
    public static final int SPECIAL_FUNCT_JR = 8;
    public static final int SPECIAL_FUNCT_JALR = 9;
    public static final int SPECIAL_FUNCT_SYSCALL = 12;
    public static final int SPECIAL_FUNCT_BREAK = 13;
    public static final int SPECIAL_FUNCT_MFHI = 16;
    public static final int SPECIAL_FUNCT_MTHI = 17;
    public static final int SPECIAL_FUNCT_MFLO = 18;
    public static final int SPECIAL_FUNCT_MTLO = 19;
    public static final int SPECIAL_FUNCT_MULT = 24;
    public static final int SPECIAL_FUNCT_MULTU = 25;
    public static final int SPECIAL_FUNCT_DIV = 26;
    public static final int SPECIAL_FUNCT_DIVU = 27;
    public static final int SPECIAL_FUNCT_ADD = 32;
    public static final int SPECIAL_FUNCT_ADDU = 33;
    public static final int SPECIAL_FUNCT_SUB = 34;
    public static final int SPECIAL_FUNCT_SUBU = 35;
    public static final int SPECIAL_FUNCT_AND = 36;
    public static final int SPECIAL_FUNCT_OR = 37;
    public static final int SPECIAL_FUNCT_XOR = 38;
    public static final int SPECIAL_FUNCT_NOR = 39;
    public static final int SPECIAL_FUNCT_SLT = 42;
    public static final int SPECIAL_FUNCT_SLTU = 43;
    public static final int COND_BLTZ = 0;
    public static final int COND_BGEZ = 1;
    public static final int COND_BLTZAL = 16;
    public static final int COND_BGEZAL = 17;
    public static final int COPZ_RS_MF = 0;
    public static final int COPZ_RS_CF = 2;
    public static final int COPZ_RS_MT = 4;
    public static final int COPZ_RS_CT = 6;
    public static final int COPZ_RS_BC = 8;
    public static final int COPZ_RS_MSB_CO = 1;
    public static final int COPZ_RT_BCF = 0;
    public static final int COPZ_RT_BCT = 1;
    public static final int COP0_FUNCT_TLBR = 1;
    public static final int COP0_FUNCT_TLBWI = 2;
    public static final int COP0_FUNCT_TLBWR = 6;
    public static final int COP0_FUNCT_TLBP = 8;
    public static final int COP0_FUNCT_RFE = 16;
    public static final int COP1_FUNCT_ADD_FMT = 0;
    public static final int COP1_FUNCT_SUB_FMT = 1;
    public static final int COP1_FUNCT_MUL_FMT = 2;
    public static final int COP1_FUNCT_DIV_FMT = 3;
    public static final int COP1_FUNCT_ABS_FMT = 5;
    public static final int COP1_FUNCT_MOV_FMT = 6;
    public static final int COP1_FUNCT_NEG_FMT = 7;
    public static final int COP1_FUNCT_CVT_S = 32;
    public static final int COP1_FUNCT_CVT_D = 33;
    public static final int COP1_FUNCT_CVT_W = 36;
    public static final int COP1_FUNCT_C_F = 48;
    public static final int COP1_FUNCT_C_UN = 49;
    public static final int COP1_FUNCT_C_EQ = 50;
    public static final int COP1_FUNCT_C_UEQ = 51;
    public static final int COP1_FUNCT_C_OLT = 52;
    public static final int COP1_FUNCT_C_ULT = 53;
    public static final int COP1_FUNCT_C_OLE = 54;
    public static final int COP1_FUNCT_C_ULE = 55;
    public static final int COP1_FUNCT_C_SF = 56;
    public static final int COP1_FUNCT_C_NGLE = 57;
    public static final int COP1_FUNCT_C_SEQ = 58;
    public static final int COP1_FUNCT_C_NGL = 59;
    public static final int COP1_FUNCT_C_LT = 60;
    public static final int COP1_FUNCT_C_NGE = 61;
    public static final int COP1_FUNCT_C_LE = 62;
    public static final int COP1_FUNCT_C_NGT = 63;
    public static final int INST_ADD = 0;
    public static final int INST_ADDI = 1;
    public static final int INST_ADDIU = 2;
    public static final int INST_ADDU = 3;
    public static final int INST_AND = 4;
    public static final int INST_ANDI = 5;
    public static final int INST_BC0F = 6;
    public static final int INST_BC1F = 7;
    public static final int INST_BC2F = 8;
    public static final int INST_BC3F = 9;
    public static final int INST_BC0T = 10;
    public static final int INST_BC1T = 11;
    public static final int INST_BC2T = 12;
    public static final int INST_BC3T = 13;
    public static final int INST_BEQ = 14;
    public static final int INST_BGEZ = 15;
    public static final int INST_BGEZAL = 16;
    public static final int INST_BGTZ = 17;
    public static final int INST_BLEZ = 18;
    public static final int INST_BLTZ = 19;
    public static final int INST_BLTZAL = 20;
    public static final int INST_BNE = 21;
    public static final int INST_BREAK = 22;
    public static final int INST_CFC0 = 23;
    public static final int INST_CFC1 = 24;
    public static final int INST_CFC2 = 25;
    public static final int INST_CFC3 = 26;
    public static final int INST_CTC0 = 27;
    public static final int INST_CTC1 = 28;
    public static final int INST_CTC2 = 29;
    public static final int INST_CTC3 = 30;
    public static final int INST_DIV = 31;
    public static final int INST_DIVU = 32;
    public static final int INST_J = 33;
    public static final int INST_JAL = 34;
    public static final int INST_JALR = 35;
    public static final int INST_JR = 36;
    public static final int INST_LB = 37;
    public static final int INST_LBU = 38;
    public static final int INST_LH = 39;
    public static final int INST_LHU = 40;
    public static final int INST_LUI = 41;
    public static final int INST_LW = 42;
    public static final int INST_LWC0 = 43;
    public static final int INST_LWC1 = 44;
    public static final int INST_LWC2 = 45;
    public static final int INST_LWC3 = 46;
    public static final int INST_LWL = 47;
    public static final int INST_LWR = 48;
    public static final int INST_MFC0 = 49;
    public static final int INST_MFC1 = 50;
    public static final int INST_MFC2 = 51;
    public static final int INST_MFC3 = 52;
    public static final int INST_MFHI = 53;
    public static final int INST_MFLO = 54;
    public static final int INST_MTC0 = 55;
    public static final int INST_MTC1 = 56;
    public static final int INST_MTC2 = 57;
    public static final int INST_MTC3 = 58;
    public static final int INST_MTHI = 59;
    public static final int INST_MTLO = 60;
    public static final int INST_MULT = 61;
    public static final int INST_MULTU = 62;
    public static final int INST_NOR = 63;
    public static final int INST_OR = 64;
    public static final int INST_ORI = 65;
    public static final int INST_RFE = 66;
    public static final int INST_SB = 67;
    public static final int INST_SH = 68;
    public static final int INST_SLL = 69;
    public static final int INST_SLLV = 70;
    public static final int INST_SLT = 71;
    public static final int INST_SLTI = 72;
    public static final int INST_SLTIU = 73;
    public static final int INST_SLTU = 74;
    public static final int INST_SRA = 75;
    public static final int INST_SRAV = 76;
    public static final int INST_SRL = 77;
    public static final int INST_SRLV = 78;
    public static final int INST_SUB = 79;
    public static final int INST_SUBU = 80;
    public static final int INST_SW = 81;
    public static final int INST_SWC0 = 82;
    public static final int INST_SWC1 = 83;
    public static final int INST_SWC2 = 84;
    public static final int INST_SWC3 = 85;
    public static final int INST_SWL = 86;
    public static final int INST_SWR = 87;
    public static final int INST_SYSCALL = 88;
    public static final int INST_TLBP = 89;
    public static final int INST_TLBR = 90;
    public static final int INST_TLBWI = 91;
    public static final int INST_TLBWR = 92;
    public static final int INST_XOR = 93;
    public static final int INST_XORI = 94;
    public static final int INST_ABS_S = 95;
    public static final int INST_ABS_D = 96;
    public static final int INST_ADD_S = 97;
    public static final int INST_ADD_D = 98;
    public static final int INST_C_F_S = 99;
    public static final int INST_C_F_D = 100;
    public static final int INST_C_UN_S = 101;
    public static final int INST_C_UN_D = 102;
    public static final int INST_C_EQ_S = 103;
    public static final int INST_C_EQ_D = 104;
    public static final int INST_C_UEQ_S = 105;
    public static final int INST_C_UEQ_D = 106;
    public static final int INST_C_OLT_S = 107;
    public static final int INST_C_OLT_D = 108;
    public static final int INST_C_ULT_S = 109;
    public static final int INST_C_ULT_D = 110;
    public static final int INST_C_OLE_S = 111;
    public static final int INST_C_OLE_D = 112;
    public static final int INST_C_ULE_S = 113;
    public static final int INST_C_ULE_D = 114;
    public static final int INST_C_SF_S = 115;
    public static final int INST_C_SF_D = 116;
    public static final int INST_C_NGLE_S = 117;
    public static final int INST_C_NGLE_D = 118;
    public static final int INST_C_SEQ_S = 119;
    public static final int INST_C_SEQ_D = 120;
    public static final int INST_C_NGL_S = 121;
    public static final int INST_C_NGL_D = 122;
    public static final int INST_C_LT_S = 123;
    public static final int INST_C_LT_D = 124;
    public static final int INST_C_NGE_S = 125;
    public static final int INST_C_NGE_D = 126;
    public static final int INST_C_LE_S = 127;
    public static final int INST_C_LE_D = 128;
    public static final int INST_C_NGT_S = 129;
    public static final int INST_C_NGT_D = 130;
    public static final int INST_CVT_D_S = 131;
    public static final int INST_CVT_D_W = 132;
    public static final int INST_CVT_S_D = 133;
    public static final int INST_CVT_S_W = 134;
    public static final int INST_CVT_W_S = 135;
    public static final int INST_CVT_W_D = 136;
    public static final int INST_DIV_S = 137;
    public static final int INST_DIV_D = 138;
    public static final int INST_MOV_S = 139;
    public static final int INST_MOV_D = 140;
    public static final int INST_MUL_S = 141;
    public static final int INST_MUL_D = 142;
    public static final int INST_NEG_S = 143;
    public static final int INST_NEG_D = 144;
    public static final int INST_SUB_S = 145;
    public static final int INST_SUB_D = 146;
    private static final String[] instruction = new String[]{"add", "addi", "addiu", "addu", "and", "andi", "bc0f", "bc1f", "bc2f", "bc3f", "bc0t", "bc1t", "bc2t", "bc3t", "beq", "bgez", "bgezal", "bgtz", "blez", "bltz", "bltzal", "bne", "break", "cfc0", "cfc1", "cfc2", "cfc3", "ctc0", "ctc1", "ctc2", "ctc3", "div", "divu", "j", "jal", "jalr", "jr", "lb", "lbu", "lh", "lhu", "lui", "lw", "lwc0", "lwc1", "lwc2", "lwc3", "lwl", "lwr", "mfc0", "mfc1", "mfc2", "mfc3", "mfhi", "mflo", "mtc0", "mtc1", "mtc2", "mtc3", "mthi", "mtl0", "mult", "multu", "nor", "or", "ori", "rfe", "sb", "sh", "sll", "sllv", "slt", "slti", "sltiu", "sltu", "sra", "srav", "srl", "srlv", "sub", "subu", "sw", "swc0", "swc1", "swc2", "swc3", "swl", "swr", "syscall", "tlbp", "tlbr", "tlbwi", "tlbwr", "xor", "xori", "abs.s", "abs.d", "add.s", "add.d", "c.f.s", "c.f.d", "c.un.s", "c.un.d", "c.eq.s", "c.eq.d", "c.ueq.s", "c.ueq.d", "c.olt.s", "c.olt.d", "c.ult.s", "c.ult.d", "c.ole.s", "c.ole.d", "c.ule.s", "c.ule.d", "c.sf.s", "c.sf.d", "c.ngle.s", "c.ngle.d", "c.seq.s", "c.seq.d", "c.ngl.s", "c.ngl.d", "c.lt.s", "c.lt.d", "c.nge.s", "c.nge.d", "c.le.s", "c.le.d", "c.ngt.s", "c.ngt.d", "cvt.d.s", "cvt.d.w", "cvt.s.d", "cvt.s.w", "cvt.w.s", "cvt.w.d", "div.s", "div.d", "mov.s", "mov.d", "mul.s", "mul.d", "neg.s", "neg.d", "sub.s", "sub.d"};
    private static final int I_TYPE_3000 = 0;
    private static final int J_TYPE_3000 = 1;
    private static final int R_TYPE_3000 = 2;
    private static final int I_TYPE_3010 = 3;
    private static final int M_TYPE_3010 = 4;
    private static final int R_TYPE_3010 = 5;
    private static final int GPR = 0;
    private static final int FGR = 1;
    private static final int FPR = 2;
    private int operation;
    private int inst;
    private int type;

    MipsOperation(int n) {
        this.operation = n;
        this.decode();
    }

    private void decode() {
        int n = this.getZeroExtendedOP();
        block0 : switch (n) {
            case 0: {
                int n2 = this.getZeroExtendedFunct();
                this.type = 2;
                switch (n2) {
                    case 0: {
                        this.inst = 69;
                        break block0;
                    }
                    case 2: {
                        this.inst = 77;
                        break block0;
                    }
                    case 3: {
                        this.inst = 75;
                        break block0;
                    }
                    case 4: {
                        this.inst = 70;
                        break block0;
                    }
                    case 6: {
                        this.inst = 78;
                        break block0;
                    }
                    case 7: {
                        this.inst = 76;
                        break block0;
                    }
                    case 8: {
                        this.inst = 36;
                        break block0;
                    }
                    case 9: {
                        this.inst = 35;
                        break block0;
                    }
                    case 12: {
                        this.inst = 88;
                        break block0;
                    }
                    case 13: {
                        this.inst = 22;
                        break block0;
                    }
                    case 16: {
                        this.inst = 53;
                        break block0;
                    }
                    case 17: {
                        this.inst = 59;
                        break block0;
                    }
                    case 18: {
                        this.inst = 54;
                        break block0;
                    }
                    case 19: {
                        this.inst = 60;
                        break block0;
                    }
                    case 24: {
                        this.inst = 61;
                        break block0;
                    }
                    case 25: {
                        this.inst = 62;
                        break block0;
                    }
                    case 26: {
                        this.inst = 31;
                        break block0;
                    }
                    case 27: {
                        this.inst = 32;
                        break block0;
                    }
                    case 32: {
                        this.inst = 0;
                        break block0;
                    }
                    case 33: {
                        this.inst = 3;
                        break block0;
                    }
                    case 34: {
                        this.inst = 79;
                        break block0;
                    }
                    case 35: {
                        this.inst = 80;
                        break block0;
                    }
                    case 36: {
                        this.inst = 4;
                        break block0;
                    }
                    case 37: {
                        this.inst = 64;
                        break block0;
                    }
                    case 38: {
                        this.inst = 93;
                        break block0;
                    }
                    case 39: {
                        this.inst = 63;
                        break block0;
                    }
                    case 42: {
                        this.inst = 71;
                        break block0;
                    }
                    case 43: {
                        this.inst = 74;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                int n3 = this.getZeroExtendedRT();
                this.type = 0;
                switch (n3) {
                    case 0: {
                        this.inst = 19;
                        break block0;
                    }
                    case 1: {
                        this.inst = 15;
                        break block0;
                    }
                    case 16: {
                        this.inst = 20;
                        break block0;
                    }
                    case 17: {
                        this.inst = 16;
                        break block0;
                    }
                }
                this.inst = -1;
                break;
            }
            case 16: {
                int n4 = this.getZeroExtendedFunct();
                this.type = 2;
                switch (n4) {
                    case 1: {
                        this.inst = 90;
                        break block0;
                    }
                    case 2: {
                        this.inst = 91;
                        break block0;
                    }
                    case 6: {
                        this.inst = 92;
                        break block0;
                    }
                    case 8: {
                        this.inst = 89;
                        break block0;
                    }
                    case 16: {
                        this.inst = 66;
                        break block0;
                    }
                }
                this.inst = -1;
                break;
            }
            case 17: {
                int n5 = this.getMSBofRS();
                switch (n5) {
                    case 1: {
                        int n6 = this.getZeroExtendedFunct();
                        int n7 = this.getZeroExtendedFormat();
                        this.type = 5;
                        switch (n6) {
                            case 32: {
                                switch (n7) {
                                    case 1: {
                                        this.inst = 133;
                                        break block0;
                                    }
                                    case 4: {
                                        this.inst = 134;
                                        break block0;
                                    }
                                }
                                this.inst = -1;
                                break block0;
                            }
                            case 33: {
                                switch (n7) {
                                    case 0: {
                                        this.inst = 131;
                                        break block0;
                                    }
                                    case 4: {
                                        this.inst = 132;
                                        break block0;
                                    }
                                }
                                this.inst = -1;
                                break block0;
                            }
                            case 36: {
                                switch (n7) {
                                    case 0: {
                                        this.inst = 135;
                                        break block0;
                                    }
                                    case 1: {
                                        this.inst = 136;
                                        break block0;
                                    }
                                }
                                this.inst = -1;
                                break block0;
                            }
                        }
                        if (n7 != 0 && n7 != 1) {
                            this.inst = -1;
                            break block0;
                        }
                        switch (n6) {
                            case 0: {
                                this.inst = 97 + n7;
                                break block0;
                            }
                            case 1: {
                                this.inst = 145 + n7;
                                break block0;
                            }
                            case 2: {
                                this.inst = 141 + n7;
                                break block0;
                            }
                            case 3: {
                                this.inst = 137 + n7;
                                break block0;
                            }
                            case 5: {
                                this.inst = 95 + n7;
                                break block0;
                            }
                            case 6: {
                                this.inst = 139 + n7;
                                break block0;
                            }
                            case 7: {
                                this.inst = 143 + n7;
                                break block0;
                            }
                            case 48: {
                                this.inst = 99 + n7;
                                break block0;
                            }
                            case 49: {
                                this.inst = 101 + n7;
                                break block0;
                            }
                            case 50: {
                                this.inst = 103 + n7;
                                break block0;
                            }
                            case 51: {
                                this.inst = 105 + n7;
                                break block0;
                            }
                            case 52: {
                                this.inst = 107 + n7;
                                break block0;
                            }
                            case 53: {
                                this.inst = 109 + n7;
                                break block0;
                            }
                            case 54: {
                                this.inst = 111 + n7;
                                break block0;
                            }
                            case 55: {
                                this.inst = 113 + n7;
                                break block0;
                            }
                            case 56: {
                                this.inst = 115 + n7;
                                break block0;
                            }
                            case 57: {
                                this.inst = 117 + n7;
                                break block0;
                            }
                            case 58: {
                                this.inst = 119 + n7;
                                break block0;
                            }
                            case 59: {
                                this.inst = 121 + n7;
                                break block0;
                            }
                            case 60: {
                                this.inst = 123 + n7;
                                break block0;
                            }
                            case 61: {
                                this.inst = 125 + n7;
                                break block0;
                            }
                            case 62: {
                                this.inst = 127 + n7;
                                break block0;
                            }
                            case 63: {
                                this.inst = 129 + n7;
                                break block0;
                            }
                        }
                        this.inst = -1;
                        break block0;
                    }
                }
                int n8 = this.getZeroExtendedRS();
                switch (n8) {
                    case 0: {
                        this.type = 4;
                        this.inst = 50;
                        break block0;
                    }
                    case 2: {
                        this.type = 4;
                        this.inst = 24;
                        break block0;
                    }
                    case 4: {
                        this.type = 4;
                        this.inst = 56;
                        break block0;
                    }
                    case 6: {
                        this.type = 4;
                        this.inst = 28;
                        break block0;
                    }
                }
                if ((n8 & 8) == 0) {
                    this.inst = -1;
                    break;
                }
                this.type = 3;
                int n9 = this.getZeroExtendedRT();
                switch (n9) {
                    case 0: {
                        this.inst = 7;
                        break block0;
                    }
                    case 1: {
                        this.inst = 11;
                        break block0;
                    }
                }
                this.inst = -1;
                break;
            }
            case 18: 
            case 19: {
                this.inst = -1;
                break;
            }
            case 2: {
                this.inst = 33;
                this.type = 1;
                break;
            }
            case 3: {
                this.inst = 34;
                this.type = 1;
                break;
            }
            case 4: {
                this.inst = 14;
                this.type = 0;
                break;
            }
            case 5: {
                this.inst = 21;
                this.type = 0;
                break;
            }
            case 6: {
                this.inst = 18;
                this.type = 0;
                break;
            }
            case 7: {
                this.inst = 17;
                this.type = 0;
                break;
            }
            case 8: {
                this.inst = 1;
                this.type = 0;
                break;
            }
            case 9: {
                this.inst = 2;
                this.type = 0;
                break;
            }
            case 10: {
                this.inst = 72;
                this.type = 0;
                break;
            }
            case 11: {
                this.inst = 73;
                this.type = 0;
                break;
            }
            case 12: {
                this.inst = 5;
                this.type = 0;
                break;
            }
            case 13: {
                this.inst = 65;
                this.type = 0;
                break;
            }
            case 14: {
                this.inst = 94;
                this.type = 0;
                break;
            }
            case 15: {
                this.inst = 41;
                this.type = 0;
                break;
            }
            case 32: {
                this.inst = 37;
                this.type = 0;
                break;
            }
            case 33: {
                this.inst = 39;
                this.type = 0;
                break;
            }
            case 34: {
                this.inst = 47;
                this.type = 0;
                break;
            }
            case 35: {
                this.inst = 42;
                this.type = 0;
                break;
            }
            case 36: {
                this.inst = 38;
                this.type = 0;
                break;
            }
            case 37: {
                this.inst = 40;
                this.type = 0;
                break;
            }
            case 38: {
                this.inst = 48;
                this.type = 0;
                break;
            }
            case 40: {
                this.inst = 67;
                this.type = 0;
                break;
            }
            case 41: {
                this.inst = 68;
                this.type = 0;
                break;
            }
            case 42: {
                this.inst = 86;
                this.type = 0;
                break;
            }
            case 43: {
                this.inst = 81;
                this.type = 0;
                break;
            }
            case 48: {
                this.inst = 43;
                this.type = 0;
                break;
            }
            case 49: {
                this.inst = 44;
                this.type = 0;
                break;
            }
            case 50: {
                this.inst = 45;
                this.type = 0;
                break;
            }
            case 51: {
                this.inst = 46;
                this.type = 0;
                break;
            }
            case 56: {
                this.inst = 82;
                this.type = 0;
                break;
            }
            case 57: {
                this.inst = 83;
                this.type = 0;
                break;
            }
            case 58: {
                this.inst = 84;
                this.type = 0;
                break;
            }
            case 59: {
                this.inst = 85;
                this.type = 0;
                break;
            }
            default: {
                this.inst = -1;
            }
        }
    }

    public int getInstruction() {
        return this.inst;
    }

    public int getType() {
        return this.type;
    }

    public int getZeroExtendedOP() {
        return (this.operation & 0xFC000000) >>> 26;
    }

    public int getMSBofRS() {
        return (this.operation & 0x2000000) >>> 25;
    }

    public int getZeroExtendedFormat() {
        return (this.operation & 0x1E00000) >>> 21;
    }

    public int getZeroExtendedRS() {
        return (this.operation & 0x3E00000) >>> 21;
    }

    public int getSignExtendedRS() {
        if ((this.operation & 0x2000000) == 0x2000000) {
            return (this.operation & 0x3E00000 | 0xFC000000) >> 21;
        }
        return (this.operation & 0x3E00000) >> 21;
    }

    public int getZeroExtendedRT() {
        return (this.operation & 0x1F0000) >>> 16;
    }

    public int getSignExtendedRT() {
        if ((this.operation & 0x100000) == 0x100000) {
            return (this.operation & 0x1F0000 | 0xFFE00000) >> 16;
        }
        return (this.operation & 0x1F0000) >> 16;
    }

    public int getZeroExtendedFT() {
        return (this.operation & 0x1F0000) >>> 16;
    }

    public int getZeroExtendedImmediate() {
        return this.operation & 0xFFFF;
    }

    public int getSignExtendedImmediate() {
        if ((this.operation & 0x8000) == 32768) {
            return this.operation & 0xFFFF | 0xFFFF0000;
        }
        return this.operation & 0xFFFF;
    }

    public int getZeroExtendedTarget() {
        return this.operation & 0x3FFFFFF;
    }

    public int getSignExtendedTarget() {
        if ((this.operation & 0x2000000) == 0x2000000) {
            return this.operation & 0x3FFFFFF | 0xFC000000;
        }
        return this.operation & 0x3FFFFFF;
    }

    public int getZeroExtendedRD() {
        return (this.operation & 0xF800) >>> 11;
    }

    public int getSignExtendedRD() {
        if ((this.operation & 0x8000) == 32768) {
            return (this.operation & 0xF800 | 0xFFFF0000) >> 11;
        }
        return (this.operation & 0xF800) >> 11;
    }

    public int getZeroExtendedFS() {
        return (this.operation & 0xF800) >>> 11;
    }

    public int getZeroExtendedShamt() {
        return (this.operation & 0x7C0) >>> 6;
    }

    public int getSignExtendedShamt() {
        if ((this.operation & 0x400) == 1024) {
            return (this.operation & 0x7C0 | 0xFFFFF800) >> 6;
        }
        return (this.operation & 0x7C0) >> 6;
    }

    public int getZeroExtendedFD() {
        return (this.operation & 0x7C0) >>> 6;
    }

    public int getZeroExtendedFunct() {
        return this.operation & 0x3F;
    }

    public String registerName(int n, int n2) {
        String string = "";
        block0 : switch (n2) {
            case 0: {
                switch (n) {
                    case 28: {
                        string = "$gp";
                        break block0;
                    }
                    case 29: {
                        string = "$sp";
                        break block0;
                    }
                    case 30: {
                        string = "$fp";
                        break block0;
                    }
                }
                string = String.format("$%d", n);
                break;
            }
            case 1: 
            case 2: {
                string = String.format("$f%d", n);
            }
        }
        return string;
    }

    public String toString() {
        if (this.inst == -1) {
            return "unkown operation" + String.format("(0x%08x", this.getZeroExtendedOP() + ")");
        }
        String string = instruction[this.inst];
        String string2 = "";
        for (int i = 8 - string.length(); i > 0; --i) {
            string2 = string2 + " ";
        }
        string = string + string2;
        block0 : switch (this.type) {
            case 0: {
                switch (this.inst) {
                    case 1: 
                    case 2: 
                    case 72: 
                    case 73: {
                        string = string + this.registerName(this.getZeroExtendedRT(), 0);
                        string = string + "," + this.registerName(this.getZeroExtendedRS(), 0);
                        string = string + String.format(",%d", this.getSignExtendedImmediate());
                        break;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: {
                        string = string + this.registerName(this.getZeroExtendedRS(), 0);
                        string = string + "," + this.registerName(this.getZeroExtendedRT(), 0);
                        string = string + String.format(",%d", this.getSignExtendedImmediate());
                        break;
                    }
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 67: 
                    case 68: 
                    case 81: {
                        string = string + this.registerName(this.getZeroExtendedRT(), 0);
                        string = string + String.format(",%d", this.getSignExtendedImmediate());
                        string = string + "(" + this.registerName(this.getZeroExtendedRS(), 0) + ")";
                        break;
                    }
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: {
                        string = string + this.registerName(this.getZeroExtendedRT(), 1);
                        string = string + String.format(",%d", this.getSignExtendedImmediate());
                        string = string + "(" + this.registerName(this.getZeroExtendedRS(), 0) + ")";
                        break;
                    }
                    case 5: 
                    case 41: 
                    case 65: 
                    case 94: {
                        string = string + this.registerName(this.getZeroExtendedRT(), 0);
                        string = string + "," + this.registerName(this.getZeroExtendedRS(), 0);
                        string = string + String.format(",%d", this.getZeroExtendedImmediate());
                    }
                }
                break;
            }
            case 1: {
                string = string + String.format("0x%08x", this.getSignExtendedTarget());
                break;
            }
            case 2: {
                switch (this.inst) {
                    case 69: {
                        if (this.operation == 0) {
                            string = "nop";
                            break block0;
                        }
                    }
                    case 75: 
                    case 77: {
                        string = string + this.registerName(this.getZeroExtendedRD(), 0);
                        string = string + "," + this.registerName(this.getZeroExtendedRT(), 0);
                        string = string + String.format(",%d", this.getZeroExtendedShamt());
                        break block0;
                    }
                    case 31: 
                    case 32: 
                    case 61: 
                    case 62: {
                        string = string + this.registerName(this.getZeroExtendedRS(), 0);
                        string = string + "," + this.registerName(this.getZeroExtendedRT(), 0);
                        break block0;
                    }
                }
                string = string + this.registerName(this.getZeroExtendedRD(), 0);
                string = string + "," + this.registerName(this.getZeroExtendedRS(), 0);
                string = string + "," + this.registerName(this.getZeroExtendedRT(), 0);
                break;
            }
            case 3: {
                string = string + this.getSignExtendedImmediate();
                break;
            }
            case 4: {
                string = string + this.registerName(this.getZeroExtendedRT(), 0);
                string = string + "," + this.registerName(this.getZeroExtendedFS(), 1);
                break;
            }
            case 5: {
                switch (this.inst) {
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 129: 
                    case 130: {
                        string = string + this.registerName(this.getZeroExtendedFS(), 2);
                        string = string + "," + this.registerName(this.getZeroExtendedFT(), 2);
                        break block0;
                    }
                    case 95: 
                    case 96: 
                    case 131: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 139: 
                    case 140: 
                    case 143: 
                    case 144: {
                        string = string + this.registerName(this.getZeroExtendedFD(), 2);
                        string = string + "," + this.registerName(this.getZeroExtendedFS(), 2);
                        break block0;
                    }
                }
                string = string + this.registerName(this.getZeroExtendedFD(), 2);
                string = string + "," + this.registerName(this.getZeroExtendedFS(), 2);
                string = string + "," + this.registerName(this.getZeroExtendedFT(), 2);
                break;
            }
        }
        return string;
    }
}

