/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.mips;

import net.wasamon.mics.memory.RandomAccessMemory;
import net.wasamon.mics.processor.mips.MipsRegister;
import net.wasamon.mics.processor.mips.VirtualMemory;

public class MipsProgramCounter
implements MipsRegister {
    private int physicalCounter;
    private int virtualCounter;
    private RandomAccessMemory physicalMemory;
    private VirtualMemory virtualMemory;

    public MipsProgramCounter(RandomAccessMemory randomAccessMemory, VirtualMemory virtualMemory) {
        this.setMemory(randomAccessMemory, virtualMemory);
    }

    public MipsProgramCounter() {
        this.reset();
    }

    public void setMemory(RandomAccessMemory randomAccessMemory, VirtualMemory virtualMemory) {
        this.virtualMemory = virtualMemory;
        this.physicalMemory = randomAccessMemory;
        this.reset();
    }

    public int getAsIntValue() {
        return this.virtualCounter;
    }

    public float getAsFloatValue() {
        return Float.intBitsToFloat(this.virtualCounter);
    }

    public void reset() {
        if (this.virtualMemory != null && this.physicalMemory != null) {
            this.virtualCounter = this.virtualMemory.getEntryPoint();
            this.physicalCounter = this.virtualMemory.getPhysicalAddress(this.virtualCounter);
        } else {
            this.virtualCounter = 0;
            this.physicalCounter = 0;
        }
    }

    public void setAsBits(int n) {
        this.setVirtualCounter(n);
    }

    public void setAsBits(float f) {
        this.setVirtualCounter(Float.floatToIntBits(f));
    }

    public int getVirtualCounter() {
        return this.virtualCounter;
    }

    public int getPhysicalCounter() {
        return this.physicalCounter;
    }

    public void setVirtualCounter(int n) {
        this.virtualCounter = n;
        this.update();
    }

    public void add(int n) {
        this.virtualCounter += n;
        this.physicalCounter += n;
    }

    private void update() {
        this.physicalCounter = this.virtualMemory.getPhysicalAddress(this.virtualCounter);
    }

    public String toString() {
        return String.format("%08x", this.virtualCounter);
    }
}

