/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.mips;

import net.wasamon.mics.processor.mips.MipsFloatRegister;
import net.wasamon.mics.processor.mips.MipsIntRegister;
import net.wasamon.mics.processor.mips.MipsOperation;

public class R3010 {
    private static final int REGISTER_SIZE = 32;
    private MipsFloatRegister[] register = new MipsFloatRegister[32];
    private MipsIntRegister fcr0;
    private MipsIntRegister fcr31;

    public R3010() {
        for (int i = 0; i < 32; ++i) {
            this.register[i] = new MipsFloatRegister();
        }
        this.fcr0 = new MipsIntRegister();
        this.fcr31 = new MipsIntRegister();
    }

    protected int getC() {
        return (this.fcr0.getAsIntValue() & 0x800000) >>> 23;
    }

    private int getExceptions() {
        return (this.fcr0.getAsIntValue() & 0x3F000) >>> 12;
    }

    private int getTrapEnable() {
        return (this.fcr0.getAsIntValue() & 0xF80) >>> 7;
    }

    private int getStickyBits() {
        return (this.fcr0.getAsIntValue() & 0x7C) >>> 2;
    }

    private int getRM() {
        return this.fcr0.getAsIntValue() & 3;
    }

    private int getImp() {
        return (this.fcr31.getAsIntValue() & 0xFF00) >>> 8;
    }

    private int getRev() {
        return this.fcr31.getAsIntValue() & 0xFF;
    }

    private void setC(int n) {
        this.fcr0.setAsBits(this.fcr0.getAsIntValue() & 0xFF7FFFFF | n << 23 & 0x800000);
    }

    private void setExceptions(int n) {
        this.fcr0.setAsBits(this.fcr0.getAsIntValue() & 0xFFFC0FFF | n << 12 & 0x3F000);
    }

    private void setTrapEnable(int n) {
        this.fcr0.setAsBits(this.fcr0.getAsIntValue() & 0xFFFFF07F | n << 7 & 0xF80);
    }

    private void setStickyBits(int n) {
        this.fcr0.setAsBits(this.fcr0.getAsIntValue() & 0xFFFFFF83 | n << 2 & 0x7C);
    }

    private void setRM(int n) {
        this.fcr0.setAsBits(this.fcr0.getAsIntValue() & 0xFFFFFFFC | n & 3);
    }

    protected MipsFloatRegister getRegister(int n) {
        return this.register[n];
    }

    protected MipsIntRegister getControlRegister(int n) {
        if (n == 0) {
            return this.fcr0;
        }
        if (n == 31) {
            return this.fcr31;
        }
        return null;
    }

    private void setFPR(int n, double d) {
        this.setFPR(n, Double.doubleToLongBits(d));
    }

    private void setFPR(int n, long l) {
        int n2 = (int)((l & 0xFFFFFFFF00000000L) >>> 32);
        int n3 = (int)(l & 0xFFFFFFFFL);
        this.getRegister(n + 1).setAsBits(n2);
        this.getRegister(n).setAsBits(n3);
    }

    private double getFPRasDouble(int n) {
        return Double.longBitsToDouble(this.getFPRasBits(n));
    }

    private long getFPRasBits(int n) {
        long l = (long)this.getRegister(n).getAsIntValue() & 0xFFFFFFFFL;
        long l2 = (long)this.getRegister(n + 1).getAsIntValue() & 0xFFFFFFFFL;
        long l3 = 0L;
        l3 |= l2 << 32;
        return l3 |= l;
    }

    protected void exec(MipsOperation mipsOperation) {
        switch (mipsOperation.getInstruction()) {
            case 95: {
                MipsFloatRegister mipsFloatRegister = this.getRegister(mipsOperation.getZeroExtendedFS());
                MipsFloatRegister mipsFloatRegister2 = this.getRegister(mipsOperation.getZeroExtendedFD());
                mipsFloatRegister2.setAsBits(Math.abs(mipsFloatRegister.getAsFloatValue()));
                break;
            }
            case 96: {
                this.setFPR(mipsOperation.getZeroExtendedFD(), Math.abs(this.getFPRasDouble(mipsOperation.getZeroExtendedFS())));
                break;
            }
            case 97: {
                MipsFloatRegister mipsFloatRegister = this.getRegister(mipsOperation.getZeroExtendedFS());
                MipsFloatRegister mipsFloatRegister3 = this.getRegister(mipsOperation.getZeroExtendedFT());
                MipsFloatRegister mipsFloatRegister4 = this.getRegister(mipsOperation.getZeroExtendedFD());
                mipsFloatRegister4.setAsBits(mipsFloatRegister.getAsFloatValue() + mipsFloatRegister3.getAsFloatValue());
                break;
            }
            case 98: {
                double d = this.getFPRasDouble(mipsOperation.getZeroExtendedFS()) + this.getFPRasDouble(mipsOperation.getZeroExtendedFT());
                this.setFPR(mipsOperation.getZeroExtendedFD(), d);
                break;
            }
            case 99: {
                this.setC(0);
                break;
            }
            case 100: {
                this.setC(0);
                break;
            }
            case 101: {
                float f = this.getRegister(mipsOperation.getZeroExtendedFT()).getAsFloatValue();
                float f2 = this.getRegister(mipsOperation.getZeroExtendedFS()).getAsFloatValue();
                if (f == Float.NaN || f2 == Float.NaN) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 102: {
                double d = this.getFPRasDouble(mipsOperation.getZeroExtendedFT());
                double d2 = this.getFPRasDouble(mipsOperation.getZeroExtendedFS());
                if (d == Double.NaN || d2 == Double.NaN) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 103: {
                float f = this.getRegister(mipsOperation.getZeroExtendedFT()).getAsFloatValue();
                float f3 = this.getRegister(mipsOperation.getZeroExtendedFS()).getAsFloatValue();
                if (f == Float.NaN || f3 == Float.NaN) {
                    this.setC(0);
                    break;
                }
                if (f == f3) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 104: {
                double d = this.getFPRasDouble(mipsOperation.getZeroExtendedFT());
                double d3 = this.getFPRasDouble(mipsOperation.getZeroExtendedFS());
                if (d == Double.NaN || d3 == Double.NaN) {
                    this.setC(0);
                    break;
                }
                if (d == d3) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 105: {
                float f = this.getRegister(mipsOperation.getZeroExtendedFT()).getAsFloatValue();
                float f4 = this.getRegister(mipsOperation.getZeroExtendedFS()).getAsFloatValue();
                if (f == Float.NaN || f4 == Float.NaN || f == f4) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 106: {
                double d = this.getFPRasDouble(mipsOperation.getZeroExtendedFT());
                double d4 = this.getFPRasDouble(mipsOperation.getZeroExtendedFS());
                if (d == Double.NaN || d4 == Double.NaN || d == d4) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 107: {
                float f = this.getRegister(mipsOperation.getZeroExtendedFT()).getAsFloatValue();
                float f5 = this.getRegister(mipsOperation.getZeroExtendedFS()).getAsFloatValue();
                if (f == Float.NaN || f5 == Float.NaN) {
                    this.setC(0);
                    break;
                }
                if (f > f5) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 108: {
                double d = this.getFPRasDouble(mipsOperation.getZeroExtendedFT());
                double d5 = this.getFPRasDouble(mipsOperation.getZeroExtendedFS());
                if (d == Double.NaN || d5 == Double.NaN) {
                    this.setC(0);
                    break;
                }
                if (d > d5) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 109: {
                float f = this.getRegister(mipsOperation.getZeroExtendedFT()).getAsFloatValue();
                float f6 = this.getRegister(mipsOperation.getZeroExtendedFS()).getAsFloatValue();
                if (f == Float.NaN || f6 == Float.NaN || f > f6) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 110: {
                double d = this.getFPRasDouble(mipsOperation.getZeroExtendedFT());
                double d6 = this.getFPRasDouble(mipsOperation.getZeroExtendedFS());
                if (d == Double.NaN || d6 == Double.NaN || d > d6) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 111: {
                float f = this.getRegister(mipsOperation.getZeroExtendedFT()).getAsFloatValue();
                float f7 = this.getRegister(mipsOperation.getZeroExtendedFS()).getAsFloatValue();
                if (f == Float.NaN || f7 == Float.NaN) {
                    this.setC(0);
                    break;
                }
                if (f >= f7) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 112: {
                double d = this.getFPRasDouble(mipsOperation.getZeroExtendedFT());
                double d7 = this.getFPRasDouble(mipsOperation.getZeroExtendedFS());
                if (d == Double.NaN || d7 == Double.NaN) {
                    this.setC(0);
                    break;
                }
                if (d >= d7) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 113: {
                float f = this.getRegister(mipsOperation.getZeroExtendedFT()).getAsFloatValue();
                float f8 = this.getRegister(mipsOperation.getZeroExtendedFS()).getAsFloatValue();
                if (f == Float.NaN || f8 == Float.NaN || f >= f8) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 114: {
                double d = this.getFPRasDouble(mipsOperation.getZeroExtendedFT());
                double d8 = this.getFPRasDouble(mipsOperation.getZeroExtendedFS());
                if (d == Double.NaN || d8 == Double.NaN || d >= d8) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 115: {
                this.setC(0);
                break;
            }
            case 116: {
                this.setC(0);
                break;
            }
            case 117: {
                float f = this.getRegister(mipsOperation.getZeroExtendedFT()).getAsFloatValue();
                float f9 = this.getRegister(mipsOperation.getZeroExtendedFS()).getAsFloatValue();
                if (f == Float.NaN || f9 == Float.NaN) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 118: {
                double d = this.getFPRasDouble(mipsOperation.getZeroExtendedFT());
                double d9 = this.getFPRasDouble(mipsOperation.getZeroExtendedFS());
                if (d == Double.NaN || d9 == Double.NaN) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 119: {
                float f = this.getRegister(mipsOperation.getZeroExtendedFT()).getAsFloatValue();
                float f10 = this.getRegister(mipsOperation.getZeroExtendedFS()).getAsFloatValue();
                if (f == Float.NaN || f10 == Float.NaN) {
                    this.setC(0);
                    break;
                }
                if (f == f10) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 120: {
                double d = this.getFPRasDouble(mipsOperation.getZeroExtendedFT());
                double d10 = this.getFPRasDouble(mipsOperation.getZeroExtendedFS());
                if (d == Double.NaN || d10 == Double.NaN) {
                    this.setC(0);
                    break;
                }
                if (d == d10) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 121: {
                float f = this.getRegister(mipsOperation.getZeroExtendedFT()).getAsFloatValue();
                float f11 = this.getRegister(mipsOperation.getZeroExtendedFS()).getAsFloatValue();
                if (f == Float.NaN || f11 == Float.NaN || f == f11) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 122: {
                double d = this.getFPRasDouble(mipsOperation.getZeroExtendedFT());
                double d11 = this.getFPRasDouble(mipsOperation.getZeroExtendedFS());
                if (d == Double.NaN || d11 == Double.NaN || d == d11) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 123: {
                float f = this.getRegister(mipsOperation.getZeroExtendedFT()).getAsFloatValue();
                float f12 = this.getRegister(mipsOperation.getZeroExtendedFS()).getAsFloatValue();
                if (f == Float.NaN || f12 == Float.NaN) {
                    this.setC(0);
                    break;
                }
                if (f > f12) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 124: {
                double d = this.getFPRasDouble(mipsOperation.getZeroExtendedFT());
                double d12 = this.getFPRasDouble(mipsOperation.getZeroExtendedFS());
                if (d == Double.NaN || d12 == Double.NaN) {
                    this.setC(0);
                    break;
                }
                if (d > d12) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 125: {
                float f = this.getRegister(mipsOperation.getZeroExtendedFT()).getAsFloatValue();
                float f13 = this.getRegister(mipsOperation.getZeroExtendedFS()).getAsFloatValue();
                if (f == Float.NaN || f13 == Float.NaN || f > f13) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 126: {
                double d = this.getFPRasDouble(mipsOperation.getZeroExtendedFT());
                double d13 = this.getFPRasDouble(mipsOperation.getZeroExtendedFS());
                if (d == Double.NaN || d13 == Double.NaN || d > d13) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 127: {
                float f = this.getRegister(mipsOperation.getZeroExtendedFT()).getAsFloatValue();
                float f14 = this.getRegister(mipsOperation.getZeroExtendedFS()).getAsFloatValue();
                if (f == Float.NaN || f14 == Float.NaN) {
                    this.setC(0);
                    break;
                }
                if (f >= f14) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 128: {
                double d = this.getFPRasDouble(mipsOperation.getZeroExtendedFT());
                double d14 = this.getFPRasDouble(mipsOperation.getZeroExtendedFS());
                if (d == Double.NaN || d14 == Double.NaN) {
                    this.setC(0);
                    break;
                }
                if (d >= d14) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 129: {
                float f = this.getRegister(mipsOperation.getZeroExtendedFT()).getAsFloatValue();
                float f15 = this.getRegister(mipsOperation.getZeroExtendedFS()).getAsFloatValue();
                if (f == Float.NaN || f15 == Float.NaN || f >= f15) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 130: {
                double d = this.getFPRasDouble(mipsOperation.getZeroExtendedFT());
                double d15 = this.getFPRasDouble(mipsOperation.getZeroExtendedFS());
                if (d == Double.NaN || d15 == Double.NaN || d >= d15) {
                    this.setC(1);
                    break;
                }
                this.setC(0);
                break;
            }
            case 131: {
                MipsFloatRegister mipsFloatRegister = this.getRegister(mipsOperation.getZeroExtendedFS());
                this.setFPR(mipsOperation.getZeroExtendedFD(), mipsFloatRegister.getAsFloatValue());
                break;
            }
            case 132: {
                MipsFloatRegister mipsFloatRegister = this.getRegister(mipsOperation.getZeroExtendedFS());
                this.setFPR(mipsOperation.getZeroExtendedFD(), (double)mipsFloatRegister.getAsIntValue());
                break;
            }
            case 133: {
                MipsFloatRegister mipsFloatRegister = this.getRegister(mipsOperation.getZeroExtendedFD());
                mipsFloatRegister.setAsBits((float)this.getFPRasDouble(mipsOperation.getZeroExtendedFS()));
                break;
            }
            case 134: {
                MipsFloatRegister mipsFloatRegister = this.getRegister(mipsOperation.getZeroExtendedFS());
                MipsFloatRegister mipsFloatRegister5 = this.getRegister(mipsOperation.getZeroExtendedFD());
                mipsFloatRegister5.setAsBits((float)mipsFloatRegister.getAsIntValue());
                break;
            }
            case 135: {
                MipsFloatRegister mipsFloatRegister = this.getRegister(mipsOperation.getZeroExtendedFS());
                MipsFloatRegister mipsFloatRegister6 = this.getRegister(mipsOperation.getZeroExtendedFD());
                mipsFloatRegister6.setAsBits((int)mipsFloatRegister.getAsFloatValue());
                break;
            }
            case 136: {
                MipsFloatRegister mipsFloatRegister = this.getRegister(mipsOperation.getZeroExtendedFD());
                mipsFloatRegister.setAsBits((int)this.getFPRasDouble(mipsOperation.getZeroExtendedFS()));
                break;
            }
            case 137: {
                MipsFloatRegister mipsFloatRegister = this.getRegister(mipsOperation.getZeroExtendedFS());
                MipsFloatRegister mipsFloatRegister7 = this.getRegister(mipsOperation.getZeroExtendedFT());
                MipsFloatRegister mipsFloatRegister8 = this.getRegister(mipsOperation.getZeroExtendedFD());
                mipsFloatRegister8.setAsBits(mipsFloatRegister.getAsFloatValue() / mipsFloatRegister7.getAsFloatValue());
                break;
            }
            case 138: {
                double d = this.getFPRasDouble(mipsOperation.getZeroExtendedFS()) / this.getFPRasDouble(mipsOperation.getZeroExtendedFT());
                this.setFPR(mipsOperation.getZeroExtendedFD(), d);
                break;
            }
            case 139: {
                MipsFloatRegister mipsFloatRegister = this.getRegister(mipsOperation.getZeroExtendedFS());
                MipsFloatRegister mipsFloatRegister9 = this.getRegister(mipsOperation.getZeroExtendedFD());
                mipsFloatRegister9.setAsBits(mipsFloatRegister.getAsFloatValue());
                break;
            }
            case 140: {
                this.setFPR(mipsOperation.getZeroExtendedFD(), this.getFPRasDouble(mipsOperation.getZeroExtendedFS()));
                break;
            }
            case 141: {
                MipsFloatRegister mipsFloatRegister = this.getRegister(mipsOperation.getZeroExtendedFS());
                MipsFloatRegister mipsFloatRegister10 = this.getRegister(mipsOperation.getZeroExtendedFT());
                MipsFloatRegister mipsFloatRegister11 = this.getRegister(mipsOperation.getZeroExtendedFD());
                mipsFloatRegister11.setAsBits(mipsFloatRegister.getAsFloatValue() * mipsFloatRegister10.getAsFloatValue());
                break;
            }
            case 142: {
                double d = this.getFPRasDouble(mipsOperation.getZeroExtendedFS()) * this.getFPRasDouble(mipsOperation.getZeroExtendedFT());
                this.setFPR(mipsOperation.getZeroExtendedFD(), d);
                break;
            }
            case 143: {
                MipsFloatRegister mipsFloatRegister = this.getRegister(mipsOperation.getZeroExtendedFS());
                MipsFloatRegister mipsFloatRegister12 = this.getRegister(mipsOperation.getZeroExtendedFD());
                int n = mipsFloatRegister.getAsIntValue();
                mipsFloatRegister12.setAsBits(~n);
                break;
            }
            case 144: {
                long l = this.getFPRasBits(mipsOperation.getZeroExtendedFS());
                this.setFPR(mipsOperation.getZeroExtendedFD(), l ^ 0xFFFFFFFFFFFFFFFFL);
                break;
            }
            case 145: {
                MipsFloatRegister mipsFloatRegister = this.getRegister(mipsOperation.getZeroExtendedFS());
                MipsFloatRegister mipsFloatRegister13 = this.getRegister(mipsOperation.getZeroExtendedFT());
                MipsFloatRegister mipsFloatRegister14 = this.getRegister(mipsOperation.getZeroExtendedFD());
                mipsFloatRegister14.setAsBits(mipsFloatRegister.getAsFloatValue() - mipsFloatRegister13.getAsFloatValue());
                break;
            }
            case 146: {
                double d = this.getFPRasDouble(mipsOperation.getZeroExtendedFS()) - this.getFPRasDouble(mipsOperation.getZeroExtendedFT());
                this.setFPR(mipsOperation.getZeroExtendedFD(), d);
                break;
            }
            default: {
                System.out.println("unkown operation !!!!!!");
            }
        }
    }
}

