/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.mips;

import net.wasamon.mics.processor.mips.ELFHeader;

public class VirtualMemory {
    public static final int START_OF_PROTRAM_POINT = 0x400000;
    private int physicalMemorySize;
    private int entryPoint;
    private int[] mapping;

    public VirtualMemory(ELFHeader eLFHeader) {
        this.physicalMemorySize = eLFHeader.getPhysicalMemory().size();
        this.mapping = eLFHeader.getMapping();
        this.entryPoint = eLFHeader.getEntryPoint();
    }

    public int getPhysicalAddress(int n) {
        if (this.mapping[0] <= n && n < this.mapping[this.mapping.length - 3] + this.mapping[this.mapping.length - 1]) {
            return this.mapping[1] + n - this.mapping[0];
        }
        if (n < 0x400000) {
            return -1;
        }
        if (n < 0x400000 + this.physicalMemorySize) {
            return n - 0x400000 + 1;
        }
        return n;
    }

    public int getEntryPoint() {
        return this.entryPoint;
    }
}

