/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.monorlu;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import net.wasamon.mics.processor.monorlu.ReconfigurableUnit;

class ConfigDataViewer {
    private ConfigDataCanvas canvas;
    private Frame frame = new Frame("Config Data Viewer");

    public ConfigDataViewer() {
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ConfigDataViewer.this.frame.setVisible(false);
            }
        });
        this.frame.setSize(600, 600);
        this.canvas = new ConfigDataCanvas();
        this.frame.add(this.canvas);
        this.frame.setVisible(false);
    }

    public void setReconfigurableUnit(ReconfigurableUnit reconfigurableUnit) {
        this.canvas.setReconfigurableUnit(reconfigurableUnit);
        this.frame.setTitle("Config Data Viewer (ID=" + reconfigurableUnit.id() + ")");
        this.frame.setVisible(true);
    }

    public void repaint() {
        this.canvas.repaint();
    }

    class ConfigDataCanvas
    extends Canvas {
        private static final long serialVersionUID = 1L;
        private ReconfigurableUnit rp = null;
        private int offset = 60;
        private int luwidth = 60;
        private int luheight = 60;

        private ConfigDataCanvas() {
        }

        private void setReconfigurableUnit(ReconfigurableUnit reconfigurableUnit) {
            this.rp = reconfigurableUnit;
            this.repaint();
        }

        private int px(int n) {
            return this.offset + n * this.luwidth;
        }

        private int py(int n) {
            return this.offset + n * this.luheight;
        }

        private void paintLogicUnit(Graphics graphics, int n) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    graphics.drawRect(this.px(j), this.py(i), this.luwidth, this.luheight);
                    graphics.drawString(this.rp.getLogicUnitInstString(i * n + j), this.px(j) + 5, this.py(i) + 14);
                    graphics.drawString(this.rp.getLogicUnitShift(i * n + j), this.px(j) + 5, this.py(i) + 28);
                }
            }
        }

        private void paintDirection(Graphics graphics, int n) {
            int n2;
            int n3;
            int n4;
            int n5;
            for (n5 = 0; n5 < n; ++n5) {
                for (n4 = 0; n4 < n; ++n4) {
                    if (this.rp.getInputSrcRegister(n5 * n + n4, 0) == 0) {
                        graphics.setColor(Color.blue);
                    } else {
                        graphics.setColor(Color.red);
                    }
                    switch (this.rp.getInputSrcDir(0, n5 * n + n4)) {
                        case 0: {
                            n3 = -1;
                            n2 = -1;
                            break;
                        }
                        case 1: {
                            n3 = 0;
                            n2 = -1;
                            break;
                        }
                        case 2: {
                            n3 = 1;
                            n2 = -1;
                            break;
                        }
                        case 3: {
                            n3 = -1;
                            n2 = 0;
                            break;
                        }
                        case 4: {
                            n3 = 1;
                            n2 = 0;
                            break;
                        }
                        case 5: {
                            n3 = -1;
                            n2 = 1;
                            break;
                        }
                        case 6: {
                            n3 = 0;
                            n2 = 1;
                            break;
                        }
                        case 7: {
                            n3 = 1;
                            n2 = 1;
                            break;
                        }
                        default: {
                            n3 = 0;
                            n2 = 0;
                        }
                    }
                    graphics.drawLine(this.px(n4) + 28, this.py(n5) + 28, this.px(n4) + 28 + n3 * 60, this.py(n5) + 28 + n2 * 60);
                }
            }
            for (n5 = 0; n5 < n; ++n5) {
                for (n4 = 0; n4 < n; ++n4) {
                    if (this.rp.getInputSrcRegister(n5 * n + n4, 1) == 0) {
                        graphics.setColor(Color.blue);
                    } else {
                        graphics.setColor(Color.red);
                    }
                    switch (this.rp.getInputSrcDir(1, n5 * n + n4)) {
                        case 0: {
                            n3 = -1;
                            n2 = -1;
                            break;
                        }
                        case 1: {
                            n3 = 0;
                            n2 = -1;
                            break;
                        }
                        case 2: {
                            n3 = 1;
                            n2 = -1;
                            break;
                        }
                        case 3: {
                            n3 = -1;
                            n2 = 0;
                            break;
                        }
                        case 4: {
                            n3 = 1;
                            n2 = 0;
                            break;
                        }
                        case 5: {
                            n3 = -1;
                            n2 = 1;
                            break;
                        }
                        case 6: {
                            n3 = 0;
                            n2 = 1;
                            break;
                        }
                        case 7: {
                            n3 = 1;
                            n2 = 1;
                            break;
                        }
                        default: {
                            n3 = 0;
                            n2 = 0;
                        }
                    }
                    graphics.drawLine(this.px(n4) + 32, this.py(n5) + 32, this.px(n4) + 32 + n3 * 60, this.py(n5) + 32 + n2 * 60);
                }
            }
            graphics.setColor(Color.black);
        }

        public void paint(Graphics graphics) {
            if (this.rp == null) {
                return;
            }
            int n = (int)Math.sqrt(this.rp.size());
            this.paintDirection(graphics, n);
            this.paintLogicUnit(graphics, n);
        }
    }
}

