/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.monorlu;

import net.wasamon.mics.ConfigErrorException;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.processor.monorlu.DataProvider;
import net.wasamon.mics.processor.monorlu.ReconfigurableUnit;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.wallet.binutils.UnknownInstructionException;

public class LogicUnit
implements DataProvider {
    public static final int major_version = 0;
    public static final int minor_version = 1;
    public static final int INST_NOP = 0;
    public static final int INST_ADD = 1;
    public static final int INST_SUB = 2;
    public static final int INST_AND = 3;
    public static final int INST_OR = 4;
    public static final int INST_MUL0 = 5;
    public static final int INST_MULT = 6;
    public static final int SHIFT_NONE = 0;
    public static final int SHIFT_LEFT = 1;
    public static final int SHIFT_RIGHT = 2;
    private char[] input = new char[3];
    private char[] output = new char[3];
    private int id;
    private ReconfigurableUnit unit;

    public LogicUnit(ReconfigurableUnit reconfigurableUnit, int n) {
        this.id = n;
        this.unit = reconfigurableUnit;
        this.reset();
    }

    public void reset() {
        this.input[0] = '\u0000';
        this.input[1] = '\u0000';
        this.input[2] = '\u0000';
        this.output[0] = '\u0000';
        this.output[1] = '\u0000';
        this.output[2] = '\u0000';
    }

    public char getData(int n) {
        return this.output[n];
    }

    public void load() throws MicsException {
        this.input[0] = this.unit.getInputSrcLogicUnit(this.id, 0).getData(this.unit.getInputSrcRegister(this.id, 0));
        this.input[1] = this.unit.getInputSrcLogicUnit(this.id, 1).getData(this.unit.getInputSrcRegister(this.id, 1));
        this.input[2] = this.unit.getInputSrcLogicUnit(this.id, 0).getData(2);
    }

    private int shifter(int n, int n2) throws ConfigErrorException {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                n2 <<= 1;
                break;
            }
            case 2: {
                n2 >>= 1;
                break;
            }
            default: {
                throw new ConfigErrorException();
            }
        }
        return n2;
    }

    public void exec() throws ConfigErrorException {
        int n = DataUtil.toInteger((char)this.input[0], (char)this.input[1]);
        n = this.shifter(this.unit.getLogicUnitPreShift(this.id), n);
        switch (this.unit.getLogicUnitInst(this.id)) {
            case 0: {
                break;
            }
            case 1: {
                n = this.input[0] + this.input[1];
                break;
            }
            case 2: {
                n = this.input[0] - this.input[1];
                break;
            }
            case 3: {
                n = this.input[0] & this.input[1];
                break;
            }
            case 4: {
                n = this.input[0] | this.input[1];
                break;
            }
            case 5: {
                if ((this.input[1] & '\u0001') == 1) {
                    n = this.input[0];
                    n = DataUtil.toInteger((char)DataUtil.toCharL((int)n), (char)this.input[1]);
                    break;
                }
                n = DataUtil.toInteger((char)'\u0000', (char)this.input[1]);
                break;
            }
            case 6: {
                if ((this.input[1] & '\u0001') != 1) break;
                n = this.input[0] + this.input[2];
                n = DataUtil.toInteger((char)DataUtil.toCharL((int)n), (char)this.input[1]);
                break;
            }
            default: {
                throw new ConfigErrorException();
            }
        }
        n = this.shifter(this.unit.getLogicUnitPostShift(this.id), n);
        this.output[0] = DataUtil.toCharH((int)n);
        this.output[1] = DataUtil.toCharL((int)n);
        this.output[2] = this.input[2];
    }

    public String getShiftOpString() {
        int n = this.unit.getLogicUnitPreShift(this.id);
        int n2 = this.unit.getLogicUnitPostShift(this.id);
        String string = "";
        switch (n) {
            case 2: {
                string = string + "R";
                break;
            }
            case 1: {
                string = string + "L";
                break;
            }
            case 0: {
                string = string + "N";
                break;
            }
            default: {
                string = string + "E";
            }
        }
        switch (n2) {
            case 2: {
                string = string + "R";
                break;
            }
            case 1: {
                string = string + "L";
                break;
            }
            case 0: {
                string = string + "N";
                break;
            }
            default: {
                string = string + "E";
            }
        }
        return string;
    }

    public String getLogicUnitInstString() {
        switch (this.unit.getLogicUnitInst(this.id)) {
            case 0: {
                return "NOP  ";
            }
            case 1: {
                return "ADD  ";
            }
            case 2: {
                return "SUB  ";
            }
            case 3: {
                return "AND  ";
            }
            case 4: {
                return "OR   ";
            }
            case 5: {
                return "MUL0 ";
            }
            case 6: {
                return "MULT ";
            }
        }
        return "ERROR";
    }

    public static int getInstructionCode(String string) throws UnknownInstructionException {
        if (string == null || string.equals("")) {
            throw new UnknownInstructionException();
        }
        if (string.equals("NOP")) {
            return 0;
        }
        if (string.equals("ADD")) {
            return 1;
        }
        if (string.equals("SUB")) {
            return 2;
        }
        if (string.equals("AND")) {
            return 3;
        }
        if (string.equals("OR")) {
            return 4;
        }
        if (string.equals("MUL0")) {
            return 5;
        }
        if (string.equals("MULT")) {
            return 6;
        }
        throw new UnknownInstructionException();
    }

    public static int getShiftOpCode(String string) throws UnknownInstructionException {
        if (string == null || string.equals("")) {
            throw new UnknownInstructionException();
        }
        if (string.equals("RIGHT")) {
            return 2;
        }
        if (string.equals("LEFT")) {
            return 1;
        }
        if (string.equals("NONE")) {
            return 0;
        }
        throw new UnknownInstructionException();
    }

    public String getShiftStr(int n) {
        switch (n) {
            case 0: {
                return "NONE ";
            }
            case 1: {
                return "LEFT ";
            }
            case 2: {
                return "RIGHT";
            }
        }
        return "ERROR";
    }
}

