/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.monorlu;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.memory.RandomAccessMemory;
import net.wasamon.mics.memory.RandomAccessMemoryDataPacket;
import net.wasamon.mics.processor.monorlu.ConfigDataViewer;
import net.wasamon.mics.processor.monorlu.DataProvider;
import net.wasamon.mics.processor.monorlu.GlobalDataProvider;
import net.wasamon.mics.processor.monorlu.LogicUnit;
import net.wasamon.mjlib.print.FormatException;
import net.wasamon.mjlib.print.PrintFormat;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Node;

public class ReconfigurableUnit
extends MicsElement
implements ExecutableElement,
ChannelConnectable,
DataBuffer,
MicsViewable {
    public static final int NorthWest = 0;
    public static final int North = 1;
    public static final int NorthEast = 2;
    public static final int West = 3;
    public static final int East = 4;
    public static final int SouthWest = 5;
    public static final int South = 6;
    public static final int SouthEast = 7;
    public static final int NonDirection = -1;
    private LogicUnit[] unit;
    private int size;
    private DataProvider[] input;
    private DataProvider[] output;
    private String busID;
    private int ruAddr;
    private int contextAddr;
    private RandomAccessMemory context;
    private char busbuffer;
    private Channel busInstance = null;
    private ConfigDataViewer viewer = null;

    private void initialize(int n) {
        this.context = new RandomAccessMemory(4 * n * n);
        this.contextAddr = 0;
        this.unit = new LogicUnit[n * n];
        for (int i = 0; i < n * n; ++i) {
            this.unit[i] = new LogicUnit(this, i);
        }
        this.input = new DataProvider[n];
        this.output = new DataProvider[n];
    }

    public void initialize(String string, Node node) throws MicsException {
        try {
            int n;
            Node node2 = node;
            this.size = n = Integer.parseInt(XMLParser.getAttribute((Node)node2, (String)"size").getNodeValue());
            this.initialize(n);
            Node[] nodeArray = XMLParser.getNamedNode((Node)node, (String)"channel");
            String string2 = XMLParser.getAttribute((Node)nodeArray, (String)"id").getNodeValue();
            int n2 = Integer.parseInt(XMLParser.getAttribute((Node)nodeArray, (String)"offset").getNodeValue());
            this.setDataBus(string2, n2);
            nodeArray = XMLParser.getNamedNodeArray((Node)node, (String)"init");
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node3 = nodeArray[i];
                String string3 = XMLParser.getAttribute((Node)node3, (String)"file").getNodeValue();
                if (string3.charAt(0) != '/') {
                    string3 = string + "/" + string3;
                }
                int n3 = DataUtil.parseInt((String)XMLParser.getAttribute((Node)node3, (String)"offset").getNodeValue());
                try {
                    this.write(n3, new BufferedInputStream(new FileInputStream(string3)));
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("no such file: " + string3);
                    System.out.println("[W] no data is written as initialize.");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.processor.rlu.ReconfigurableProcessor");
        }
        catch (XMLParserException xMLParserException) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.processor.rlu.ReconfigurableProcessor");
        }
    }

    private void setDataBus(String string, int n) {
        int n2;
        this.busID = string;
        this.ruAddr = n;
        for (n2 = 0; n2 < this.size; ++n2) {
            this.input[n2] = new GlobalDataProvider(this, n + n2 * 4);
        }
        for (n2 = 0; n2 < this.size; ++n2) {
            this.output[n2] = this.unit[this.size * (this.size - 1) + n2];
        }
    }

    public int size() {
        return this.unit.length;
    }

    public MicsDataPacket read(MicsDataPacket micsDataPacket) {
        return this.context.read(micsDataPacket);
    }

    public void write(MicsDataPacket micsDataPacket) {
        this.context.write(micsDataPacket);
    }

    public void write(int n, InputStream inputStream) throws DataBufferException {
        this.context.write(n, inputStream);
    }

    public void dump(int n, int n2, OutputStream outputStream) throws DataBufferException {
        this.context.dump(n, n2, outputStream);
    }

    public String toString(int n, int n2) {
        return this.context.toString(n, n2);
    }

    public void reset() {
        for (int i = 0; i < this.unit.length; ++i) {
            this.unit[i].reset();
        }
    }

    public void writeback(MicsDataPacket micsDataPacket) {
        this.busbuffer = DataUtil.toChar((byte[])((RandomAccessMemoryDataPacket)micsDataPacket).data, (int)0, (int)2);
    }

    public int getChannelOffset(Channel channel) {
        return this.ruAddr;
    }

    private Channel bus() throws MicsException {
        if (this.busInstance == null) {
            this.busInstance = this.composite.getChannel(this.busID);
        }
        return this.busInstance;
    }

    public char getInputData(int n) throws MicsException {
        this.bus().readRequest((ChannelConnectable)this, RandomAccessMemoryDataPacket.readPacket(n, 1, 16));
        return this.busbuffer;
    }

    public ExecInfo exec_first() throws MicsException {
        int n;
        ExecInfo execInfo = new ExecInfo();
        for (n = 0; n < this.unit.length; ++n) {
            this.unit[n].load();
        }
        for (n = 0; n < this.unit.length; ++n) {
            this.unit[n].exec();
        }
        for (n = 0; n < this.size; ++n) {
            this.bus().writeRequest((ChannelConnectable)this, RandomAccessMemoryDataPacket.writePacket(this.ruAddr + this.size * 4 + 4 * n, 1, 16, DataUtil.toByteArray((char)this.output[n].getData(0))));
            this.bus().writeRequest((ChannelConnectable)this, RandomAccessMemoryDataPacket.writePacket(this.ruAddr + this.size * 4 + 4 * n + 2, 1, 16, DataUtil.toByteArray((char)this.output[n].getData(1))));
        }
        execInfo.setTerminatableFlag(true);
        return execInfo;
    }

    public ExecInfo exec_second() {
        return null;
    }

    public String toString() {
        String string = "";
        try {
            int n;
            string = string + "==\n";
            try {
                for (n = 0; n < this.size; ++n) {
                    string = string + PrintFormat.print((String)"%04x", (int)this.input[n].getData(0));
                    string = string + ":";
                    string = string + PrintFormat.print((String)"%04x", (int)this.input[n].getData(1));
                    string = string + ":";
                    string = string + PrintFormat.print((String)"%04x", (int)this.input[n].getData(2));
                    string = string + " ";
                }
            }
            catch (MicsException micsException) {
                string = string + "catch: " + micsException.getMessage();
            }
            string = string + "\n";
            string = string + "--\n";
            for (n = 0; n < this.size; ++n) {
                for (int i = 0; i < this.size; ++i) {
                    string = string + PrintFormat.print((String)"%04x", (int)this.unit[n * this.size + i].getData(0));
                    string = string + ":";
                    string = string + PrintFormat.print((String)"%04x", (int)this.unit[n * this.size + i].getData(1));
                    string = string + ":";
                    string = string + PrintFormat.print((String)"%04x", (int)this.unit[n * this.size + i].getData(2));
                    string = string + " ";
                }
                string = string + "\n";
            }
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        return string;
    }

    public int getLogicUnitInst(int n) {
        return this.context.read(this.contextAddr + n * 4) & 0xFF;
    }

    public int getLogicUnitPreShift(int n) {
        return this.context.read(this.contextAddr + n * 4 + 1) >> 2 & 3;
    }

    public int getLogicUnitPostShift(int n) {
        return this.context.read(this.contextAddr + n * 4 + 1) & 3;
    }

    private int getInputSrcID(int n, int n2) {
        if (n2 == 0) {
            return this.context.read(this.contextAddr + n * 4 + 2) & 0xFF;
        }
        return this.context.read(this.contextAddr + n * 4 + 3) & 0xFF;
    }

    public String getLogicUnitInstString(int n) {
        return this.unit[n].getLogicUnitInstString();
    }

    public String getLogicUnitShift(int n) {
        return this.unit[n].getShiftOpString();
    }

    public DataProvider getInputSrcLogicUnit(int n, int n2) {
        int n3 = this.getInputSrcID(n, n2);
        if (n == n3) {
            if (n / this.size == 0) {
                return this.input[n];
            }
            return this.unit[n];
        }
        return this.unit[n3];
    }

    public int getInputSrcRegister(int n, int n2) {
        if (n2 == 0) {
            return this.context.read(this.contextAddr + n * 4 + 1) >> 7 & 1;
        }
        return this.context.read(this.contextAddr + n * 4 + 1) >> 6 & 1;
    }

    public int getInputSrcDir(int n, int n2) {
        int n3 = this.getInputSrcID(n2, n);
        int n4 = n3 - n2;
        switch (n4) {
            case -9: {
                return 0;
            }
            case -8: {
                return 1;
            }
            case -7: {
                return 2;
            }
            case -1: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 6;
            }
            case 9: {
                return 7;
            }
        }
        return -1;
    }

    public String[] getConnectedElements() {
        return new String[]{this.busID};
    }

    public String getInfo() {
        String string = "";
        string = string + "ReconfigurableUnit\n";
        string = string + "  CLASS: " + ((Object)((Object)this)).getClass().getName() + "\n";
        string = string + "  ID: " + this.id() + "\n";
        string = string + "  Local Memory ID: " + this.context.id() + ",";
        string = string + " offset = " + this.contextAddr + "\n";
        string = string + "  Channel ID: ";
        try {
            string = string + ((MicsElement)this.bus()).id() + ",";
        }
        catch (MicsException micsException) {
            string = string + "unconnected,";
        }
        string = string + " input offset = " + this.ruAddr + ",";
        string = string + " output offset = " + (this.ruAddr + this.size * 4);
        return string;
    }

    public void show() {
        if (this.viewer == null) {
            this.viewer = new ConfigDataViewer();
        }
        this.viewer.setReconfigurableUnit(this);
        this.viewer.repaint();
    }

    public String getImagePath() {
        return "cb_rlu.png";
    }
}

