/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.rlu;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import net.wasamon.mics.processor.rlu.LogicUnit;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.wallet.binutils.AssemblerException;
import net.wasamon.wallet.binutils.UnknownInstructionException;

public class ConfigDataAssembler {
    public static final int NonDirection = 0;
    public static final int West = 1;
    public static final int NorthWest = 2;
    public static final int North = 3;
    public static final int NorthEast = 4;
    public static final int East = 5;
    private ArrayList programs = new ArrayList();
    private String currentFile;
    private int nUnits;
    private Pattern linePattern = Pattern.compile("[, ]+");

    public void parser(String string) throws IOException, FileNotFoundException {
        try {
            this.currentFile = string;
            this.programs.clear();
            File file = new File(string);
            File file2 = this.parser(file);
            System.out.println(string + " -> " + file.getParent() + "/" + file2.getName());
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.exit(0);
        }
    }

    public File parser(File file) throws UnknownInstructionException, AssemblerException, IOException, FileNotFoundException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = "";
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            this.parseLine(string, ++n);
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        byteArrayOutputStream = this.getObjectCode();
        int n2 = file.getName().lastIndexOf(46);
        File file2 = new File(file.getParent(), file.getName().substring(0, n2) + ".cnf");
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byteArrayOutputStream.writeTo(fileOutputStream);
        fileOutputStream.flush();
        fileOutputStream.close();
        byteArrayOutputStream.close();
        return file2;
    }

    private ByteArrayOutputStream getObjectCode() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[this.nUnits * this.nUnits * 4];
        ConfigData configData = null;
        for (int i = 0; i < this.programs.size(); ++i) {
            configData = (ConfigData)this.programs.get(i);
            int n = configData.id[0] * this.nUnits + configData.id[1];
            byArray[4 * n] = configData.inst;
            byArray[4 * n + 1] = configData.shiftOp;
            byArray[4 * n + 2] = (byte)this.getDirectionID(n, configData.src0[0] * this.nUnits + configData.src0[1]);
            byArray[4 * n + 3] = (byte)this.getDirectionID(n, configData.src1[0] * this.nUnits + configData.src1[1]);
        }
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        byteArrayOutputStream.flush();
        return byteArrayOutputStream;
    }

    private int getDirectionID(int n, int n2) {
        int n3 = n - n2;
        int n4 = 0;
        if (n3 == 0) {
            n4 = 0;
        } else if (n3 == this.nUnits + 1) {
            n4 = 2;
        } else if (n3 == this.nUnits) {
            n4 = 3;
        } else if (n3 == this.nUnits - 1) {
            n4 = 4;
        } else if (n3 == 1) {
            n4 = 1;
        } else if (n3 == -1) {
            n4 = 5;
        } else {
            System.err.println("[E] Illegal Direction at " + this.getClass().getName() + " " + n2 + "->" + n);
        }
        return n4;
    }

    private void parseAssemblerIndicate(String string) throws AssemblerException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        if (".size".equals(stringArray[0])) {
            try {
                this.nUnits = DataUtil.parseInt((String)stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AssemblerException("syntax error");
            }
        } else {
            throw new AssemblerException("Unknown parameter: " + stringArray[0]);
        }
    }

    private void parseLine(String string, int n) throws UnknownInstructionException, AssemblerException {
        if (string.equals("")) {
            return;
        }
        String[] stringArray = null;
        stringArray = this.linePattern.split(string);
        if (stringArray[0].charAt(0) == '#') {
            return;
        }
        if (stringArray[0].charAt(0) == '.') {
            try {
                this.parseAssemblerIndicate(string);
                return;
            }
            catch (AssemblerException assemblerException) {
                throw new AssemblerException(assemblerException.getMessage() + " " + this.currentFile + " at line " + n);
            }
        }
        if (stringArray.length != 6) {
            for (int i = 0; i < stringArray.length; ++i) {
            }
            throw new AssemblerException("syntax error: " + this.currentFile + " at line " + n);
        }
        this.programs.add(new ConfigData(stringArray));
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("no input file");
            System.exit(0);
        }
        ConfigDataAssembler configDataAssembler = new ConfigDataAssembler();
        for (int i = 0; i < stringArray.length; ++i) {
            configDataAssembler.parser(stringArray[i]);
        }
    }

    class ConfigData {
        public int[] id;
        public byte inst;
        public byte shiftOp;
        public int[] src0;
        public int[] src1;
        private Pattern argPattern = Pattern.compile(":");

        public ConfigData(String[] stringArray) throws UnknownInstructionException {
            this.inst = (byte)LogicUnit.getInstructionCode(stringArray[1].toUpperCase());
            this.src0 = this.getLogicUnitID(stringArray[4]);
            this.src1 = this.getLogicUnitID(stringArray[5]);
            this.id = this.getLogicUnitID(stringArray[0]);
            this.shiftOp = (byte)((LogicUnit.getShiftOpCode(stringArray[2].toUpperCase()) << 2) + LogicUnit.getShiftOpCode(stringArray[3].toUpperCase()));
            if (this.src0[2] != 0) {
                if (this.src0[2] == 1) {
                    this.shiftOp = (byte)(this.shiftOp | 0xFFFFFF80);
                } else {
                    throw new UnknownInstructionException("Illegal source register id = " + this.src0[2] + " for logic unit(0)");
                }
            }
            if (this.src1[2] != 0) {
                if (this.src1[2] == 1) {
                    this.shiftOp = (byte)(this.shiftOp | 0x40);
                } else {
                    throw new UnknownInstructionException("Illegal source register id = " + this.src1[2] + " for logic unit(1)");
                }
            }
        }

        private int[] getLogicUnitID(String string) throws UnknownInstructionException {
            String[] stringArray = this.argPattern.split(string);
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = Integer.parseInt(stringArray[i]);
            }
            return nArray;
        }
    }
}

