/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.rlu;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import net.wasamon.mics.processor.rlu.LogicUnit;
import net.wasamon.mics.processor.rlu.ReconfigurableUnit;

class ConfigDataViewer {
    private ConfigDataCanvas canvas;
    private Frame frame = new Frame("Config Data Viewer");

    public ConfigDataViewer() {
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ConfigDataViewer.this.frame.setVisible(false);
            }
        });
        this.frame.setSize(600, 600);
        this.canvas = new ConfigDataCanvas();
        this.frame.add(this.canvas);
        this.frame.setVisible(false);
    }

    public void setReconfigurableUnit(ReconfigurableUnit reconfigurableUnit) {
        this.canvas.setReconfigurableUnit(reconfigurableUnit);
        this.frame.setTitle("Config Data Viewer (ID=" + reconfigurableUnit.id() + ")");
        this.frame.setVisible(true);
    }

    public void repaint() {
        this.canvas.repaint();
    }

    class ConfigDataCanvas
    extends Canvas {
        private static final long serialVersionUID = 1L;
        private ReconfigurableUnit rp = null;
        private int offset = 60;
        private int luwidth = 60;
        private int luheight = 60;

        private ConfigDataCanvas() {
        }

        private void setReconfigurableUnit(ReconfigurableUnit reconfigurableUnit) {
            this.rp = reconfigurableUnit;
            this.repaint();
        }

        private int px(int n) {
            return this.offset + n * this.luwidth;
        }

        private int py(int n) {
            return this.offset + n * this.luheight;
        }

        private void paintLogicUnit(Graphics graphics, int n) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    graphics.drawRect(this.px(j), this.py(i), this.luwidth, this.luheight);
                    LogicUnit logicUnit = this.rp.unit[i * n + j];
                    graphics.drawString(logicUnit.getLogicUnitInstString(), this.px(j) + 5, this.py(i) + 14);
                    graphics.drawString(logicUnit.getShiftOpString(), this.px(j) + 5, this.py(i) + 28);
                }
            }
        }

        private Color getRegColor(int n) {
            if (n == 0) {
                return Color.blue;
            }
            return Color.red;
        }

        private Point getDirectinValue(int n) {
            switch (n) {
                case 2: {
                    return new Point(-1, -1);
                }
                case 3: {
                    return new Point(0, -1);
                }
                case 4: {
                    return new Point(1, -1);
                }
                case 1: {
                    return new Point(-1, 0);
                }
                case 5: {
                    return new Point(1, 0);
                }
            }
            return new Point(0, 0);
        }

        private void paintDirection(Graphics graphics, int n) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    LogicUnit logicUnit = this.rp.unit[i * n + j];
                    graphics.setColor(this.getRegColor(logicUnit.srcReg[0].regID));
                    Point point = this.getDirectinValue(logicUnit.srcReg[0].dir);
                    graphics.drawLine(this.px(j) + 28, this.py(i) + 28, this.px(j) + 28 + point.x * 60, this.py(i) + 28 + point.y * 60);
                    graphics.setColor(this.getRegColor(logicUnit.srcReg[1].regID));
                    point = this.getDirectinValue(logicUnit.srcReg[1].dir);
                    graphics.drawLine(this.px(j) + 32, this.py(i) + 32, this.px(j) + 32 + point.x * 60, this.py(i) + 32 + point.y * 60);
                }
            }
            graphics.setColor(Color.black);
        }

        public void paint(Graphics graphics) {
            if (this.rp == null) {
                return;
            }
            int n = (int)Math.sqrt(this.rp.size());
            this.paintDirection(graphics, n);
            this.paintLogicUnit(graphics, n);
        }
    }
}

