/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.rlu;

import java.io.InputStream;
import java.io.OutputStream;
import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.ConfigErrorException;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.MicsCompositeElement;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.memory.RandomAccessMemoryDataPacket;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.wallet.binutils.UnknownInstructionException;
import org.w3c.dom.Node;

public class LogicUnit
extends MicsElement
implements DataBuffer,
ExecutableElement,
ChannelConnectable {
    public static final int major_version = 1;
    public static final int minor_version = 0;
    public static final int revision = 0;
    public static final int INST_NOP = 0;
    public static final int INST_ADD = 1;
    public static final int INST_SUB = 2;
    public static final int INST_AND = 3;
    public static final int INST_OR = 4;
    public static final int INST_MUL0 = 5;
    public static final int INST_MULT = 6;
    public static final int SHIFT_NONE = 0;
    public static final int SHIFT_LEFT = 1;
    public static final int SHIFT_RIGHT = 2;
    private char[] input = new char[3];
    private char[] output = new char[3];
    private int preShifter = 0;
    private int postShifter = 0;
    private int inst = 0;
    private DataBuffer[] connects;
    InputRegister[] srcReg = new InputRegister[2];
    private String busID;
    private Channel bus = null;
    private int addr;
    private boolean fWriteOutput = false;

    LogicUnit(MicsCompositeElement micsCompositeElement) {
        this.composite = micsCompositeElement;
    }

    public void initialize(DataBuffer[] dataBufferArray) {
        this.connects = dataBufferArray;
        this.srcReg[0] = new InputRegister();
        this.srcReg[1] = new InputRegister();
        this.reset();
    }

    public void reset() {
        this.input[0] = '\u0000';
        this.input[1] = '\u0000';
        this.input[2] = '\u0000';
        this.output[0] = '\u0000';
        this.output[1] = '\u0000';
        this.output[2] = '\u0000';
    }

    private int shifter(int n, int n2) throws ConfigErrorException {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                n2 <<= 1;
                break;
            }
            case 2: {
                n2 >>= 1;
                break;
            }
            default: {
                throw new ConfigErrorException();
            }
        }
        return n2;
    }

    void setChannel(String string, int n, boolean bl) {
        this.busID = string;
        this.addr = n;
        this.fWriteOutput = bl;
    }

    public ExecInfo exec_first() throws MicsException {
        RandomAccessMemoryDataPacket randomAccessMemoryDataPacket;
        ExecInfo execInfo = new ExecInfo();
        DataBuffer dataBuffer = this.connects[this.srcReg[0].dir];
        if (dataBuffer != null) {
            randomAccessMemoryDataPacket = (RandomAccessMemoryDataPacket)dataBuffer.read(RandomAccessMemoryDataPacket.readPacket(this.srcReg[0].regID * 2, 2, 8));
            this.input[0] = DataUtil.toChar((byte[])randomAccessMemoryDataPacket.data, (int)0, (int)2);
        }
        if ((dataBuffer = this.connects[this.srcReg[1].dir]) != null) {
            randomAccessMemoryDataPacket = (RandomAccessMemoryDataPacket)dataBuffer.read(RandomAccessMemoryDataPacket.readPacket(this.srcReg[1].regID * 2, 2, 8));
            this.input[1] = DataUtil.toChar((byte[])randomAccessMemoryDataPacket.data, (int)0, (int)2);
        }
        if ((dataBuffer = this.connects[this.srcReg[0].dir]) != null) {
            randomAccessMemoryDataPacket = (RandomAccessMemoryDataPacket)dataBuffer.read(RandomAccessMemoryDataPacket.readPacket(4, 2, 8));
            this.input[2] = DataUtil.toChar((byte[])randomAccessMemoryDataPacket.data, (int)0, (int)2);
        }
        execInfo.setTerminatableFlag(true);
        return execInfo;
    }

    public ExecInfo exec_second() throws MicsException {
        ExecInfo execInfo = new ExecInfo();
        int n = DataUtil.toInteger((char)this.input[0], (char)this.input[1]);
        n = this.shifter(this.preShifter, n);
        switch (this.inst) {
            case 0: {
                break;
            }
            case 1: {
                n = this.input[0] + this.input[1];
                break;
            }
            case 2: {
                n = this.input[0] - this.input[1];
                break;
            }
            case 3: {
                n = this.input[0] & this.input[1];
                break;
            }
            case 4: {
                n = this.input[0] | this.input[1];
                break;
            }
            case 5: {
                if ((this.input[1] & '\u0001') == 1) {
                    n = this.input[0];
                    n = DataUtil.toInteger((char)DataUtil.toCharL((int)n), (char)this.input[1]);
                    break;
                }
                n = DataUtil.toInteger((char)'\u0000', (char)this.input[1]);
                break;
            }
            case 6: {
                if ((this.input[1] & '\u0001') != 1) break;
                n = this.input[0] + this.input[2];
                n = DataUtil.toInteger((char)DataUtil.toCharL((int)n), (char)this.input[1]);
                break;
            }
            default: {
                throw new ConfigErrorException();
            }
        }
        n = this.shifter(this.postShifter, n);
        this.output[0] = DataUtil.toCharH((int)n);
        this.output[1] = DataUtil.toCharL((int)n);
        this.output[2] = this.input[2];
        if (this.fWriteOutput) {
            this.writeOutput();
        }
        execInfo.setTerminatableFlag(true);
        return execInfo;
    }

    private Channel bus() throws MicsException {
        if (this.bus == null) {
            this.bus = this.composite.getChannel(this.busID);
        }
        return this.bus;
    }

    private void writeOutput() throws MicsException {
        MicsDataPacket micsDataPacket = RandomAccessMemoryDataPacket.writePacket(this.addr, 1, 16, DataUtil.toByteArray((int)this.output[0], (int)2));
        this.bus().writeRequest((ChannelConnectable)this, micsDataPacket);
        micsDataPacket = RandomAccessMemoryDataPacket.writePacket(this.addr + 2, 1, 16, DataUtil.toByteArray((int)this.output[1], (int)2));
        this.bus().writeRequest((ChannelConnectable)this, micsDataPacket);
    }

    public void setLogicUnit(MicsDataPacket micsDataPacket) {
        byte[] byArray = ((RandomAccessMemoryDataPacket)micsDataPacket).data;
        this.setInst(byArray[0] & 0xFF);
        this.setPreSfhiter(byArray[1] >> 2 & 3);
        this.setPostShifter(byArray[1] & 3);
        this.setSrcRegisterRegisterID(0, byArray[1] >> 7 & 1);
        this.setSrcRegisterRegisterID(1, byArray[1] >> 6 & 1);
        this.setSrcRegisterDir(0, byArray[2] & 0xFF);
        this.setSrcRegisterDir(1, byArray[3] & 0xFF);
    }

    private void setInst(int n) {
        this.inst = n;
    }

    private void setPreSfhiter(int n) {
        this.preShifter = n;
    }

    private void setPostShifter(int n) {
        this.postShifter = n;
    }

    private void setSrcRegisterRegisterID(int n, int n2) {
        this.srcReg[n].regID = n2;
    }

    private void setSrcRegisterDir(int n, int n2) {
        this.srcReg[n].dir = n2;
    }

    public String getShiftOpString() {
        String string = "";
        switch (this.preShifter) {
            case 2: {
                string = string + "R";
                break;
            }
            case 1: {
                string = string + "L";
                break;
            }
            case 0: {
                string = string + "N";
                break;
            }
            default: {
                string = string + "E";
            }
        }
        switch (this.postShifter) {
            case 2: {
                string = string + "R";
                break;
            }
            case 1: {
                string = string + "L";
                break;
            }
            case 0: {
                string = string + "N";
                break;
            }
            default: {
                string = string + "E";
            }
        }
        return string;
    }

    public String getLogicUnitInstString() {
        switch (this.inst) {
            case 0: {
                return "NOP  ";
            }
            case 1: {
                return "ADD  ";
            }
            case 2: {
                return "SUB  ";
            }
            case 3: {
                return "AND  ";
            }
            case 4: {
                return "OR   ";
            }
            case 5: {
                return "MUL0 ";
            }
            case 6: {
                return "MULT ";
            }
        }
        return "ERROR";
    }

    public static int getInstructionCode(String string) throws UnknownInstructionException {
        if (string == null || string.equals("")) {
            throw new UnknownInstructionException();
        }
        if (string.equals("NOP")) {
            return 0;
        }
        if (string.equals("ADD")) {
            return 1;
        }
        if (string.equals("SUB")) {
            return 2;
        }
        if (string.equals("AND")) {
            return 3;
        }
        if (string.equals("OR")) {
            return 4;
        }
        if (string.equals("MUL0")) {
            return 5;
        }
        if (string.equals("MULT")) {
            return 6;
        }
        throw new UnknownInstructionException();
    }

    public static int getShiftOpCode(String string) throws UnknownInstructionException {
        if (string == null || string.equals("")) {
            throw new UnknownInstructionException();
        }
        if (string.equals("RIGHT")) {
            return 2;
        }
        if (string.equals("LEFT")) {
            return 1;
        }
        if (string.equals("NONE")) {
            return 0;
        }
        throw new UnknownInstructionException();
    }

    public String[] getConnectedElements() {
        return null;
    }

    public String getImagePath() {
        return null;
    }

    public void initialize(String string, Node node) throws MicsException {
    }

    public void dump(int n, int n2, OutputStream outputStream) throws DataBufferException {
    }

    public MicsDataPacket read(MicsDataPacket micsDataPacket) {
        RandomAccessMemoryDataPacket randomAccessMemoryDataPacket = (RandomAccessMemoryDataPacket)micsDataPacket;
        return RandomAccessMemoryDataPacket.writePacket(randomAccessMemoryDataPacket.addr, 1, 16, DataUtil.toByteArray((char)this.output[randomAccessMemoryDataPacket.addr / 2]));
    }

    public int size() {
        return 0;
    }

    public String toString(int n, int n2) {
        return null;
    }

    public void write(MicsDataPacket micsDataPacket) {
    }

    public void write(int n, InputStream inputStream) throws DataBufferException {
    }

    public int getChannelOffset(Channel channel) {
        return 0;
    }

    public void writeback(MicsDataPacket micsDataPacket) throws MicsException {
    }

    class InputRegister {
        int regID;
        int dir;

        InputRegister() {
        }
    }
}

