/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.rlu;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.memory.RandomAccessMemory;
import net.wasamon.mics.memory.RandomAccessMemoryDataPacket;
import net.wasamon.mics.processor.rlu.ConfigDataViewer;
import net.wasamon.mics.processor.rlu.ExternalDataInterface;
import net.wasamon.mics.processor.rlu.LogicUnit;
import net.wasamon.mjlib.print.FormatException;
import net.wasamon.mjlib.print.PrintFormat;
import net.wasamon.mjlib.util.DataUtil;
import org.w3c.dom.Node;

public class ReconfigurableUnit
extends MicsElement
implements ExecutableElement,
ChannelConnectable,
DataBuffer,
MicsViewable {
    LogicUnit[] unit;
    private int size;
    private ExternalDataInterface[] input;
    private String busID;
    private int ruAddr;
    private int contextAddr;
    private RandomAccessMemory context;
    private char busbuffer;
    private Channel busInstance = null;
    private ConfigDataViewer viewer = null;

    private void initialize(int n) {
        this.context = new RandomAccessMemory(4 * n * n);
        this.contextAddr = 0;
        this.unit = new LogicUnit[n * n];
        this.input = new ExternalDataInterface[n];
    }

    private DataBuffer[] getSrcLogicUnitArray(int n) {
        DataBuffer[] dataBufferArray = new DataBuffer[6];
        if (n / this.size == 0) {
            dataBufferArray[0] = this.input[n % this.size];
        }
        dataBufferArray[1] = n % this.size == 0 ? null : this.unit[n - 1];
        dataBufferArray[2] = n % this.size == 0 ? null : (n / this.size == 0 ? this.input[n % this.size - 1] : this.unit[n - this.size - 1]);
        dataBufferArray[3] = n / this.size == 0 ? null : this.unit[n - this.size];
        dataBufferArray[4] = n % this.size == this.size - 1 ? null : (n / this.size == 0 ? this.input[n % this.size + 1] : this.unit[n - this.size + 1]);
        dataBufferArray[5] = n % this.size == this.size - 1 ? null : this.unit[n + 1];
        return dataBufferArray;
    }

    private void setSize(String string, Node node) throws NumberFormatException {
        Integer n = this.getAttributeAsInt(node, "size");
        if (n == null) {
            throw new NumberFormatException("size value is illegal");
        }
        this.size = n;
        this.initialize(this.size);
    }

    private void setChannel(String string, Node node) throws MicsException {
        int n;
        Node node2 = this.getNamedNode(node, "channel");
        if (node2 == null) {
            throw new MicsException("configuration syntax error for " + ((Object)((Object)this)).getClass().getName() + ": channel not found.");
        }
        Integer n2 = this.getAttributeAsInt(node2, "offset");
        if (n2 == null) {
            throw new MicsException("configuration syntax error for " + ((Object)((Object)this)).getClass().getName() + ": channel offset is not defined.");
        }
        String string2 = this.getAttributeAsString(node2, "id");
        if (string2 == null) {
            throw new MicsException("configuration syntax error for " + ((Object)((Object)this)).getClass().getName() + ": channel id is not defined.");
        }
        this.busID = string2;
        this.ruAddr = n2;
        for (n = 0; n < this.size; ++n) {
            this.input[n] = new ExternalDataInterface(this.composite, this.busID, this.ruAddr + n * 4, null);
        }
        for (n = 0; n < this.size; ++n) {
            this.unit[this.size * (this.size - 1) + n].setChannel(this.busID, this.ruAddr + this.size * 4 + 4 * n, true);
        }
    }

    private void setInitialMemoryValue(String string, Node node) throws MicsException {
        Node[] nodeArray = this.getNamedNodeArray(node, "init");
        for (int i = 0; i < nodeArray.length; ++i) {
            Integer n;
            Node node2 = nodeArray[i];
            String string2 = this.getAttributeAsString(node2, "file");
            if (string2.charAt(0) != '/') {
                string2 = string + "/" + string2;
            }
            if ((n = this.getAttributeAsInt(node2, "offset")) == null) {
                throw new MicsException("configuration syntax error for " + ((Object)((Object)this)).getClass().getName() + ": init offset is not defined.");
            }
            try {
                this.write(n, new BufferedInputStream(new FileInputStream(string2)));
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("no such file: " + string2);
                System.out.println("[W] no data is written as initialize.");
            }
        }
    }

    public void initialize(String string, Node node) throws MicsException {
        try {
            int n;
            this.setSize(string, node);
            for (n = 0; n < this.size * this.size; ++n) {
                this.unit[n] = new LogicUnit(this.composite);
            }
            this.setChannel(string, node);
            for (n = 0; n < this.size * this.size; ++n) {
                this.unit[n].initialize(this.getSrcLogicUnitArray(n));
            }
            this.setInitialMemoryValue(string, node);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MicsException("configuration syntax error for " + ((Object)((Object)this)).getClass().getName());
        }
    }

    public int size() {
        return this.unit.length;
    }

    public MicsDataPacket read(MicsDataPacket micsDataPacket) {
        return this.context.read(micsDataPacket);
    }

    public void write(MicsDataPacket micsDataPacket) {
        this.context.write(micsDataPacket);
        this.unit[((RandomAccessMemoryDataPacket)micsDataPacket).addr / 4].setLogicUnit(micsDataPacket);
    }

    public void write(int n, InputStream inputStream) throws DataBufferException {
        this.context.write(n, inputStream);
        this.setLogicUnit();
    }

    public void dump(int n, int n2, OutputStream outputStream) throws DataBufferException {
        this.context.dump(n, n2, outputStream);
    }

    public String toString(int n, int n2) {
        return this.context.toString(n, n2);
    }

    public void reset() {
        for (int i = 0; i < this.unit.length; ++i) {
            this.unit[i].reset();
        }
    }

    public void writeback(MicsDataPacket micsDataPacket) {
        this.busbuffer = DataUtil.toChar((byte[])((RandomAccessMemoryDataPacket)micsDataPacket).data, (int)0, (int)2);
    }

    public int getChannelOffset(Channel channel) {
        return this.ruAddr;
    }

    private Channel bus() throws MicsException {
        if (this.busInstance == null) {
            this.busInstance = this.composite.getChannel(this.busID);
        }
        return this.busInstance;
    }

    public char getInputData(int n) throws MicsException {
        this.bus().readRequest((ChannelConnectable)this, RandomAccessMemoryDataPacket.readPacket(n, 1, 16));
        return this.busbuffer;
    }

    public ExecInfo exec_first() throws MicsException {
        ExecInfo execInfo = new ExecInfo();
        for (int i = 0; i < this.unit.length; ++i) {
            this.unit[i].exec_first();
        }
        execInfo.setTerminatableFlag(true);
        return execInfo;
    }

    public ExecInfo exec_second() throws MicsException {
        for (int i = 0; i < this.unit.length; ++i) {
            this.unit[i].exec_second();
        }
        return null;
    }

    private char readData(DataBuffer dataBuffer, int n) throws MicsException {
        MicsDataPacket micsDataPacket = dataBuffer.read(RandomAccessMemoryDataPacket.readPacket(n * 2, 2, 8));
        return DataUtil.toChar((byte[])((RandomAccessMemoryDataPacket)micsDataPacket).data, (int)0, (int)2);
    }

    public String toString() {
        String string = "";
        try {
            int n;
            string = string + "==\n";
            for (n = 0; n < this.size; ++n) {
                string = string + PrintFormat.print((String)"%04x", (int)this.readData(this.input[n], 0));
                string = string + ":";
                string = string + PrintFormat.print((String)"%04x", (int)this.readData(this.input[n], 1));
                string = string + ":";
                string = string + PrintFormat.print((String)"%04x", (int)this.readData(this.input[n], 2));
                string = string + " ";
            }
            string = string + "\n";
            string = string + "--\n";
            for (n = 0; n < this.size; ++n) {
                for (int i = 0; i < this.size; ++i) {
                    string = string + PrintFormat.print((String)"%04x", (int)this.readData(this.unit[n * this.size + i], 0));
                    string = string + ":";
                    string = string + PrintFormat.print((String)"%04x", (int)this.readData(this.unit[n * this.size + i], 1));
                    string = string + ":";
                    string = string + PrintFormat.print((String)"%04x", (int)this.readData(this.unit[n * this.size + i], 2));
                    string = string + " ";
                }
                string = string + "\n";
            }
        }
        catch (FormatException formatException) {
            string = string + "catch: " + formatException.getMessage();
        }
        catch (MicsException micsException) {
            string = string + "catch: " + micsException.getMessage();
        }
        return string;
    }

    private void setLogicUnit() {
        for (int i = 0; i < this.size * this.size; ++i) {
            this.unit[i].setLogicUnit(this.context.read(RandomAccessMemoryDataPacket.readPacket(this.contextAddr + i * 4, 4, 8)));
        }
    }

    public String[] getConnectedElements() {
        return new String[]{this.busID};
    }

    public String getInfo() {
        String string = "";
        string = string + "ReconfigurableUnit\n";
        string = string + "  CLASS: " + ((Object)((Object)this)).getClass().getName() + "\n";
        string = string + "  ID: " + this.id() + "\n";
        string = string + "  Local Memory ID: " + this.context.id() + ",";
        string = string + " offset = " + this.contextAddr + "\n";
        string = string + "  Channel ID: ";
        try {
            string = string + ((MicsElement)this.bus()).id() + ",";
        }
        catch (MicsException micsException) {
            string = string + "unconnected,";
        }
        string = string + " input offset = " + this.ruAddr + ",";
        string = string + " output offset = " + (this.ruAddr + this.size * 4);
        return string;
    }

    public void show() {
        if (this.viewer == null) {
            this.viewer = new ConfigDataViewer();
        }
        this.viewer.setReconfigurableUnit(this);
        this.viewer.repaint();
    }

    public String getImagePath() {
        return "cb_rlu.png";
    }
}

