/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.jgdb;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import net.wasamon.jgdb.GDBClient;
import net.wasamon.jgdb.GDBMIInterface;

class CommonGateway {
    private static CommonGateway instance = new CommonGateway();
    private Hashtable procTable;
    private int nProcs = 0;
    private ArrayList temporaryFiles = new ArrayList();

    public static CommonGateway getInstance() {
        return instance;
    }

    private CommonGateway() {
        this.procTable = new Hashtable();
    }

    public Object makeNewGdb(String name) {
        if (name.indexOf(" ") > 0 || name.indexOf("\t") > 0 || !name.endsWith("gdb")) {
            return "[EE] cannot exec command: " + name;
        }
        try {
            String id = "gdb" + String.valueOf(this.nProcs);
            ++this.nProcs;
            GDBMIInterface gdb = new GDBMIInterface(name);
            this.procTable.put(id, gdb);
            return id;
        }
        catch (IOException e) {
            return "[EE] catch IOException: " + e.getMessage();
        }
    }

    public Object initGdb(String id, String file, String breakpoint) {
        if (!this.procTable.containsKey(id)) {
            return "[EE] no such gdb process";
        }
        GDBClient gdb = (GDBClient)this.procTable.get(id);
        gdb.doInit(file, breakpoint);
        return "SUCCESS";
    }

    public Object initGdb(String id, byte[] data, String breakpoint) {
        if (!this.procTable.containsKey(id)) {
            return "[EE] no such gdb process";
        }
        GDBClient gdb = (GDBClient)this.procTable.get(id);
        File f = null;
        try {
            f = File.createTempFile("gdbtarget" + id, null);
            this.temporaryFiles.add(f);
            System.out.println("make temprary file: " + f.getAbsolutePath());
            FileOutputStream dest = new FileOutputStream(f);
            dest.write(data);
        }
        catch (IOException e) {
            return "[EE] cannot create temprary file for uploaded file";
        }
        gdb.doInit(f.getAbsolutePath(), breakpoint);
        return f.getName();
    }

    public Object quitGdb(String id) {
        if (!this.procTable.containsKey(id)) {
            return "[EE] no such gdb process";
        }
        GDBClient gdb = (GDBClient)this.procTable.get(id);
        gdb.doQuit();
        this.procTable.remove(id);
        return "SUCCESS";
    }

    public Object readMemoryValue(String id, String addr, int length) {
        if (!this.procTable.containsKey(id)) {
            return "[EE] no such gdb process";
        }
        GDBClient gdb = (GDBClient)this.procTable.get(id);
        return gdb.readMemoryValue(addr, length);
    }

    public Object readPCCode(String id) {
        if (!this.procTable.containsKey(id)) {
            return "[EE] no such gdb process";
        }
        GDBClient gdb = (GDBClient)this.procTable.get(id);
        return gdb.readPCCode();
    }

    public boolean setValueToRegister(String id, String addr, String value) {
        if (!this.procTable.containsKey(id)) {
            return false;
        }
        GDBClient gdb = (GDBClient)this.procTable.get(id);
        return gdb.setValueToRegister(addr, value);
    }

    public Object readRegister(String id, String reg) {
        if (!this.procTable.containsKey(id)) {
            return "[EE] no such gdb process";
        }
        GDBClient gdb = (GDBClient)this.procTable.get(id);
        return gdb.readRegister(reg);
    }

    public void finalize() throws Throwable {
        Iterator it = this.temporaryFiles.iterator();
        while (it.hasNext()) {
            File f = (File)it.next();
            System.out.println("remove temporary file: " + f.getName());
            f.deleteOnExit();
        }
        super.finalize();
    }

    public Object test() {
        System.out.println("test");
        return "";
    }
}

