/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.architecturemaker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.wasamon.mics.architecturemaker.RoundedCornerButton;
import net.wasamon.mics.architecturemaker.RoundedCornerTextField;
import net.wasamon.mics.architecturemaker.unit.HardwareUnit;
import net.wasamon.mics.architecturemaker.unit.Mediator;

public class ActionButtonPanel
extends JPanel {
    private RoundedCornerButton newButton;
    private RoundedCornerButton openButton;
    private RoundedCornerButton saveButton;
    private RoundedCornerButton convertButton;
    private RoundedCornerButton redoButton;
    private RoundedCornerButton undoButton;
    private RoundedCornerButton selectAllButton;
    private RoundedCornerButton cutButton;
    private RoundedCornerButton copyButton;
    private RoundedCornerButton pasteButton;
    private RoundedCornerButton zoomInButton;
    private RoundedCornerButton zoomOutButton;
    private RoundedCornerButton adjustButton;
    private RoundedCornerButton disconnectButton;
    private RoundedCornerButton deleteButton;
    private RoundedCornerButton helpButton;
    private RoundedCornerTextField scaleField;
    private Mediator mediator;
    private static ActionButtonPanel instance = new ActionButtonPanel();

    private ActionButtonPanel() {
        this.setLayout(new BorderLayout());
        this.mediator = Mediator.getInstance();
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        this.add((Component)jPanel, "West");
        this.add((Component)jPanel2, "East");
        this.newButton = new RoundedCornerButton("", this.newImageIcon("icons/button/file_bl_b.gif"), this.getBackground());
        this.openButton = new RoundedCornerButton("", this.newImageIcon("icons/button/file_xml_b.gif"), this.getBackground());
        this.saveButton = new RoundedCornerButton("", this.newImageIcon("icons/button/save_b.gif"), this.getBackground());
        this.convertButton = new RoundedCornerButton("", this.newImageIcon("icons/button/thunder.gif"), this.getBackground());
        this.undoButton = new RoundedCornerButton("", this.newImageIcon("icons/button/undo_b.gif"), this.getBackground());
        this.redoButton = new RoundedCornerButton("", this.newImageIcon("icons/button/redo_r.gif"), this.getBackground());
        this.selectAllButton = new RoundedCornerButton("", this.newImageIcon("icons/button/select_all.gif"), this.getBackground());
        this.cutButton = new RoundedCornerButton("", this.newImageIcon("icons/button/cut_b.gif"), this.getBackground());
        this.copyButton = new RoundedCornerButton("", this.newImageIcon("icons/button/copy_w.gif"), this.getBackground());
        this.pasteButton = new RoundedCornerButton("", this.newImageIcon("icons/button/paste_all_y.gif"), this.getBackground());
        this.zoomInButton = new RoundedCornerButton("", this.newImageIcon("icons/button/magnify_r.gif"), this.getBackground());
        this.zoomOutButton = new RoundedCornerButton("", this.newImageIcon("icons/button/reduce_b.gif"), this.getBackground());
        this.adjustButton = new RoundedCornerButton("", this.newImageIcon("icons/button/grid_g.gif"), this.getBackground());
        this.disconnectButton = new RoundedCornerButton("", this.newImageIcon("icons/button/con_off_w.gif"), this.getBackground());
        this.deleteButton = new RoundedCornerButton("", this.newImageIcon("icons/button/delete_r.gif"), this.getBackground());
        this.helpButton = new RoundedCornerButton("", this.newImageIcon("icons/button/help_w.gif"), this.getBackground());
        this.scaleField = new RoundedCornerTextField("100%");
        this.scaleField.setColumns(3);
        this.scaleField.setEditable(false);
        this.newButton.setToolTipText("New");
        this.openButton.setToolTipText("Open");
        this.saveButton.setToolTipText("Save");
        this.convertButton.setToolTipText("Convert");
        this.undoButton.setToolTipText("Undo");
        this.redoButton.setToolTipText("Redo");
        this.selectAllButton.setToolTipText("Select All");
        this.cutButton.setToolTipText("Cut");
        this.copyButton.setToolTipText("Copy");
        this.pasteButton.setToolTipText("Paste");
        this.zoomInButton.setToolTipText("Zoom In");
        this.zoomOutButton.setToolTipText("Zoom Out");
        this.adjustButton.setToolTipText("Adjust Position");
        this.disconnectButton.setToolTipText("Disconnect to Each Other");
        this.deleteButton.setToolTipText("Delete");
        this.helpButton.setToolTipText("I Can't Help You");
        jPanel.add(this.newButton);
        jPanel.add(this.openButton);
        jPanel.add(this.saveButton);
        jPanel.add(this.convertButton);
        jPanel.add(this.zoomOutButton);
        jPanel.add(this.scaleField);
        jPanel.add(this.zoomInButton);
        jPanel.add(this.undoButton);
        jPanel.add(this.redoButton);
        jPanel.add(this.selectAllButton);
        jPanel.add(this.cutButton);
        jPanel.add(this.copyButton);
        jPanel.add(this.pasteButton);
        jPanel.add(this.adjustButton);
        jPanel.add(this.disconnectButton);
        jPanel.add(this.deleteButton);
        jPanel2.add(this.helpButton);
        this.openButton.setEnabled(false);
        this.setActionButtonEnabled(true, true, true, false, false, false, false, false, false, false, false);
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ActionButtonPanel.this.mediator.modified()) {
                    int n = JOptionPane.showConfirmDialog(null, "Do you save this config file\nbefore cleaning the canvas ?", "", 1, 3, null);
                    if (n == 0) {
                        ActionButtonPanel.this.saveXML();
                        ActionButtonPanel.this.mediator.setModification(false);
                    } else if (n == 1) {
                        ActionButtonPanel.this.mediator.clearAllUnits();
                        ActionButtonPanel.this.mediator.convert();
                        ActionButtonPanel.this.mediator.setModification(false);
                    }
                }
            }
        });
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                } else if (n == 1 || n == -1) {
                    // empty if block
                }
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ActionButtonPanel.this.saveXML()) {
                    ActionButtonPanel.this.mediator.setModification(false);
                }
            }
        });
        this.convertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionButtonPanel.this.mediator.convert();
            }
        });
        this.zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ActionButtonPanel.this.mediator.getCanvasScale();
                if (n < 200) {
                    n *= 2;
                }
                ActionButtonPanel.this.scaleField.setText(Integer.toString(n) + "%");
                ActionButtonPanel.this.mediator.setCanvasScale(n);
            }
        });
        this.zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ActionButtonPanel.this.mediator.getCanvasScale();
                if (25 < n) {
                    n /= 2;
                }
                ActionButtonPanel.this.scaleField.setText(Integer.toString(n) + "%");
                ActionButtonPanel.this.mediator.setCanvasScale(n);
            }
        });
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionButtonPanel.this.mediator.selectAll();
            }
        });
        this.cutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HardwareUnit[] hardwareUnitArray = ActionButtonPanel.this.mediator.getSelectedUnits();
                ActionButtonPanel.this.mediator.copyUnits(hardwareUnitArray);
                ActionButtonPanel.this.mediator.deleteUnits(hardwareUnitArray);
            }
        });
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionButtonPanel.this.mediator.copyUnits(ActionButtonPanel.this.mediator.getSelectedUnits());
            }
        });
        this.pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionButtonPanel.this.mediator.pasteUnits();
            }
        });
        this.disconnectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HardwareUnit[] hardwareUnitArray = ActionButtonPanel.this.mediator.getSelectedUnits();
                ActionButtonPanel.this.mediator.disconnectUnits(hardwareUnitArray);
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HardwareUnit[] hardwareUnitArray = ActionButtonPanel.this.mediator.getSelectedUnits();
                ActionButtonPanel.this.mediator.deleteUnits(ActionButtonPanel.this.mediator.getSelectedUnits());
            }
        });
        this.adjustButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionButtonPanel.this.mediator.adjustUnitPositions(ActionButtonPanel.this.mediator.getSelectedUnits());
            }
        });
    }

    public static ActionButtonPanel getInstance() {
        return instance;
    }

    private ImageIcon newImageIcon(String string) {
        URL uRL = this.getClass().getClassLoader().getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return new ImageIcon();
    }

    private boolean saveXML() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showSaveDialog(null);
        if (n == 0) {
            Object object;
            try {
                object = new FileOutputStream(jFileChooser.getSelectedFile());
                this.mediator.printXML((OutputStream)object);
                ((FileOutputStream)object).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(jFileChooser, fileNotFoundException.toString());
                return false;
            }
            catch (SecurityException securityException) {
                JOptionPane.showMessageDialog(jFileChooser, securityException.toString());
                return false;
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(jFileChooser, iOException.toString());
                return false;
            }
            object = jFileChooser.getSelectedFile();
        } else {
            if (n == 1) {
                return false;
            }
            if (n == -1) {
                return false;
            }
        }
        return true;
    }

    private void setActionButtonEnabled(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11) {
        this.zoomInButton.setEnabled(bl);
        this.zoomOutButton.setEnabled(bl2);
        this.undoButton.setEnabled(bl3);
        this.redoButton.setEnabled(bl4);
        this.selectAllButton.setEnabled(bl5);
        this.cutButton.setEnabled(bl6);
        this.copyButton.setEnabled(bl7);
        this.pasteButton.setEnabled(bl8);
        this.adjustButton.setEnabled(bl9);
        this.disconnectButton.setEnabled(bl10);
        this.deleteButton.setEnabled(bl11);
    }

    public void updateButtonsState() {
        boolean bl;
        int n = this.mediator.getSelectedUnitsCount();
        boolean bl2 = this.mediator.getUnitsCount() != 0;
        boolean bl3 = bl = !this.mediator.copyBufferIsEmpty();
        if (n == 0) {
            this.setActionButtonEnabled(true, true, false, false, bl2, false, false, bl, false, false, false);
        } else if (n == 1) {
            this.setActionButtonEnabled(true, true, false, false, bl2, true, true, bl, true, false, true);
        } else {
            this.setActionButtonEnabled(true, true, false, false, bl2, true, true, bl, true, true, true);
        }
    }

    public void updateButtonsState(boolean bl) {
        this.setActionButtonEnabled(bl, bl, bl, bl, bl, bl, bl, bl, bl, bl, bl);
    }
}

