/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.architecturemaker;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JTextField;

class RoundedCornerTextField
extends JTextField {
    private static final float arcwidth = 8.0f;
    private static final float archeight = 8.0f;
    protected static final int focusstroke = 0;
    protected Shape shape;
    protected Shape border;
    protected Shape base;
    private Color borderColor;

    public RoundedCornerTextField(String string) {
        super(string);
        this.setBackground(new Color(255, 255, 255, 0));
        this.borderColor = Color.gray;
        this.setMargin(new Insets(3, 5, 3, 5));
        this.initShape();
    }

    protected void initShape() {
        if (!this.getBounds().equals(this.base)) {
            this.base = this.getBounds();
            this.shape = new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth() - 1, this.getHeight() - 1, 8.0f, 8.0f);
            this.border = new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth() - 1 - 0, this.getHeight() - 1 - 0, 8.0f, 8.0f);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics.setColor(Color.white);
        graphics.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 8, 8);
        this.borderColor = Color.gray;
        super.paintComponent(graphics2D);
    }

    @Override
    protected void paintBorder(Graphics graphics) {
        this.initShape();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.borderColor);
        graphics2D.draw(this.border);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    public boolean contains(int n, int n2) {
        this.initShape();
        return this.shape.contains(n, n2);
    }
}

