/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.architecturemaker.unit;

import java.util.ArrayList;
import java.util.regex.Pattern;
import net.wasamon.mics.architecturemaker.unit.AppearanceAttribute;
import net.wasamon.mics.architecturemaker.unit.MicsNode;

public abstract class HardwareUnit
extends MicsNode {
    AppearanceAttribute appearance;
    ArrayList<HardwareUnit> connectedUnits;

    public HardwareUnit(String string, String string2, int n, int n2, int n3, int n4, String string3) {
        this.appearance = new AppearanceAttribute(n, n2, n3, n4, string3);
        this.connectedUnits = new ArrayList();
        this.tag = "element";
        this.indent = "  ";
        this.setID(string);
        this.conditionTable.put("class", Pattern.compile(".{0}&&[^.]"));
        this.setUnitClass(string2);
        this.childList.add(this.appearance);
    }

    public boolean inRange(int n, int n2) {
        int n3 = this.appearance.getWidth();
        int n4 = this.appearance.getHeight();
        int n5 = this.appearance.getX() - n3 / 2;
        int n6 = this.appearance.getY() - n4 / 2;
        return n >= n5 && n < n5 + n3 && n2 >= n6 && n2 < n6 + n4;
    }

    public String getID() {
        return this.get("id");
    }

    public void setID(String string) {
        this.set("id", string);
    }

    public String getUnitClass() {
        return this.get("class");
    }

    private void setUnitClass(String string) {
        this.setValue("class", string);
    }

    public HardwareUnit[] getConnectedUnitList() {
        return this.connectedUnits.toArray(new HardwareUnit[this.connectedUnits.size()]);
    }

    public void setImage(String string) {
        this.appearance.set("image", string);
    }

    public String getImageFile() {
        return this.appearance.get("image");
    }

    public boolean isConnectedWith(HardwareUnit hardwareUnit) {
        return this.connectedUnits.contains(hardwareUnit);
    }

    public void disconnect(HardwareUnit hardwareUnit) {
        this.remove(hardwareUnit);
        hardwareUnit.remove(this);
        hardwareUnit.connectedUnits.remove(this);
        this.connectedUnits.remove(hardwareUnit);
    }

    public boolean connect(HardwareUnit hardwareUnit) {
        if (hardwareUnit == null || !this.isConnectable(hardwareUnit) || !hardwareUnit.isConnectable(this)) {
            return false;
        }
        if (this.isConnectedWith(hardwareUnit)) {
            return true;
        }
        this.register(hardwareUnit);
        hardwareUnit.register(this);
        this.connectedUnits.add(hardwareUnit);
        hardwareUnit.connectedUnits.add(this);
        return true;
    }

    public HardwareUnit getConnectedUnit(String string) {
        for (int i = 0; i < this.connectedUnits.size(); ++i) {
            HardwareUnit hardwareUnit = this.connectedUnits.get(i);
            if (!string.equals(hardwareUnit.getID())) continue;
            return hardwareUnit;
        }
        return null;
    }

    public abstract String getBaseID();

    public abstract void setBaseID(String var1);

    public abstract String getInformation();

    public abstract void register(HardwareUnit var1);

    public abstract void remove(HardwareUnit var1);

    public abstract boolean isConnectable(HardwareUnit var1);

    public abstract HardwareUnit copy();

    public ArrayList<HardwareUnit> connectedUnits() {
        return this.connectedUnits;
    }

    public AppearanceAttribute appearance() {
        return this.appearance;
    }
}

