/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.architecturemaker.unit;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import net.wasamon.mics.architecturemaker.unit.DataBuffer;
import net.wasamon.mics.architecturemaker.unit.HardwareUnit;
import net.wasamon.mics.architecturemaker.unit.InitAttribute;
import net.wasamon.mics.architecturemaker.unit.MicsNode;

public class HardwareUnitManager
extends MicsNode {
    private static final String[] month_string = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static HardwareUnitManager instance = new HardwareUnitManager();
    private ArrayList<HardwareUnit> rankingList = new ArrayList();
    private HashMap<String, Integer> serialTable = new HashMap();
    private HashMap<String, HardwareUnit> idTable = new HashMap();
    private int selectedUnitsCount = 0;

    private HardwareUnitManager() {
        this.tag = "mics";
        this.indent = "";
    }

    public static HardwareUnitManager getInstance() {
        return instance;
    }

    public void setValue(MicsNode micsNode, String string, String string2) {
        if (string.equals("id") && micsNode instanceof HardwareUnit) {
            if (this.uniqueID(string2)) {
                this.idTable.remove(((HardwareUnit)micsNode).getID());
                this.registerID((HardwareUnit)micsNode, string2);
            }
            return;
        }
        micsNode.set(string, string2);
    }

    public void addUnit(HardwareUnit hardwareUnit) {
        if (hardwareUnit.getID().equals("") || !this.uniqueID(hardwareUnit.getID())) {
            String string = this.getUniqueID(hardwareUnit.getBaseID(), hardwareUnit);
            this.registerID(hardwareUnit, string);
        } else {
            this.registerID(hardwareUnit, hardwareUnit.getID());
        }
        this.rankingList.add(hardwareUnit);
        this.childList.add(hardwareUnit);
    }

    public void deleteUnit(HardwareUnit hardwareUnit) {
        if (hardwareUnit == null) {
            return;
        }
        if (this.getUnitsCount() == 1) {
            this.clearAllUnits();
            return;
        }
        if (this.selectedUnit(hardwareUnit)) {
            --this.selectedUnitsCount;
        }
        this.rankingList.remove(hardwareUnit);
        this.childList.remove(hardwareUnit);
        this.idTable.remove(hardwareUnit.getID());
        for (int i = 0; i < this.childList.size(); ++i) {
            ((HardwareUnit)this.childList.get(i)).disconnect(hardwareUnit);
        }
    }

    public void deleteUnits(ArrayList<HardwareUnit> arrayList) {
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                this.deleteUnit(arrayList.get(i));
            }
        }
    }

    public void deleteUnits(HardwareUnit[] hardwareUnitArray) {
        if (hardwareUnitArray != null) {
            for (int i = 0; i < hardwareUnitArray.length; ++i) {
                this.deleteUnit(hardwareUnitArray[i]);
            }
        }
    }

    public void disconnectUnits(ArrayList<HardwareUnit> arrayList) {
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                for (int j = 0; j < arrayList.size(); ++j) {
                    arrayList.get(i).disconnect(arrayList.get(j));
                }
            }
        }
    }

    public void disconnectUnits(HardwareUnit[] hardwareUnitArray) {
        if (hardwareUnitArray != null) {
            for (int i = 0; i < hardwareUnitArray.length; ++i) {
                for (int j = 0; j < hardwareUnitArray.length; ++j) {
                    hardwareUnitArray[i].disconnect(hardwareUnitArray[j]);
                }
            }
        }
    }

    public void addInitFile(HardwareUnit hardwareUnit, String string, String string2) {
        if (hardwareUnit instanceof DataBuffer) {
            ((DataBuffer)((Object)hardwareUnit)).addInitFile(new StringBuilder(string), new StringBuilder(string2));
        }
    }

    public void registerID(HardwareUnit hardwareUnit, String string) {
        this.idTable.put(string, hardwareUnit);
        hardwareUnit.setID(string);
    }

    public boolean uniqueID(String string) {
        return !this.idTable.containsKey(string);
    }

    private String getUniqueID(String string, HardwareUnit hardwareUnit) {
        String string2;
        int n;
        int n2 = n = this.serialTable.containsKey(string) ? this.serialTable.get(string) : 0;
        while (!this.uniqueID(string2 = String.format("%s:%02d", string, n++))) {
        }
        this.serialTable.put(string, new Integer(n));
        return string2;
    }

    public HardwareUnit[] getAllUnits() {
        return this.rankingList.toArray(new HardwareUnit[this.getUnitsCount()]);
    }

    public void clearAllUnits() {
        this.childList.clear();
        this.serialTable.clear();
        this.idTable.clear();
        this.rankingList.clear();
        this.clearSelectedUnits();
    }

    public int getUnitsCount() {
        return this.childList.size();
    }

    public HardwareUnit getUnit(int n) {
        return (HardwareUnit)this.childList.get(n);
    }

    public HardwareUnit getUnit(String string) {
        return this.idTable.get(string);
    }

    public HardwareUnit[] getSelectedUnits() {
        HardwareUnit[] hardwareUnitArray = new HardwareUnit[this.selectedUnitsCount];
        for (int i = 0; i < this.selectedUnitsCount; ++i) {
            hardwareUnitArray[i] = this.rankingList.get(i);
        }
        return hardwareUnitArray;
    }

    public void clearSelectedUnits() {
        this.selectedUnitsCount = 0;
    }

    public void deselect(HardwareUnit hardwareUnit) {
        if (hardwareUnit == null || !this.selectedUnit(hardwareUnit)) {
            return;
        }
        this.rankingList.remove(hardwareUnit);
        this.rankingList.add(--this.selectedUnitsCount, hardwareUnit);
    }

    public void select(HardwareUnit hardwareUnit) {
        if (hardwareUnit == null || this.selectedUnit(hardwareUnit)) {
            return;
        }
        this.rankingList.remove(hardwareUnit);
        this.rankingList.add(0, hardwareUnit);
        ++this.selectedUnitsCount;
    }

    public void selectAll() {
        this.selectedUnitsCount = this.rankingList.size();
    }

    public int getSelectedUnitsCount() {
        return this.selectedUnitsCount;
    }

    public boolean selectedUnit(HardwareUnit hardwareUnit) {
        int n = this.rankingList.indexOf(hardwareUnit);
        return 0 <= n && n < this.selectedUnitsCount;
    }

    public void deleteSelectedUnits() {
        this.deleteUnits(this.getSelectedUnits());
    }

    HardwareUnit[] copy(HardwareUnit[] hardwareUnitArray) {
        MicsNode micsNode;
        int n;
        int n2;
        HardwareUnit[] hardwareUnitArray2 = new HardwareUnit[hardwareUnitArray.length];
        HashMap<HardwareUnit, HardwareUnit> hashMap = new HashMap<HardwareUnit, HardwareUnit>();
        for (n2 = 0; n2 < hardwareUnitArray.length; ++n2) {
            hardwareUnitArray2[n2] = hardwareUnitArray[n2].copy();
            hashMap.put(hardwareUnitArray[n2], hardwareUnitArray2[n2]);
        }
        for (n2 = 0; n2 < hardwareUnitArray.length; ++n2) {
            for (n = 0; n < hardwareUnitArray[n2].connectedUnits.size(); ++n) {
                micsNode = (HardwareUnit)hashMap.get(this.getUnit(hardwareUnitArray[n2].connectedUnits.get(n).getID()));
                if (micsNode == null) continue;
                hardwareUnitArray2[n2].connect((HardwareUnit)micsNode);
            }
        }
        for (n2 = 0; n2 < hardwareUnitArray.length; ++n2) {
            for (n = 0; n < hardwareUnitArray[n2].childList.size(); ++n) {
                micsNode = (MicsNode)hardwareUnitArray[n2].childList.get(n);
                if (!(micsNode instanceof InitAttribute)) continue;
                hardwareUnitArray2[n2].childList.add(new InitAttribute(new StringBuilder(micsNode.get("file")), new StringBuilder(micsNode.get("offset"))));
            }
        }
        return hardwareUnitArray2;
    }

    @Override
    public void printXML(OutputStream outputStream) throws IOException {
        outputStream.write(new String("<?xml version=\"1.0\" encoding=\"euc-jp\"?>\n").getBytes());
        super.printXML(outputStream);
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        outputStream.write(new String("<!-- Created by ArchitectureMaker 0.1.2 on " + month_string[n2 - 1] + " " + n3 + ", " + n + " -->\n").getBytes());
    }
}

