/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.architecturemaker.unit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import net.wasamon.mics.architecturemaker.unit.HardwareUnit;
import net.wasamon.mics.architecturemaker.unit.Mediator;
import net.wasamon.mics.architecturemaker.unit.MicsNode;

public class HardwareUnitPropertyTable
extends JPanel
implements CellEditorListener {
    private JTabbedPane tabbedPane;
    private ArrayList<MicsNode> nodeList;
    private ArrayList<JTable> tableList;
    private Mediator mediator;
    private static int count = 0;
    private static HardwareUnitPropertyTable instance = new HardwareUnitPropertyTable();

    private HardwareUnitPropertyTable() {
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1, 1);
        this.nodeList = new ArrayList();
        this.tableList = new ArrayList();
        this.mediator = Mediator.getInstance();
        this.add((Component)this.tabbedPane, "Center");
    }

    public static HardwareUnitPropertyTable getInstance() {
        return instance;
    }

    public void showPropertyTable() {
        if (this.mediator.getSelectedUnitsCount() == 1) {
            HardwareUnit hardwareUnit = this.mediator.getSelectedUnits()[0];
            int n = 0;
            if (this.nodeList.size() != 0 && this.nodeList.get(0) == hardwareUnit) {
                n = this.tabbedPane.getSelectedIndex();
            }
            this.tabbedPane.removeAll();
            this.nodeList.clear();
            this.tableList.clear();
            this.getProperty(hardwareUnit, this.tabbedPane, this.nodeList, this.tableList);
            if (0 <= n && n < this.tabbedPane.getTabCount()) {
                this.tabbedPane.setSelectedIndex(n);
            }
        } else {
            this.tabbedPane.removeAll();
            this.nodeList.clear();
            this.tableList.clear();
        }
    }

    private void getProperty(MicsNode micsNode, JTabbedPane jTabbedPane, ArrayList<MicsNode> arrayList, ArrayList<JTable> arrayList2) {
        JTable jTable = new JTable(micsNode.attributeTable.size(), 2);
        jTable.setTableHeader(null);
        jTable.getColumnModel().getColumn(0).setMinWidth(80);
        jTable.getColumnModel().getColumn(0).setMaxWidth(80);
        TableColumn tableColumn = ((DefaultTableColumnModel)jTable.getColumnModel()).getColumn(0);
        TableColumn tableColumn2 = ((DefaultTableColumnModel)jTable.getColumnModel()).getColumn(1);
        JTextField jTextField = new JTextField();
        jTextField.setEditable(false);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jTextField);
        DefaultCellEditor defaultCellEditor2 = new DefaultCellEditor(new JTextField());
        defaultCellEditor2.addCellEditorListener(this);
        defaultCellEditor2.setClickCountToStart(1);
        defaultCellEditor.setClickCountToStart(1);
        tableColumn.setCellEditor(defaultCellEditor);
        tableColumn2.setCellEditor(defaultCellEditor2);
        jTable.putClientProperty("terminateEditOnFocusLost", true);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        Iterator<Map.Entry<String, StringBuilder>> iterator = micsNode.attributeTable.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, StringBuilder> entry = iterator.next();
            jTable.setValueAt(entry.getKey(), n, 0);
            jTable.setValueAt(entry.getValue().toString(), n, 1);
            ++n;
        }
        jTabbedPane.add(micsNode.getTag(), jScrollPane);
        arrayList.add(micsNode);
        arrayList2.add(jTable);
        for (int i = 0; i < micsNode.childList.size(); ++i) {
            MicsNode micsNode2 = micsNode.childList.get(i);
            this.getProperty(micsNode2, jTabbedPane, arrayList, arrayList2);
        }
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        for (int i = 0; i < this.nodeList.size(); ++i) {
            MicsNode micsNode = this.nodeList.get(i);
            JTable jTable = this.tableList.get(i);
            for (int j = 0; j < jTable.getRowCount(); ++j) {
                String string = (String)jTable.getValueAt(j, 0);
                String string2 = (String)jTable.getValueAt(j, 1);
                if (micsNode.get(string).equals(string2)) continue;
                this.mediator.setValue(micsNode, string, string2);
                jTable.setValueAt(micsNode.get(string), j, 1);
            }
        }
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }
}

