/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.architecturemaker.unit;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class MicsNode {
    HashMap<String, StringBuilder> attributeTable;
    HashMap<String, Pattern> conditionTable;
    ArrayList<MicsNode> childList;
    String tag = new String();
    String indent = new String();

    public MicsNode() {
        this.attributeTable = new HashMap();
        this.conditionTable = new HashMap();
        this.childList = new ArrayList();
    }

    public String get(String string) {
        return this.getValue(string).toString();
    }

    public void set(String string, String string2) {
        if (this.check(string, string2)) {
            this.setValue(string, string2);
        }
    }

    public boolean check(String string, String string2) {
        Pattern pattern = this.conditionTable.get(string);
        if (pattern == null) {
            return true;
        }
        return pattern.matcher(string2).matches();
    }

    protected StringBuilder getValue(String string) {
        return this.attributeTable.get(string);
    }

    protected void setValue(String string, String string2) {
        if (this.attributeTable.get(string) == null) {
            this.attributeTable.remove(string);
            this.attributeTable.put(string, new StringBuilder(string2));
            return;
        }
        StringBuilder stringBuilder = this.attributeTable.get(string);
        stringBuilder.delete(0, stringBuilder.length());
        stringBuilder.append(string2);
    }

    protected void setValue(String string, StringBuilder stringBuilder) {
        this.attributeTable.remove(string);
        this.attributeTable.put(string, stringBuilder);
    }

    public void printXML(OutputStream outputStream) throws IOException {
        String string = "";
        string = string + this.indent + "<" + this.tag;
        for (Map.Entry<String, StringBuilder> entry : this.attributeTable.entrySet()) {
            string = string + " " + entry.getKey() + "=\"" + entry.getValue() + "\"";
        }
        if (this.childList.size() == 0) {
            string = string + "/>\n";
            outputStream.write(string.getBytes());
            return;
        }
        string = string + ">\n";
        outputStream.write(string.getBytes());
        for (int i = 0; i < this.childList.size(); ++i) {
            MicsNode micsNode = this.childList.get(i);
            micsNode.printXML(outputStream);
        }
        string = this.indent + "</" + this.tag + ">\n";
        outputStream.write(string.getBytes());
    }

    public String getTag() {
        return this.tag;
    }

    public void removeChild(String string) {
        if (string == null) {
            return;
        }
        for (int i = 0; i < this.childList.size(); ++i) {
            MicsNode micsNode = this.childList.get(i);
            String string2 = micsNode.tag + " ";
            for (Map.Entry<String, StringBuilder> entry : micsNode.attributeTable.entrySet()) {
                string2 = string2 + entry.getKey() + "=\"" + entry.getValue() + "\" ";
            }
            if (!string.equals(string2)) continue;
            this.childList.remove(micsNode);
            return;
        }
    }

    public ArrayList<MicsNode> childList() {
        return this.childList;
    }

    public HashMap<String, StringBuilder> attributeTable() {
        return this.attributeTable;
    }
}

