/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.architecturemaker.unit;

import java.util.regex.Pattern;
import net.wasamon.mics.architecturemaker.unit.Channel;
import net.wasamon.mics.architecturemaker.unit.DataBuffer;
import net.wasamon.mics.architecturemaker.unit.HardwareUnit;
import net.wasamon.mics.architecturemaker.unit.InitAttribute;

public class RandomAccessMemory
extends HardwareUnit
implements DataBuffer {
    private static String baseID = "mem";
    private static String defaultImageFile = "icons/unit/pp_memory1_1.gif";

    public RandomAccessMemory(String string, int n, int n2) {
        super(string, "net.wasamon.mics.memory.RandomAccessMemory", n, n2, 40, 40, defaultImageFile);
        this.conditionTable.put("size", Pattern.compile("\\p{Digit}+|^0x\\p{XDigit}+"));
        this.setValue("size", "0x1000");
    }

    @Override
    public String getBaseID() {
        return baseID;
    }

    @Override
    public void setBaseID(String string) {
        baseID = string;
    }

    public static String getDefaultImageFile() {
        return defaultImageFile;
    }

    @Override
    public void addInitFile(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        this.childList.add(new InitAttribute(stringBuilder, stringBuilder2));
    }

    @Override
    public String getInformation() {
        return "";
    }

    @Override
    public void register(HardwareUnit hardwareUnit) {
    }

    @Override
    public void remove(HardwareUnit hardwareUnit) {
    }

    @Override
    public boolean isConnectable(HardwareUnit hardwareUnit) {
        return hardwareUnit instanceof Channel;
    }

    @Override
    public HardwareUnit copy() {
        RandomAccessMemory randomAccessMemory = new RandomAccessMemory(this.getID(), this.appearance.getX(), this.appearance.getY());
        randomAccessMemory.appearance.setSize(this.appearance.getWidth(), this.appearance.getHeight());
        randomAccessMemory.appearance.set("image", this.appearance.get("image"));
        return randomAccessMemory;
    }
}

