/*
 * Decompiled with CFR 0.152.
 */
package coins;

import coins.IoRoot;
import coins.driver.CompileSpecification;
import coins.driver.Trace;

public class Debug {
    private final IoRoot fIoRoot;
    private int fDebugLevel;
    private String fHeader;

    public Debug(IoRoot pIoRoot) {
        this.fIoRoot = pIoRoot;
    }

    public Debug(IoRoot pIoRoot, String pHeader, int pDebugLevel) {
        this.fIoRoot = pIoRoot;
        this.fHeader = pHeader;
        this.fDebugLevel = pDebugLevel;
    }

    public void initiate() {
        int lPara1;
        int lOpt1;
        int lToLir;
        int lToHir;
        int lParse;
        int lAlias;
        int lFlow;
        int lSym;
        int lHir;
        int lControl;
        CompileSpecification lSpec = this.fIoRoot.getCompileSpecification();
        if (lSpec != null) {
            Trace lTrace = lSpec.getTrace();
            lControl = lTrace.getTraceLevel("Control");
            lHir = lTrace.getTraceLevel("HIR");
            int lLir = lTrace.getTraceLevel("LIR");
            lSym = lTrace.getTraceLevel("Sym");
            lFlow = lTrace.getTraceLevel("Flow");
            lAlias = lTrace.getTraceLevel("Alias");
            lParse = lTrace.getTraceLevel("Parse");
            lToHir = lTrace.getTraceLevel("ToHir");
            lToLir = lTrace.getTraceLevel("ToLir");
            lOpt1 = lTrace.getTraceLevel("Opt1");
            lPara1 = lTrace.getTraceLevel("Para1");
        } else {
            lControl = 0;
            lHir = 0;
            boolean lLir = false;
            lSym = 0;
            lFlow = 0;
            lAlias = 0;
            lParse = 0;
            lToHir = 0;
            lToLir = 0;
            lOpt1 = 0;
            lPara1 = 0;
            boolean lReg = false;
            boolean bl = false;
        }
        this.fIoRoot.dbgControl = new Debug(this.fIoRoot, "DBGC", lControl);
        this.fIoRoot.dbgHir = new Debug(this.fIoRoot, "DBGH", lHir);
        this.fIoRoot.dbgSym = new Debug(this.fIoRoot, "DBGS", lSym);
        this.fIoRoot.dbgFlow = new Debug(this.fIoRoot, "DBGF", lFlow);
        this.fIoRoot.dbgAlias = new Debug(this.fIoRoot, "DBGA", lAlias);
        this.fIoRoot.dbgParse = new Debug(this.fIoRoot, "DBGP", lParse);
        this.fIoRoot.dbgToHir = new Debug(this.fIoRoot, "DBGtoH", lToHir);
        this.fIoRoot.dbgToLir = new Debug(this.fIoRoot, "DBGtoL", lToLir);
        this.fIoRoot.dbgOpt1 = new Debug(this.fIoRoot, "DBGO1", lOpt1);
        this.fIoRoot.dbgPara1 = new Debug(this.fIoRoot, "DBGP1", lPara1);
    }

    public void print(int pLevel, String pAt, String pMessage) {
        if (pLevel <= this.fDebugLevel) {
            this.fIoRoot.printOut.print("\n" + this.fHeader + " " + pAt + " " + pMessage);
        }
    }

    public void print(int pLevel, String pMessage) {
        if (pLevel <= this.fDebugLevel) {
            this.fIoRoot.printOut.print(" " + pMessage);
        }
    }

    public void println(int pLevel) {
        if (pLevel <= this.fDebugLevel) {
            this.fIoRoot.printOut.print("\n");
        }
    }

    public void printObject(int pLevel, String pHeader, Object pObject) {
        if (pLevel <= this.fDebugLevel) {
            if (pObject != null) {
                this.fIoRoot.printOut.print(" " + pHeader + " " + pObject.toString());
            } else {
                this.fIoRoot.printOut.print(" " + pHeader + " null");
            }
        }
    }

    public void setLevel(int pLevel) {
        this.fDebugLevel = pLevel;
    }

    public int getLevel() {
        return this.fDebugLevel;
    }
}

