/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.aflow.BBlock;
import coins.aflow.DefVector;
import coins.aflow.FlowAdapter;
import coins.aflow.FlowResults;
import coins.aflow.SetRefRepr;
import coins.aflow.SetRefReprIterator;
import coins.aflow.SetRefReprList;
import coins.aflow.SubpFlow;
import coins.aflow.util.FAList;
import coins.alias.RecordAlias;
import coins.sym.FlowAnalSym;
import java.util.Iterator;
import java.util.ListIterator;

public abstract class FindKill
extends FlowAdapter {
    public FindKill(FlowResults pResults) {
        super(pResults);
    }

    public void find(SubpFlow pSubpFlow) {
        Iterator lIt = pSubpFlow.getBBlocks().iterator();
        while (lIt.hasNext()) {
            this.find((BBlock)lIt.next());
        }
    }

    public void find(BBlock pBBlock) {
        SubpFlow lSubpFlow = pBBlock.getSubpFlow();
        DefVector lDefVect = lSubpFlow.defVector();
        SetRefReprList lSetRefReprs = pBBlock.getSetRefReprs();
        FAList lSetReprs = lSubpFlow.getSetRefReprs();
        SetRefRepr lFirst = null;
        SetRefRepr lLast = null;
        SetRefReprIterator lIt = pBBlock.getSetRefReprs().setRefReprIterator();
        while (lIt.hasNext()) {
            SetRefRepr lSetRefRepr = (SetRefRepr)lIt.next();
            if (!lSetRefRepr.sets()) continue;
            if (lFirst == null) {
                lFirst = lSetRefRepr;
            }
            lDefVect.vectorOr(this.getKill(lSetRefRepr), lDefVect);
            lLast = lSetRefRepr;
        }
        if (lFirst != null) {
            for (int lIndex = lSetReprs.indexOf(lFirst); lIndex <= lSetReprs.indexOf(lLast); ++lIndex) {
                lDefVect.resetBit(lIndex);
            }
        }
        this.register(pBBlock, lDefVect);
    }

    public void find(SetRefRepr pSetRefRepr) {
        SubpFlow lSubpFlow = pSetRefRepr.getBBlock().getSubpFlow();
        FlowAnalSym lDefFlowAnalSym = pSetRefRepr.defSym();
        DefVector lDefVect = lSubpFlow.defVector();
        FAList lSetRefReprs = lSubpFlow.getSetRefReprs();
        ListIterator lIt = lSetRefReprs.listIterator();
        while (lIt.hasNext()) {
            SetRefRepr lSetRefRepr = (SetRefRepr)lIt.next();
            if (!this.kills(pSetRefRepr, lSetRefRepr)) continue;
            int i = lIt.previousIndex();
            lDefVect.setBit(i);
        }
        lDefVect.resetBit(lSetRefReprs.indexOf(pSetRefRepr));
        this.flow.dbg(6, this.getClass() + ": Kill for " + pSetRefRepr + "\n", lDefVect.toStringDescriptive());
        this.register(pSetRefRepr, lDefVect);
    }

    protected abstract boolean killsByAlias(SetRefRepr var1, SetRefRepr var2, RecordAlias var3);

    protected abstract DefVector getKill(SetRefRepr var1);

    protected abstract boolean kills(SetRefRepr var1, SetRefRepr var2);

    protected abstract void register(SetRefRepr var1, DefVector var2);

    protected abstract void register(BBlock var1, DefVector var2);
}

