/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.aflow.BBlock;
import coins.aflow.FlowAdapter;
import coins.aflow.FlowAnalSymVector;
import coins.aflow.FlowResults;
import coins.aflow.FlowUtil;
import coins.aflow.SetRefRepr;
import coins.aflow.SetRefReprList;
import coins.aflow.SubpFlow;
import java.util.Iterator;
import java.util.List;

public abstract class FindLiveInLiveOut
extends FlowAdapter {
    public FindLiveInLiveOut(FlowResults pResults) {
        super(pResults);
    }

    public void find(SubpFlow pSubpFlow) {
        boolean lChanged;
        FlowAnalSymVector lLiveOut;
        List lBBlocks = pSubpFlow.getBBlocksFromEntry();
        FlowAnalSymVector lSurvived = pSubpFlow.flowAnalSymVector();
        FlowAnalSymVector lSuccLiveIn = pSubpFlow.flowAnalSymVector();
        for (BBlock lBBlock : pSubpFlow.getBBlocks()) {
            lLiveOut = lBBlock.isExitBBlock() ? FlowUtil.staticSymVector(pSubpFlow) : pSubpFlow.flowAnalSymVector();
            this.registerLiveOut(lBBlock, lLiveOut);
        }
        do {
            lChanged = false;
            Iterator lCFGIterator = lBBlocks.listIterator(lBBlocks.size());
            while (lCFGIterator.hasPrevious()) {
                BBlock lBBlock;
                lBBlock = (BBlock)lCFGIterator.previous();
                if (lBBlock.isExitBBlock()) continue;
                FlowAnalSymVector lNewLiveOut = pSubpFlow.flowAnalSymVector();
                List lSuccList = lBBlock.getSuccList();
                for (BBlock lSuccBBlock : lSuccList) {
                    FlowAnalSymVector lSuccExposed = this.getExposed(lSuccBBlock);
                    FlowAnalSymVector lSuccDefined = this.getDefined(lSuccBBlock);
                    FlowAnalSymVector lSuccLiveOut = this.getLiveOut(lSuccBBlock);
                    lSuccLiveOut.vectorSub(lSuccDefined, lSurvived);
                    lSuccExposed.vectorOr(lSurvived, lSuccLiveIn);
                    lNewLiveOut.vectorOr(lSuccLiveIn, lNewLiveOut);
                }
                if (lNewLiveOut.vectorEqual(this.getLiveOut(lBBlock))) continue;
                lChanged = true;
                this.registerLiveOut(lBBlock, lNewLiveOut);
            }
        } while (lChanged);
        for (BBlock lBBlock : lBBlocks) {
            FlowAnalSymVector lExposed = this.getExposed(lBBlock);
            FlowAnalSymVector lDefined = this.getDefined(lBBlock);
            lLiveOut = this.getLiveOut(lBBlock);
            lLiveOut.vectorSub(lDefined, lSurvived);
            FlowAnalSymVector lLiveIn = pSubpFlow.flowAnalSymVector();
            lExposed.vectorOr(lSurvived, lLiveIn);
            this.registerLiveIn(lBBlock, lLiveIn);
        }
    }

    public void find(BBlock pBBlock) {
        this.find(pBBlock.getSubpFlow());
    }

    protected abstract FlowAnalSymVector getExposed(BBlock var1);

    protected abstract FlowAnalSymVector getDefined(BBlock var1);

    protected abstract FlowAnalSymVector getLiveOut(BBlock var1);

    protected abstract void registerLiveIn(BBlock var1, FlowAnalSymVector var2);

    protected abstract void registerLiveOut(BBlock var1, FlowAnalSymVector var2);

    public void find(SetRefRepr pSetRefRepr) {
        BBlock lBBlock = pSetRefRepr.getBBlock();
        SetRefReprList lSetRefReprs = lBBlock.getSetRefReprs();
        SubpFlow lSubpFlow = lBBlock.getSubpFlow();
        FlowAnalSymVector lLiveOut = this.flow.flowAnalSymVector(lSubpFlow);
        if (lSetRefReprs.isEmpty()) {
            this.getLiveOut(lBBlock).vectorCopy(lLiveOut);
        } else if (lSetRefReprs.get(lSetRefReprs.size() - 1) == pSetRefRepr) {
            this.getLiveOut(lBBlock).vectorCopy(lLiveOut);
        } else {
            SetRefRepr lNextSetRefRepr = (SetRefRepr)lSetRefReprs.get(lSetRefReprs.indexOf(pSetRefRepr) + 1);
            FlowAnalSymVector lNextLiveOut = this.getLiveOut(lNextSetRefRepr);
            lNextLiveOut.vectorSub(this.getDefined(lNextSetRefRepr), lLiveOut);
            lNextLiveOut.vectorOr(this.getExposed(lNextSetRefRepr), lLiveOut);
        }
        this.register(pSetRefRepr, lLiveOut);
    }

    protected abstract FlowAnalSymVector getExposed(SetRefRepr var1);

    protected abstract FlowAnalSymVector getDefined(SetRefRepr var1);

    protected abstract FlowAnalSymVector getLiveOut(SetRefRepr var1);

    protected abstract void register(SetRefRepr var1, FlowAnalSymVector var2);
}

