/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.aflow.BBlock;
import coins.aflow.DefVector;
import coins.aflow.FlowAdapter;
import coins.aflow.FlowResults;
import coins.aflow.SetRefRepr;
import coins.aflow.SetRefReprList;
import coins.aflow.SubpFlow;
import java.util.Iterator;
import java.util.List;

public abstract class FindReach
extends FlowAdapter {
    public FindReach(FlowResults pResults) {
        super(pResults);
    }

    public void find(SubpFlow pSubpFlow) {
        boolean lChanged;
        DefVector lSurvived = pSubpFlow.defVector();
        DefVector lPredReachOut = pSubpFlow.defVector();
        for (BBlock lBBlock : pSubpFlow.getBBlocks()) {
            DefVector lReach = pSubpFlow.defVector();
            this.register(lBBlock, lReach);
        }
        do {
            lChanged = false;
            Iterator lCFGIterator = pSubpFlow.getBBlocksFromEntry().iterator();
            while (lCFGIterator.hasNext()) {
                BBlock lBBlock;
                DefVector lNewReach = pSubpFlow.defVector();
                lBBlock = (BBlock)lCFGIterator.next();
                List lPredList = lBBlock.getPredList();
                for (BBlock lPredBBlock : lPredList) {
                    DefVector lPredDef = this.getDef(lPredBBlock);
                    DefVector lPredKill = this.getKill(lPredBBlock);
                    DefVector lPredReach = this.getReach(lPredBBlock);
                    lPredReach.vectorSub(lPredKill, lSurvived);
                    lPredDef.vectorOr(lSurvived, lPredReachOut);
                    lNewReach.vectorOr(lPredReachOut, lNewReach);
                }
                if (lNewReach.vectorEqual(this.getReach(lBBlock))) continue;
                lChanged = true;
                this.register(lBBlock, lNewReach);
            }
        } while (lChanged);
    }

    public void find(BBlock pBBlock) {
        this.find(pBBlock.getSubpFlow());
    }

    public void find(SetRefRepr pSetRefRepr) {
        BBlock lBBlock = pSetRefRepr.getBBlock();
        SetRefReprList lSetRefReprs = lBBlock.getSetRefReprs();
        SubpFlow lSubpFlow = lBBlock.getSubpFlow();
        DefVector lPrevSurvived = lSubpFlow.defVector();
        DefVector lReach = lSubpFlow.defVector();
        if (lSetRefReprs.isEmpty()) {
            this.getReach(lBBlock).vectorCopy(lReach);
        } else if (lBBlock.getSetRefReprs().get(0) == pSetRefRepr) {
            this.getReach(lBBlock).vectorCopy(lReach);
        } else {
            SetRefRepr lPrevSetRefRepr = (SetRefRepr)lSetRefReprs.get(lSetRefReprs.indexOf(pSetRefRepr) - 1);
            DefVector lPrevReach = this.getReach(lPrevSetRefRepr);
            lPrevReach.vectorSub(this.getKill(lPrevSetRefRepr), lPrevSurvived);
            if (this.defs(lPrevSetRefRepr)) {
                lPrevSurvived.setBit(lSubpFlow.getSetRefReprs().indexOf(lPrevSetRefRepr));
            }
            lReach = lPrevSurvived;
        }
        this.register(pSetRefRepr, lReach);
    }

    protected abstract boolean defs(SetRefRepr var1);

    protected abstract DefVector getDef(BBlock var1);

    protected abstract DefVector getKill(BBlock var1);

    protected abstract DefVector getReach(BBlock var1);

    protected abstract void register(BBlock var1, DefVector var2);

    protected abstract DefVector getKill(SetRefRepr var1);

    protected abstract DefVector getReach(SetRefRepr var1);

    protected abstract void register(SetRefRepr var1, DefVector var2);
}

