/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.IoRoot;
import coins.SymRoot;
import coins.aflow.DefUseList;
import coins.aflow.FlowExpId;
import coins.aflow.FlowResults;
import coins.aflow.SubpFlow;
import coins.aflow.SubpFlowImpl;
import coins.aflow.UDList;
import coins.aflow.util.FlowError;
import coins.ir.IR;
import coins.sym.ExpId;
import coins.sym.ExpIdImpl;
import coins.sym.FlowAnalSym;
import coins.sym.Sym;
import java.util.HashSet;
import java.util.Set;

public abstract class HashBasedFlowExpId
implements FlowExpId {
    private HashBasedFlowExpId fNext;
    private final IR fLinkedNode;
    final int fIndex;
    protected FlowResults fResults;
    protected final IoRoot ioRoot;
    protected final SymRoot symRoot;
    int fOperationCount;
    final Set fOperandSet = new HashSet();
    final Set fOperandSet0 = new HashSet();
    protected SubpFlow fSubpFlow;
    protected IR fTree;
    protected boolean fHasCall;
    protected boolean fLHS = false;
    protected ExpId fExpId;

    HashBasedFlowExpId(IR pNode, int pIndex, SubpFlow pSubpFlow) {
        this.symRoot = ((SubpFlowImpl)pSubpFlow).symRoot;
        this.ioRoot = this.symRoot.ioRoot;
        this.fSubpFlow = pSubpFlow;
        this.fLinkedNode = pNode;
        this.fIndex = pIndex;
        this.fResults = this.fSubpFlow.results();
        this.operandInfo(pNode);
        String lExpIdName = this.generateExpIdName(pIndex);
        this.fExpId = (ExpIdImpl)this.symRoot.symTableCurrent.searchOrAdd(lExpIdName, 17, this.symRoot.subpCurrent, true, true);
        this.fExpId.setFlowExpId(this);
    }

    protected HashBasedFlowExpId getNextInChain() {
        return this.fNext;
    }

    protected void setNextInChain(HashBasedFlowExpId pNext) {
        this.fNext = pNext;
    }

    public IR getLinkedNode() {
        return this.fLinkedNode;
    }

    public IR getTree() {
        return this.fTree;
    }

    public int getIndex() {
        return this.fIndex;
    }

    public Set getOperandSet() {
        return this.fOperandSet;
    }

    public Set getOperandSet0() {
        return this.fOperandSet0;
    }

    public abstract void operandInfo(IR var1);

    public String toString() {
        StringBuffer lBuffer = new StringBuffer();
        lBuffer.append("FlowExpId " + this.fIndex + " " + this.fTree);
        return lBuffer.toString();
    }

    public int getNumberOfOperations() {
        return this.fOperationCount;
    }

    private static int getNumberOfOperationsUnder(IR pIR, int pAccumulatedCount) {
        throw new FlowError();
    }

    public DefUseList getDefUseList() {
        return (DefUseList)this.fResults.get("DefUseList0", this, this.fSubpFlow);
    }

    public UDList getUDList() {
        return (UDList)this.fResults.get("UDList0", this);
    }

    public SubpFlow getSubpFlow() {
        return this.fSubpFlow;
    }

    public boolean hasCall() {
        return this.fHasCall;
    }

    protected String generateExpIdName(int pIndex) {
        String lNameExtended;
        boolean lFound = false;
        String lIndexString = Integer.toString(pIndex, 10);
        String lName = ("_xId" + lIndexString).intern();
        Sym lSym = ((SubpFlowImpl)this.fSubpFlow).symRoot.symTableCurrent.searchLocal(lName, 0, false);
        if (lSym != null && lSym instanceof ExpId) {
            ((FlowAnalSym)lSym).resetFlowAnalInf();
            return lName;
        }
        int lExpIdSuffix = 1;
        while (!lFound && (lSym = ((SubpFlowImpl)this.fSubpFlow).symRoot.symTableCurrent.searchLocal(lNameExtended = (lName + "_" + Integer.toString(lExpIdSuffix, 10)).intern(), 0, false)) != null) {
            if (lSym instanceof ExpId) {
                ((FlowAnalSym)lSym).resetFlowAnalInf();
                break;
            }
            ++lExpIdSuffix;
        }
        return lName;
    }

    public ExpId getExpId() {
        return this.fExpId;
    }

    public void setLHSFlag() {
        this.fLHS = true;
    }

    public boolean isLHS() {
        return this.fLHS;
    }
}

