/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.aflow.AssignFlowExpId;
import coins.aflow.AssignHashBasedFlowExpIdHir;
import coins.aflow.BBlock;
import coins.aflow.BBlockHir;
import coins.aflow.BBlockStmtIterator;
import coins.aflow.BBlockSubtreeIterator;
import coins.aflow.FlowResults;
import coins.aflow.FlowUtil;
import coins.aflow.HashBasedFlowExpIdHir;
import coins.aflow.HirSubpFlow;
import coins.aflow.MakeControlFlowGraphHir;
import coins.aflow.RecordSetRefReprsHir;
import coins.aflow.SetRefRepr;
import coins.aflow.SetRefReprHirEImpl;
import coins.aflow.SetRefReprListHir;
import coins.aflow.SubpFlow;
import coins.aflow.SubpFlowImpl;
import coins.aflow.util.FAList;
import coins.ir.hir.HIR;
import coins.ir.hir.HirIterator;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SubpDefinitionImpl;
import java.util.List;

public class HirSubpFlowImpl
extends SubpFlowImpl
implements HirSubpFlow {
    private static final Class flowExpIdClass = HashBasedFlowExpIdHir.class;

    public HirSubpFlowImpl(SubpDefinition pSubpDefinition, FlowResults pResults) {
        super(pSubpDefinition, pResults);
        this.flowRoot.setHirAnalysis();
        this.flowRoot.subpFlow = this;
        this.flowRoot.aflow.dbg(1, "\nHirSubpFlowImpl ", pSubpDefinition.getSubpSym().toString());
        this.fIrIndexMin = ((SubpDefinitionImpl)pSubpDefinition).fNodeIndexMin;
        this.fIrIndexMax = ((SubpDefinitionImpl)pSubpDefinition).fNodeIndexMax;
        this.fIrIndexMin = 0;
        this.flowRoot.aflow.dbg(2, "IndexMin=" + this.fIrIndexMin, " IndexMax=" + this.fIrIndexMax);
        if (!pResults.containsKey("SetRefReprTable", pSubpDefinition)) {
            pResults.put("SetRefReprTable", pSubpDefinition, new SetRefRepr[this.fIrIndexMax - this.fIrIndexMin + 1]);
            this.fSetRefReprTable = (SetRefRepr[])pResults.get("SetRefReprTable", pSubpDefinition);
            this.fRecordSetRefReprs = new RecordSetRefReprsHir(pResults);
        }
    }

    protected HirSubpFlowImpl(FlowResults pResults, SubpDefinition pSubpDef) {
        this(pSubpDef, pResults);
    }

    public BBlockSubtreeIterator bblockSubtreeIterator(BBlock pBBlock) {
        return new BBlockStmtIterator((BBlockHir)pBBlock);
    }

    public List controlFlowAnal() {
        this.flowRoot.aflow.dbg(2, "controlFlowAnal", this.fSubpDefinition.getSubpSym().getName());
        new MakeControlFlowGraphHir(this.fResults).find(this);
        return this.fReachableBBlocks;
    }

    public void correlateBBlockAndIR() {
        SubpDefinition lSubpDef = this.getSubpDefinition();
        BBlockHir lCurrentBBlock = (BBlockHir)this.fResults.getBBlockForLabel(lSubpDef.getStartLabel());
        if (lSubpDef.getNodeIndexMax() == 0) {
            this.flowRoot.aflow.dbg(2, "\n Index is not yet assigned. Assign it.");
            lSubpDef.setIndexNumberToAllNodes(((SubpDefinitionImpl)lSubpDef).fNodeIndexMin);
            this.allocateBBlockOfIR();
        }
        this.flowRoot.aflow.dbg(2, "\ncorrelateBBlockAndIR", "indexMax " + this.fIrIndexMax + " BBlock " + lCurrentBBlock);
        HirIterator lHirIterator = FlowUtil.hirIterator(lSubpDef.getHirBody());
        while (lHirIterator.hasNext()) {
            HIR lNode = lHirIterator.next();
            if (lNode instanceof LabeledStmt) {
                BBlockHir lBBlock = (BBlockHir)this.fResults.getBBlockForLabel(((LabeledStmt)lNode).getLabel());
                this.flowRoot.aflow.dbg(3, "\n  " + ((Object)lNode).toString(), "BBlock " + lBBlock);
                if (lBBlock != null) {
                    lCurrentBBlock = lBBlock;
                }
            }
            if (lNode == null) continue;
            this.setBBlockOfIR(lCurrentBBlock, lNode.getIndex());
        }
    }

    public void computeBBlockSetRefReprs(SubpFlow pSubpFlow) {
        this.flowRoot.aflow.dbg(4, "\ncomputeBBlockSetRefReprs");
        FAList lBBlockTable = pSubpFlow.getBBlockTable();
        for (BBlockHir lBBlock : lBBlockTable) {
            LabeledStmt lStmt = (LabeledStmt)lBBlock.getIrLink();
            this.flowRoot.aflow.dbg(4, " BBlock", lBBlock.toString() + " " + lStmt.toString());
            SetRefReprListHir lSetRefReprList = new SetRefReprListHir(lBBlock);
            SetRefReprHirEImpl lSetRefRepr = new SetRefReprHirEImpl(lStmt, lBBlock, false, null);
            lSetRefReprList.add(lSetRefRepr);
            pSubpFlow.results().put("BBlockSetRefReprs", lBBlock, lSetRefReprList);
            pSubpFlow.setSetRefReprOfIR(lSetRefRepr, lStmt.getIndex());
        }
    }

    public void clear() {
        super.clear();
        SubpDefinition lSubpDef = this.getSubpDefinition();
        this.flowRoot.aflow.dbg(2, "Clear ExpId ");
        int lIndexMin = this.getIrIndexMin();
        int lIndexMax = this.getIrIndexMax();
        for (int lIndex = lIndexMin; lIndex < lIndexMax; ++lIndex) {
            this.fExpIdTable[lIndex - lIndexMin] = null;
        }
    }

    public AssignFlowExpId assigner() {
        AssignHashBasedFlowExpIdHir lAssigner = (AssignHashBasedFlowExpIdHir)this.fResults.getRaw("AssignerForSubpFlow", this);
        if (lAssigner == null) {
            return this.flow.assigner(this);
        }
        return lAssigner;
    }
}

