/*
 * Decompiled with CFR 0.152.
 */
package coins.alias;

import coins.IoRoot;
import coins.SymRoot;
import coins.alias.AliasError;
import coins.ir.hir.HIR;
import coins.sym.BaseType;
import coins.sym.Elem;
import coins.sym.PointerType;
import coins.sym.StructType;
import coins.sym.Subp;
import coins.sym.SubpType;
import coins.sym.Type;
import coins.sym.UnionType;
import coins.sym.VectorType;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;

public class AliasUtil {
    public final SymRoot symRoot;
    public final IoRoot io;

    public AliasUtil(SymRoot pSymRoot) {
        this.symRoot = pSymRoot;
        this.io = this.symRoot.ioRoot;
    }

    public static boolean ismalloc(Subp pSubp) {
        return pSubp.getName().equals("malloc") && (pSubp.getVisibility() == 1 || pSubp.getVisibility() == 2);
    }

    public static boolean isPredefined(Subp pSubp, Set pPredefined) {
        return pPredefined.contains(pSubp.getName()) && (pSubp.getVisibility() == 1 || pSubp.getVisibility() == 2);
    }

    public boolean mayAlias(Type pType, Type pType0) {
        return this.mayAliasBareAndSigned(this.toBareAndSigned(pType), this.toBareAndSigned(pType0));
    }

    private boolean mayAliasBareAndSigned(Type pType, Type pType0) {
        int lKind = pType.getTypeKind();
        int lKind0 = pType0.getTypeKind();
        if (pType.isBasicType() || lKind == 22) {
            if (pType0.isBasicType() || lKind0 == 22) {
                return lKind == 7 || lKind0 == 7 || this.areCompatible(pType, pType0);
            }
            return this.mayAliasBareAndSigned(pType0, pType);
        }
        switch (lKind) {
            case 23: {
                return this.mayAliasBareAndSigned(pType0, this.toBareAndSigned(((VectorType)pType).getElemType()));
            }
            case 24: {
                ListIterator lIt = ((StructType)pType).getElemList().iterator();
                while (lIt.hasNext()) {
                    if (!this.mayAliasBareAndSigned(pType0, this.toBareAndSigned(((Elem)lIt.next()).getSymType()))) continue;
                    return true;
                }
                return false;
            }
            case 25: {
                ListIterator lIt = ((UnionType)pType).getElemList().iterator();
                while (lIt.hasNext()) {
                    if (!this.mayAliasBareAndSigned(pType0, this.toBareAndSigned(((Elem)lIt.next()).getSymType()))) continue;
                    return true;
                }
                return false;
            }
            case 21: {
                return this.mayAliasBareAndSigned(pType0, this.symRoot.typeInt);
            }
        }
        throw new AliasError("Unexpected.");
    }

    private static Type toBare(Type pType) {
        Type lType = pType;
        return pType.getFinalOrigin();
    }

    private Type toSigned(Type pType) {
        switch (pType.getTypeKind()) {
            case 8: {
                return this.symRoot.typeChar;
            }
            case 9: {
                return this.symRoot.typeShort;
            }
            case 10: {
                return this.symRoot.typeInt;
            }
            case 11: {
                return this.symRoot.typeLong;
            }
            case 12: {
                return this.symRoot.typeLongLong;
            }
        }
        return pType;
    }

    public Type toBareAndSigned(Type pType) {
        return this.toSigned(AliasUtil.toBare(pType));
    }

    public boolean areCompatible(Type pType, Type pType0) {
        if (!AliasUtil.haveSameQual(pType, pType0)) {
            return false;
        }
        if (pType.getTypeKind() != pType0.getTypeKind()) {
            if (pType.getTypeKind() != 21 && pType0.getTypeKind() != 21) {
                return false;
            }
            if (pType.getTypeKind() == 21) {
                return this.areCompatible(pType0, this.symRoot.typeInt);
            }
            return this.areCompatible(pType, this.symRoot.typeInt);
        }
        if (pType.isBasicType()) {
            return pType.getFinalOrigin() == pType0.getFinalOrigin();
        }
        switch (pType.getTypeKind()) {
            case 23: {
                return (pType.getFlag(11) || pType0.getFlag(11) || ((VectorType)pType).getElemCount() == ((VectorType)pType0).getElemCount()) && this.areCompatible(((VectorType)pType).getElemType(), ((VectorType)pType0).getElemType());
            }
            case 22: {
                return this.areCompatible(((PointerType)pType).getPointedType(), ((PointerType)pType0).getPointedType());
            }
            case 24: 
            case 25: {
                return pType.getFinalOrigin() == pType0.getFinalOrigin();
            }
            case 21: {
                return true;
            }
            case 27: {
                SubpType lSubpType = (SubpType)pType;
                SubpType lSubpType0 = (SubpType)pType0;
                if (lSubpType.getReturnType() != lSubpType0.getReturnType()) {
                    return false;
                }
                if (!lSubpType.getParamTypeList().isEmpty() || !lSubpType.hasOptionalParam()) {
                    if (!lSubpType0.getParamTypeList().isEmpty() || !lSubpType0.hasOptionalParam()) {
                        return this.compBothParamTyped(lSubpType, lSubpType0);
                    }
                    return this.compParamTypedAndNotTyped(lSubpType, lSubpType0);
                }
                if (!lSubpType0.getParamTypeList().isEmpty() || !lSubpType0.hasOptionalParam()) {
                    return this.compParamTypedAndNotTyped(lSubpType0, lSubpType);
                }
                return true;
            }
        }
        throw new AliasError("Unexpected.");
    }

    private static boolean haveSameQual(Type pType, Type pType0) {
        return pType.isConst() == pType0.isConst() && pType.isVolatile() == pType0.isVolatile();
    }

    private boolean compBothParamTyped(SubpType pSubpType, SubpType pSubpType0) {
        if (pSubpType.getParamTypeList().size() != pSubpType0.getParamTypeList().size()) {
            return false;
        }
        ListIterator lIt = pSubpType.getParamTypeList().iterator();
        ListIterator lIt0 = pSubpType0.getParamTypeList().iterator();
        while (lIt.hasNext() && lIt0.hasNext()) {
            if (this.areCompatible(AliasUtil.toBare((Type)lIt.next()), AliasUtil.toBare((Type)lIt0.next()))) continue;
            return false;
        }
        return true;
    }

    private boolean compParamTypedAndNotTyped(SubpType pSubpType, SubpType pSubpType0) {
        if (pSubpType.hasOptionalParam()) {
            return false;
        }
        ListIterator lIt = pSubpType.getParamTypeList().iterator();
        while (lIt.hasNext()) {
            Type lParamType = (Type)lIt.next();
            if (this.areCompatible(AliasUtil.toBare(lParamType), this.daPromo(AliasUtil.toBare(lParamType)))) continue;
            return false;
        }
        return true;
    }

    private Type daPromo(Type pBareType) {
        if (pBareType.isInteger()) {
            return this.iPromo((BaseType)pBareType);
        }
        if (pBareType.getTypeKind() == 16) {
            return this.symRoot.typeDouble;
        }
        return pBareType;
    }

    private Type iPromo(BaseType pType) {
        switch (pType.getTypeKind()) {
            case 3: 
            case 7: {
                if (pType.getSizeValue() <= this.symRoot.typeInt.getSizeValue()) {
                    return this.symRoot.typeInt;
                }
                return this.symRoot.typeU_Int;
            }
            case 8: 
            case 9: {
                if (pType.getSizeValue() < this.symRoot.typeInt.getSizeValue()) {
                    return this.symRoot.typeInt;
                }
                return this.symRoot.typeU_Int;
            }
        }
        return pType;
    }

    static String toString(HIR pHIR) {
        StringBuffer lBuff = new StringBuffer();
        lBuff.append("(");
        lBuff.append(pHIR);
        for (int i = 1; i <= pHIR.getChildCount(); ++i) {
            lBuff.append(AliasUtil.toString((HIR)pHIR.getChild(i)));
        }
        lBuff.append(")");
        return lBuff.toString();
    }

    static boolean subscriptCheck(VectorType pType, int pSubscript) {
        return pType.getLowerBound() <= (long)pSubscript && (long)pSubscript < pType.getLowerBound() + pType.getElemCount();
    }

    public static boolean isScalar(Type pType) {
        int lTypeKind = pType.getTypeKind();
        return lTypeKind >= 1 && lTypeKind <= 22;
    }

    public static Set getComponentScalarTypes(Type pType) {
        HashSet<Type> lResult = new HashSet<Type>();
        if (AliasUtil.isScalar(pType)) {
            lResult.add(pType);
        } else {
            switch (pType.getTypeKind()) {
                case 23: {
                    return AliasUtil.getComponentScalarTypes(((VectorType)pType).getElemType());
                }
                case 24: 
                case 25: {
                    ListIterator lIt = pType.getElemList().iterator();
                    while (lIt.hasNext()) {
                        lResult.addAll(AliasUtil.getComponentScalarTypes(((Elem)lIt.next()).getSymType()));
                    }
                    break;
                }
                default: {
                    throw new AliasError("Unexpected.");
                }
            }
        }
        return lResult;
    }

    public Elem getFirstElem(StructType pStructType) {
        Elem lElem = (Elem)pStructType.getElemList().get(0);
        if (lElem.evaluateDisp() != 0L) {
            throw new AliasError("Unexpected.");
        }
        return lElem;
    }

    public static boolean areWeakCompatible(Type pType, Type pType0) {
        throw new AliasError();
    }

    public void dbg(int pLevel, String pHeader, Object pBody) {
        String lStr;
        String string = lStr = pBody == null ? "null" : pBody.toString();
        if (this.io.getCompileSpecification().getTrace().getTraceLevel("Alias") >= pLevel) {
            this.io.printOut.print(" " + pHeader + " " + lStr);
            this.io.printOut.println();
        }
    }
}

