/*
 * Decompiled with CFR 0.152.
 */
package coins.alias.util;

import coins.alias.util.BitVectorIterator;

public class BitVector {
    protected final long[] fVectorWord;
    protected final int fLongWordLength;
    protected final int fBitLength;
    protected static final int fShiftMax = 63;
    private final int fRemainingBits;

    public BitVector(int pBitLength) {
        this.fBitLength = pBitLength;
        this.fLongWordLength = (this.fBitLength + 63) / 64;
        this.fRemainingBits = 64 * this.fLongWordLength - this.fBitLength;
        this.fVectorWord = new long[this.fLongWordLength];
    }

    public void setBit(int pInx) {
        int lWord = pInx / 64;
        int lInx = pInx - lWord * 64;
        this.fVectorWord[lWord] = this.fVectorWord[lWord] | 1L << 63 - lInx;
    }

    public void resetBit(int pInx) {
        int lWord = pInx / 64;
        int lInx = pInx - lWord * 64;
        long lMask = 1L << 63 - lInx ^ 0xFFFFFFFFFFFFFFFFL;
        this.fVectorWord[lWord] = this.fVectorWord[lWord] & lMask;
    }

    public int getBit(int pInx) {
        int lWord = pInx / 64;
        int lInx = pInx - lWord * 64;
        int lBit = (int)(this.fVectorWord[lWord] >>> 63 - lInx & 1L);
        return lBit;
    }

    public boolean isSet(int pInx) {
        return this.getBit(pInx) == 1;
    }

    public boolean isZero() {
        for (int i = 0; i < this.fLongWordLength - 1; ++i) {
            if (this.fVectorWord[i] == 0L) continue;
            return false;
        }
        return this.fVectorWord[this.fLongWordLength - 1] >>> this.fRemainingBits == 0L;
    }

    public int getBitLength() {
        return this.fBitLength;
    }

    public long[] getVectorWord() {
        return this.fVectorWord;
    }

    public int getWordLength() {
        return this.fLongWordLength;
    }

    public BitVectorIterator bitVectorIterator() {
        return new BitVectorIterator(this);
    }

    public BitVector vectorNot(BitVector pResult) {
        for (int i = 0; i < this.fLongWordLength; ++i) {
            pResult.fVectorWord[i] = this.fVectorWord[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return pResult;
    }

    public BitVector vectorAnd(BitVector pOperand2, BitVector pResult) {
        for (int i = 0; i < this.fLongWordLength; ++i) {
            pResult.fVectorWord[i] = this.fVectorWord[i] & pOperand2.fVectorWord[i];
        }
        return pResult;
    }

    public BitVector vectorOr(BitVector pOperand2, BitVector pResult) {
        for (int i = 0; i < this.fLongWordLength; ++i) {
            pResult.fVectorWord[i] = this.fVectorWord[i] | pOperand2.fVectorWord[i];
        }
        return pResult;
    }

    public BitVector vectorXor(BitVector pOperand2, BitVector pResult) {
        for (int i = 0; i < this.fLongWordLength; ++i) {
            pResult.fVectorWord[i] = this.fVectorWord[i] ^ pOperand2.fVectorWord[i];
        }
        return pResult;
    }

    public BitVector vectorSub(BitVector pOperand2, BitVector pResult) {
        for (int i = 0; i < this.fLongWordLength; ++i) {
            pResult.fVectorWord[i] = this.fVectorWord[i] & (pOperand2.fVectorWord[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return pResult;
    }

    public BitVector vectorCopy(BitVector pResult) {
        for (int i = 0; i < this.fLongWordLength; ++i) {
            pResult.fVectorWord[i] = this.fVectorWord[i];
        }
        return pResult;
    }

    public boolean vectorEqual(BitVector pOperand2) {
        for (int i = 0; i < this.fLongWordLength - 1; ++i) {
            if (this.fVectorWord[i] == pOperand2.fVectorWord[i]) continue;
            return false;
        }
        return this.fVectorWord[this.fLongWordLength - 1] >>> this.fRemainingBits == pOperand2.fVectorWord[this.fLongWordLength - 1] >>> this.fRemainingBits;
    }

    public boolean equals(Object pObject) {
        return pObject instanceof BitVector && ((BitVector)pObject).fBitLength == this.fBitLength && this.vectorEqual((BitVector)pObject);
    }

    public BitVector vectorReset() {
        for (int i = 0; i < this.fLongWordLength; ++i) {
            this.fVectorWord[i] = 0L;
        }
        return this;
    }

    public String toString() {
        StringBuffer lBuffer = new StringBuffer(" ");
        for (int i = 0; i < this.fBitLength; ++i) {
            if (this.getBit(i) != 1) continue;
            lBuffer.append(" " + i);
        }
        return lBuffer.toString().intern();
    }

    public String toStringDescriptive() {
        return this.toString();
    }
}

