/*
 * Decompiled with CFR 0.152.
 */
package coins.ast.expr;

import coins.ast.Expr;
import coins.ast.TypeDecoder;
import coins.ast.Visitor;
import coins.ast.expr.LvalueExpr;
import coins.ast.expr.UnaryExpr;

public class DereferenceExpr
extends UnaryExpr
implements LvalueExpr {
    private byte[] type;

    public DereferenceExpr(Expr expr, byte[] _type) {
        super(expr);
        this.type = _type;
    }

    public void accept(Visitor v) {
        v.atDereferenceExpr(this);
    }

    public byte[] getType() {
        return this.type;
    }

    public boolean isLvalue() {
        return !TypeDecoder.isArrayOrFunction(this.type, 0);
    }

    public boolean hasAddress() {
        return true;
    }

    public int operatorId() {
        return 42;
    }

    public String operatorName() {
        return "*";
    }

    protected String getTag() {
        return "*@";
    }
}

