/*
 * Decompiled with CFR 0.152.
 */
package coins.ast.expr;

import coins.ast.Aggregate;
import coins.ast.Declarator;
import coins.ast.Expr;
import coins.ast.TokenId;
import coins.ast.TypeDecoder;
import coins.ast.Visitor;
import coins.ast.expr.LvalueExpr;
import coins.ast.expr.UnaryExpr;

public class MemberExpr
extends UnaryExpr
implements TokenId,
LvalueExpr {
    private boolean arrow;
    private String memberName;
    private Aggregate memberDef;
    private Declarator memberDecl;

    public MemberExpr(Expr expr, boolean _arrow, String member, Aggregate def, Declarator d) {
        super(expr);
        this.arrow = _arrow;
        this.memberName = member;
        this.memberDef = def;
        this.memberDecl = d;
    }

    public void accept(Visitor v) {
        v.atMemberExpr(this);
    }

    public byte[] getType() {
        return this.memberDecl.getType();
    }

    public boolean isLvalue() {
        if (TypeDecoder.isArray(this.memberDecl.getType(), 0)) {
            return false;
        }
        if (this.arrow) {
            return true;
        }
        return this.expr instanceof LvalueExpr && ((LvalueExpr)this.expr).isLvalue();
    }

    public boolean hasAddress() {
        return true;
    }

    public String name() {
        return this.memberName;
    }

    public Aggregate getStructure() {
        return this.memberDef;
    }

    public Declarator getMember() {
        return this.memberDecl;
    }

    public int operatorId() {
        if (this.arrow) {
            return 371;
        }
        return 46;
    }

    public String operatorName() {
        if (this.arrow) {
            return "->";
        }
        return ".";
    }

    protected String getTag() {
        return this.operatorName() + this.memberName;
    }
}

