/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.ana;

import coins.backend.Function;
import coins.backend.LocalAnalysis;
import coins.backend.ana.DFST;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;

public abstract class DataFlowAnalysis
implements LocalAnalysis {
    protected int timeStamp;
    protected Function function;
    protected boolean isForward;

    public DataFlowAnalysis(Function f) {
        this.function = f;
        FlowGraph g = f.flowGraph();
        this.timeStamp = f.timeStamp();
        DFST dfst = (DFST)this.function.require(DFST.analyzer);
        BasicBlk[] blks = dfst.blkVectorByPre();
        int maxDfn = dfst.maxDfn;
        int idBound = g.idBound();
        this.initialize();
        boolean changed = true;
        while (changed) {
            int i;
            changed = false;
            if (this.isForward) {
                for (i = 1; i <= maxDfn; ++i) {
                    this.confluence(blks[i]);
                    changed |= this.transfer(blks[i]);
                }
                continue;
            }
            for (i = maxDfn; i >= 1; --i) {
                this.confluence(blks[i]);
                changed |= this.transfer(blks[i]);
            }
        }
        this.windUp();
    }

    public boolean isUpToDate() {
        return this.timeStamp == this.function.timeStamp();
    }

    abstract void initialize();

    abstract void confluence(BasicBlk var1);

    abstract boolean transfer(BasicBlk var1);

    abstract void windUp();
}

