/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.ana;

import coins.backend.Function;
import coins.backend.LocalAnalysis;
import coins.backend.LocalAnalyzer;
import coins.backend.ana.DFST;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirNode;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import java.io.PrintWriter;
import java.util.Iterator;

public class Dominators
implements LocalAnalysis {
    public static final Analyzer analyzer = new Analyzer();
    public final BasicBlk[] idom;
    public final BiList[] kids;
    private Function function;
    private FlowGraph flowGraph;
    private int timeStamp;
    private DFST dfst;

    private Dominators(Function f) {
        int i;
        boolean change;
        this.function = f;
        this.flowGraph = f.flowGraph();
        this.dfst = (DFST)this.function.require(DFST.analyzer);
        this.timeStamp = this.flowGraph.timeStamp();
        int maxDfn = this.dfst.maxDfn;
        int idBound = this.flowGraph.idBound();
        int[] widom = new int[maxDfn + 1];
        BasicBlk[] blkdfn = new BasicBlk[maxDfn + 1];
        BiLink p = this.flowGraph.basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            if (this.dfst.dfn[blk.id] != 0) {
                blkdfn[this.dfst.dfn[blk.id]] = blk;
                if (this.dfst.parent[blk.id] != null) {
                    widom[this.dfst.dfn[blk.id]] = this.dfst.dfn[this.dfst.parent[blk.id].id];
                }
            }
            p = p.next();
        }
        do {
            change = false;
            for (i = 2; i <= maxDfn; ++i) {
                int x = widom[i];
                BiLink p2 = blkdfn[i].predList().first();
                while (!p2.atEnd()) {
                    int y = this.dfst.dfn[((BasicBlk)p2.elem()).id];
                    while (x != y) {
                        if (x > y) {
                            x = widom[x];
                            continue;
                        }
                        y = widom[y];
                    }
                    p2 = p2.next();
                }
                if (x == widom[i] || x == 0) continue;
                widom[i] = x;
                change = true;
            }
        } while (change);
        this.idom = new BasicBlk[idBound];
        for (i = 1; i <= maxDfn; ++i) {
            this.idom[blkdfn[i].id] = blkdfn[widom[i]];
        }
        this.kids = new BiList[idBound];
        BiLink p3 = this.flowGraph.basicBlkList.first();
        while (!p3.atEnd()) {
            this.kids[((BasicBlk)p3.elem()).id] = new BiList();
            p3 = p3.next();
        }
        for (int i2 = 1; i2 <= maxDfn; ++i2) {
            if (widom[i2] == 0) continue;
            this.kids[blkdfn[widom[i2]].id].add(blkdfn[i2]);
        }
    }

    public boolean isUpToDate() {
        return this.timeStamp == this.flowGraph.timeStamp();
    }

    public BasicBlk immDominator(BasicBlk blk) {
        return this.idom[blk.id];
    }

    public Iterator children(BasicBlk blk) {
        return this.kids[blk.id].iterator();
    }

    public boolean dominates(BasicBlk x, BasicBlk y) {
        while (this.dfst.dfn[y.id] > this.dfst.dfn[x.id]) {
            y = this.idom[y.id];
        }
        return y == x;
    }

    public void printBeforeFunction(PrintWriter output) {
    }

    public void printBeforeBlock(BasicBlk blk, PrintWriter output) {
    }

    public void printAfterBlock(BasicBlk blk, PrintWriter output) {
    }

    public void printBeforeStmt(LirNode stmt, PrintWriter output) {
    }

    public void printAfterStmt(LirNode stmt, PrintWriter output) {
    }

    public void printAfterFunction(PrintWriter out) {
        out.println();
        out.println("Dominator Tree:");
        this.dumpIt(this.flowGraph.entryBlk(), "", "", out);
    }

    public void printIt(PrintWriter out) {
        out.println();
        out.println("Dominator Tree:");
        this.dumpIt(this.flowGraph.entryBlk(), "", "", out);
    }

    private void dumpIt(BasicBlk blk, String pref1, String pref2, PrintWriter out) {
        out.print(pref1);
        if (pref2.length() > 0) {
            out.print(" +-");
        }
        out.print("#" + blk.id);
        if (!this.kids[blk.id].isEmpty()) {
            out.print("'s children: ");
        }
        boolean first = true;
        BiLink p = this.kids[blk.id].first();
        while (!p.atEnd()) {
            out.print(first ? "#" : ",#");
            out.print(((BasicBlk)p.elem()).id);
            first = false;
            p = p.next();
        }
        out.println();
        String pref = pref1 + pref2;
        BiLink p2 = this.kids[blk.id].first();
        while (!p2.atEnd()) {
            this.dumpIt((BasicBlk)p2.elem(), pref, p2.next().atEnd() ? "   " : " | ", out);
            p2 = p2.next();
        }
    }

    private static class Analyzer
    implements LocalAnalyzer {
        private Analyzer() {
        }

        public LocalAnalysis doIt(Function func) {
            return new Dominators(func);
        }

        public String name() {
            return "Dominators";
        }
    }
}

