/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.ana;

import coins.backend.CollectVarInTree;
import coins.backend.Function;
import coins.backend.LocalAnalysis;
import coins.backend.LocalAnalyzer;
import coins.backend.ana.DataFlowAnalysis;
import coins.backend.ana.EnumRegVars;
import coins.backend.ana.LiveVariableAnalysis;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNode;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.BitMapSet;
import coins.backend.util.NumberSet;
import java.io.PrintWriter;

public class LiveVariableBitMap
extends DataFlowAnalysis
implements LiveVariableAnalysis {
    public static final Analyzer analyzer = new Analyzer();
    private BitMapSet[] in;
    private BitMapSet[] out;
    private BitMapSet[] gen;
    private BitMapSet[] kill;
    private EnumRegVars rn;

    private LiveVariableBitMap(Function f) {
        super(f);
    }

    public boolean isLiveAtEntry(Symbol regvar, BasicBlk blk) {
        return this.in[blk.id].contains(this.rn.index(regvar));
    }

    public boolean isLiveAtEntry(int regvar, BasicBlk blk) {
        return this.in[blk.id].contains(regvar);
    }

    public boolean isLiveAtExit(Symbol regvar, BasicBlk blk) {
        return this.out[blk.id].contains(this.rn.index(regvar));
    }

    public boolean isLiveAtExit(int regvar, BasicBlk blk) {
        return this.out[blk.id].contains(regvar);
    }

    public BiList liveOut(BasicBlk blk) {
        BiList live = new BiList();
        NumberSet.Iterator it = this.out[blk.id].iterator();
        while (it.hasNext()) {
            live.add(this.rn.toSymbol(it.next()));
        }
        return live;
    }

    public BiList liveIn(BasicBlk blk) {
        BiList live = new BiList();
        NumberSet.Iterator it = this.in[blk.id].iterator();
        while (it.hasNext()) {
            live.add(this.rn.toSymbol(it.next()));
        }
        return live;
    }

    public NumberSet liveInSet(BasicBlk blk) {
        return this.in[blk.id];
    }

    public NumberSet liveOutSet(BasicBlk blk) {
        return this.out[blk.id];
    }

    public void getLiveOutSet(NumberSet x, BasicBlk blk) {
        x.copy(this.out[blk.id]);
    }

    public void addLiveOutSet(NumberSet x, BasicBlk blk) {
        x.addAll(this.out[blk.id]);
    }

    public void getLiveInSet(NumberSet x, BasicBlk blk) {
        x.copy(this.in[blk.id]);
    }

    public void addLiveInSet(NumberSet x, BasicBlk blk) {
        x.addAll(this.in[blk.id]);
    }

    void initialize() {
        this.isForward = false;
        int maxBlks = this.function.flowGraph().idBound();
        this.rn = (EnumRegVars)this.function.require(EnumRegVars.analyzer);
        int nRegvars = this.rn.nRegvars();
        CollectVarInTree cv = new CollectVarInTree(this.function);
        this.in = new BitMapSet[maxBlks];
        this.out = new BitMapSet[maxBlks];
        this.kill = new BitMapSet[maxBlks];
        this.gen = new BitMapSet[maxBlks];
        for (int i = 0; i < maxBlks; ++i) {
            this.in[i] = new BitMapSet(nRegvars);
            this.out[i] = new BitMapSet(nRegvars);
        }
        BitMapSet w = new BitMapSet(nRegvars);
        BiLink p = this.function.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            this.kill[blk.id] = new BitMapSet(nRegvars);
            this.gen[blk.id] = new BitMapSet(nRegvars);
            BiLink q = blk.instrList().last();
            while (!q.atEnd()) {
                LirNode stmt = (LirNode)q.elem();
                if (stmt.opCode != 59) {
                    cv.getDefVars(stmt, w);
                    this.kill[blk.id].addAll(w);
                    this.gen[blk.id].removeAll(w);
                    cv.getUseVars(stmt, w);
                    this.kill[blk.id].removeAll(w);
                    this.gen[blk.id].addAll(w);
                }
                q = q.prev();
            }
            p = p.next();
        }
    }

    void confluence(BasicBlk blk) {
        this.out[blk.id].clear();
        BiLink s = blk.succList().first();
        while (!s.atEnd()) {
            BasicBlk succ = (BasicBlk)s.elem();
            this.out[blk.id].join(this.in[succ.id]);
            BiLink q = succ.instrList().first();
            while (!q.atEnd()) {
                LirNode stmt = (LirNode)q.elem();
                if (stmt.opCode != 59) break;
                if (this.out[blk.id].exist(this.rn.index(stmt.kid(0)))) {
                    int n = stmt.nKids();
                    for (int i = 1; i < n; ++i) {
                        if (stmt.kid((int)i).kid((int)1).opCode != 8 || ((LirLabelRef)stmt.kid((int)i).kid((int)1)).label != blk.label() || stmt.kid((int)i).kid((int)0).opCode != 6) continue;
                        this.out[blk.id].add(this.rn.index(stmt.kid(i).kid(0)));
                    }
                }
                this.out[blk.id].remove(this.rn.index(stmt.kid(0)));
                q = q.next();
            }
            s = s.next();
        }
    }

    boolean transfer(BasicBlk blk) {
        BitMapSet newin = (BitMapSet)this.out[blk.id].clone();
        newin.subtract(this.kill[blk.id]);
        newin.join(this.gen[blk.id]);
        boolean changed = !newin.equals(this.in[blk.id]);
        this.in[blk.id] = newin;
        return changed;
    }

    void windUp() {
    }

    private void printLive(String head, NumberSet live, PrintWriter output) {
        output.print(head);
        NumberSet.Iterator it = live.iterator();
        while (it.hasNext()) {
            output.print(" " + this.rn.toString(it.next()));
        }
        output.println();
    }

    public void printBeforeFunction(PrintWriter output) {
    }

    public void printBeforeBlock(BasicBlk blk, PrintWriter output) {
        this.printLive("   kill:", this.kill[blk.id], output);
        this.printLive("    gen:", this.gen[blk.id], output);
        this.printLive("    in:", this.in[blk.id], output);
    }

    public void printAfterBlock(BasicBlk blk, PrintWriter output) {
        this.printLive("   out:", this.out[blk.id], output);
    }

    public void printBeforeStmt(LirNode stmt, PrintWriter output) {
    }

    public void printAfterStmt(LirNode stmt, PrintWriter output) {
    }

    public void printAfterFunction(PrintWriter output) {
    }

    private static class Analyzer
    implements LocalAnalyzer {
        private Analyzer() {
        }

        public LocalAnalysis doIt(Function func) {
            return new LiveVariableBitMap(func);
        }

        public String name() {
            return "LiveVariableBitMap";
        }
    }
}

