/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.asmpp;

import coins.backend.asmpp.LtorgInstruction;
import coins.backend.asmpp.Mnemo;

class LiteralInstruction
extends Mnemo {
    String literal;
    LtorgInstruction ltorg;

    LiteralInstruction(String line, String literal) {
        super(line);
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        String s = super.toString() + "\t" + this.literal;
        if (this.ltorg != null) {
            s = s + " -> " + this.ltorg.toLabel(this.literal);
        }
        return s;
    }

    public String generate() {
        int index = this.line.indexOf(this.literal);
        String s = this.ltorg != null ? this.ltorg.toLabel(this.literal) : this.literal;
        return this.line.substring(0, index) + s + this.line.substring(index + this.literal.length());
    }

    public int getLiteralSize() {
        int v = 1 << LiteralInstruction.cpu.codeAlign;
        if (this.literal.startsWith("=B")) {
            return 1 + v - 1 & -v;
        }
        if (this.literal.startsWith("=S")) {
            return 2 + v - 1 & -v;
        }
        if (this.literal.startsWith("=D")) {
            return 8 + v - 1 & -v;
        }
        return 4 + v - 1 & -v;
    }

    public void setLtorg(LtorgInstruction ltorg) {
        this.ltorg = ltorg;
    }
}

